/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.attachment;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.attachment.v1.AttachmentRegistry;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.fabricmc.fabric.impl.attachment.AttachmentTypeImpl;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AttachmentRegistryImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"fabric-data-attachment-api-v1");
    private static final Map<class_2960, AttachmentType<?>> attachmentRegistry = new HashMap();

    public static <A> void register(class_2960 id, AttachmentType<A> attachmentType) {
        AttachmentType<A> existing = attachmentRegistry.put(id, attachmentType);
        if (existing != null) {
            LOGGER.warn("Encountered duplicate type registration for id " + String.valueOf(id));
        }
    }

    @Nullable
    public static AttachmentType<?> get(class_2960 id) {
        return attachmentRegistry.get(id);
    }

    public static <A> AttachmentRegistry.Builder<A> builder() {
        return new BuilderImpl();
    }

    public static class BuilderImpl<A>
    implements AttachmentRegistry.Builder<A> {
        @Nullable
        private Supplier<A> defaultInitializer = null;
        @Nullable
        private Codec<A> persistenceCodec = null;
        private boolean copyOnDeath = false;

        @Override
        public AttachmentRegistry.Builder<A> persistent(Codec<A> codec) {
            Objects.requireNonNull(codec, "codec cannot be null");
            this.persistenceCodec = codec;
            return this;
        }

        @Override
        public AttachmentRegistry.Builder<A> copyOnDeath() {
            this.copyOnDeath = true;
            return this;
        }

        @Override
        public AttachmentRegistry.Builder<A> initializer(Supplier<A> initializer) {
            Objects.requireNonNull(initializer, "initializer cannot be null");
            this.defaultInitializer = initializer;
            return this;
        }

        @Override
        public AttachmentType<A> buildAndRegister(class_2960 id) {
            AttachmentTypeImpl<A> attachment = new AttachmentTypeImpl<A>(id, this.defaultInitializer, this.persistenceCodec, this.copyOnDeath);
            AttachmentRegistryImpl.register(id, attachment);
            return attachment;
        }
    }
}

