/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.chunk.loading.mixin;

import io.github.fabricators_of_create.porting_lib.chunk.loading.extensions.DistanceManagerExtension;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.minecraft.class_1923;
import net.minecraft.class_3204;
import net.minecraft.class_3228;
import net.minecraft.class_3230;
import net.minecraft.class_4706;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_3204.class})
public abstract class DistanceManagerMixin
implements DistanceManagerExtension {
    private final Long2ObjectOpenHashMap<class_4706<class_3228<?>>> forcedTickets = new Long2ObjectOpenHashMap();
    private final ThreadLocal<Boolean> forceTicksToggle = ThreadLocal.withInitial(() -> false);

    @Shadow
    public abstract <T> void method_17291(class_3230<T> var1, class_1923 var2, int var3, T var4);

    @Shadow
    public abstract <T> void method_17292(class_3230<T> var1, class_1923 var2, int var3, T var4);

    @Override
    public <T> void addRegionTicket(class_3230<T> pType, class_1923 pPos, int pDistance, T pValue, boolean forceTicks) {
        this.forceTicksToggle.set(forceTicks);
        this.method_17291(pType, pPos, pDistance, pValue);
        this.forceTicksToggle.set(false);
    }

    @Override
    public <T> void removeRegionTicket(class_3230<T> pType, class_1923 pPos, int pDistance, T pValue, boolean forceTicks) {
        this.forceTicksToggle.set(forceTicks);
        this.method_17292(pType, pPos, pDistance, pValue);
        this.forceTicksToggle.set(false);
    }

    @Override
    public boolean shouldForceTicks(long chunkPos) {
        class_4706 tickets = (class_4706)this.forcedTickets.get(chunkPos);
        return tickets != null && !tickets.isEmpty();
    }

    @Inject(method={"addRegionTicket", "removeRegionTicket"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/ChunkPos;toLong()J")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private <T> void setForcedTicket(class_3230<T> type, class_1923 pos, int distance, T value, CallbackInfo ci, class_3228<T> ticket) {
        ticket.setForceTicks(this.forceTicksToggle.get().booleanValue());
    }

    @Inject(method={"addTicket(JLnet/minecraft/server/level/Ticket;)V"}, at={@At(value="TAIL")})
    private void addForcedTicket(long chunkPos, class_3228<?> ticket, CallbackInfo ci) {
        if (ticket.isForceTicks()) {
            class_4706 tickets = (class_4706)this.forcedTickets.computeIfAbsent(chunkPos, e -> class_4706.method_23859((int)4));
            tickets.method_23862(ticket);
        }
    }

    @Inject(method={"removeTicket(JLnet/minecraft/server/level/Ticket;)V"}, at={@At(value="TAIL")})
    private void removeForcedTicket(long chunkPos, class_3228<?> ticket, CallbackInfo ci) {
        class_4706 tickets;
        if (ticket.isForceTicks() && (tickets = (class_4706)this.forcedTickets.get(chunkPos)) != null) {
            tickets.remove(ticket);
        }
    }
}

