/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.telluriumforge.util;

import java.util.function.Consumer;
import java.util.function.Supplier;

public class CachedObject<T>
implements Supplier<T> {
    private final T obj;

    private CachedObject(T obj) {
        this.obj = obj;
    }

    private CachedObject() {
        this.obj = null;
    }

    public static CachedObject<?> of(Object obj) {
        return new CachedObject<Object>(obj);
    }

    public static CachedObject<?> empty() {
        return new CachedObject();
    }

    @Override
    public T get() {
        return this.obj;
    }

    public boolean isEmpty() {
        return this.obj == null;
    }

    public boolean isPresent() {
        return !this.isEmpty();
    }

    public void ifPresent(Consumer<T> consumer) {
        if (this.isPresent()) {
            consumer.accept(this.get());
        }
    }
}

