/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.telluriumforge.config.writer;

import com.mikitellurium.telluriumforge.config.writer.EntryWriter;
import java.io.FileWriter;
import java.io.IOException;
import org.slf4j.Logger;

public final class EntryWriterImpl
implements EntryWriter {
    private final FileWriter writer;
    private final String filePath;
    private final Logger logger;

    public EntryWriterImpl(FileWriter writer, String filePath, Logger logger) {
        this.writer = writer;
        this.filePath = filePath;
        this.logger = logger;
    }

    @Override
    public void write(String s) {
        try {
            this.writer.write(s);
        }
        catch (IOException e) {
            this.logger.error("Something went wrong when trying to write config file \"{}\"", (Object)this.filePath, (Object)e);
        }
    }

    @Override
    public void writeLine(String s) {
        this.write(s + System.lineSeparator());
    }

    @Override
    public void writeComment(String comment) {
        this.writeLine("# " + comment);
    }
}

