/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.telluriumforge.config;

import com.mikitellurium.telluriumforge.config.BooleanConfigEntry;
import com.mikitellurium.telluriumforge.config.EnumConfigEntry;
import com.mikitellurium.telluriumforge.config.IConfigEntry;
import com.mikitellurium.telluriumforge.config.NumberConfigEntry;
import com.mikitellurium.telluriumforge.config.RangedConfigEntry;
import com.mikitellurium.telluriumforge.config.StringConfigEntry;
import com.mikitellurium.telluriumforge.config.writer.EntryWriterImpl;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TelluriumConfig {
    private static final String fileExtension = ".properties";
    private final Logger logger;
    private final String file;
    private final Type type;
    private final List<String> comments = new ArrayList<String>();
    private final List<IConfigEntry<?>> entries = new ArrayList();

    public TelluriumConfig(String fileName, Type type) {
        this.file = FabricLoader.getInstance().getConfigDir().resolve(fileName + "-" + type.getName() + fileExtension).toString();
        this.type = type;
        this.logger = LoggerFactory.getLogger((String)fileName);
    }

    public String getConfigFilePath() {
        return this.file;
    }

    public Type getType() {
        return this.type;
    }

    public IConfigEntry<?> getEntry(String key) {
        for (IConfigEntry<?> entry : this.entries) {
            if (!entry.getKey().equals(key)) continue;
            return entry;
        }
        return null;
    }

    public List<IConfigEntry<?>> getEntries() {
        return this.entries;
    }

    public TelluriumConfig comment(String comment) {
        this.comments.add(comment);
        return this;
    }

    public EntryBuilder entryBuilder() {
        return new EntryBuilder(this);
    }

    public void build() {
        File file = new File(this.file);
        if (file.exists()) {
            this.load();
        }
        this.save();
    }

    public void save() {
        try {
            FileWriter writer = new FileWriter(this.file);
            String newline = System.lineSeparator();
            if (!this.comments.isEmpty()) {
                for (String s : this.comments) {
                    writer.write("# " + s + newline);
                }
            }
            writer.write(newline);
            writer.write("[Settings]" + newline);
            writer.write(newline);
            EntryWriterImpl entryWriter = new EntryWriterImpl(writer, this.getConfigFilePath(), this.logger);
            if (!this.entries.isEmpty()) {
                for (IConfigEntry<?> configEntry : this.entries) {
                    configEntry.writeEntry(entryWriter);
                    writer.write(newline);
                }
            }
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            this.logger.error("Something went wrong when trying to write config file \"{}\"", (Object)this.getConfigFilePath(), (Object)e);
        }
    }

    private void load() {
        try {
            File file = new File(this.file);
            Scanner reader = new Scanner(file);
            int line = 1;
            while (reader.hasNextLine()) {
                this.parseConfigEntry(reader.nextLine(), line);
                ++line;
            }
        }
        catch (IOException e) {
            this.logger.error("Something went wrong when trying to read config file \"{}\"", (Object)this.getConfigFilePath(), (Object)e);
        }
    }

    private <T> void parseConfigEntry(String string, int line) {
        if (!this.isValueLine(string)) {
            return;
        }
        String[] entryParts = string.split("=", 2);
        if (entryParts.length != 2) {
            this.logger.error("Unknown entry found: \"{}\" in config file \"{}\" at line {}.", new Object[]{entryParts[0], this.getConfigFilePath(), line});
            return;
        }
        IConfigEntry<?> configEntry = this.getEntry(entryParts[0]);
        String valueString = entryParts[1];
        if (configEntry == null) {
            this.logger.error("Unknown entry found: \"{}\" in config file \"{}\" at line {}.", new Object[]{entryParts[0], this.getConfigFilePath(), line});
            return;
        }
        try {
            Object value = configEntry.deserialize(valueString);
            configEntry.set(value);
        }
        catch (IllegalArgumentException e) {
            configEntry.set(configEntry.getDefault());
            this.logger.error("Unsupported value type for entry \"{}\". Loaded default value.", (Object)configEntry.getKey(), (Object)e);
        }
    }

    private boolean isValueLine(String line) {
        if (line.isEmpty()) {
            return false;
        }
        return !line.startsWith("#") && !line.startsWith("[");
    }

    public static enum Type {
        COMMON("common"),
        CLIENT("client"),
        SERVER("server");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public class EntryBuilder {
        private final TelluriumConfig parent;
        private final EntryBuilderContext context = new EntryBuilderContext();

        private EntryBuilder(TelluriumConfig parent) {
            this.parent = parent;
        }

        public EntryBuilder comment(String comment) {
            this.context.add(comment);
            return this;
        }

        public <T, E extends IConfigEntry<T>> E define(E configEntry) {
            TelluriumConfig.this.entries.add(configEntry);
            this.buildEntry(configEntry);
            return configEntry;
        }

        public BooleanConfigEntry define(String key, boolean defaultValue) {
            BooleanConfigEntry newEntry = new BooleanConfigEntry(this.parent, key, defaultValue);
            return this.define(newEntry);
        }

        public NumberConfigEntry<Integer> define(String key, int defaultValue) {
            NumberConfigEntry<Integer> newEntry = new NumberConfigEntry<Integer>(this.parent, Integer.class, key, defaultValue);
            return this.define(newEntry);
        }

        public RangedConfigEntry<Integer> defineInRange(String key, int defaultValue, int minValue, int maxValue) {
            RangedConfigEntry<Integer> newEntry = new RangedConfigEntry<Integer>(this.parent, Integer.class, key, defaultValue, minValue, maxValue);
            return this.define(newEntry);
        }

        public NumberConfigEntry<Double> define(String key, double defaultValue) {
            NumberConfigEntry<Double> newEntry = new NumberConfigEntry<Double>(this.parent, Double.class, key, defaultValue);
            return this.define(newEntry);
        }

        public RangedConfigEntry<Double> defineInRange(String key, double defaultValue, double minValue, double maxValue) {
            RangedConfigEntry<Double> newEntry = new RangedConfigEntry<Double>(this.parent, Double.class, key, defaultValue, minValue, maxValue);
            return this.define(newEntry);
        }

        public NumberConfigEntry<Long> define(String key, long defaultValue) {
            NumberConfigEntry<Long> newEntry = new NumberConfigEntry<Long>(this.parent, Long.class, key, defaultValue);
            return this.define(newEntry);
        }

        public RangedConfigEntry<Long> defineInRange(String key, long defaultValue, long minValue, long maxValue) {
            RangedConfigEntry<Long> newEntry = new RangedConfigEntry<Long>(this.parent, Long.class, key, defaultValue, minValue, maxValue);
            return this.define(newEntry);
        }

        public StringConfigEntry define(String key, String defaultValue) {
            StringConfigEntry newEntry = new StringConfigEntry(this.parent, key, defaultValue);
            return this.define(newEntry);
        }

        public <E extends Enum<E>> EnumConfigEntry<E> define(String key, E defaultValue) {
            EnumConfigEntry<E> newEntry = new EnumConfigEntry<E>(this.parent, defaultValue.getDeclaringClass(), key, defaultValue);
            return this.define(newEntry);
        }

        private <T extends IConfigEntry<?>> void buildEntry(T configEntry) {
            List<String> comments = this.context.getComments();
            if (!comments.isEmpty()) {
                for (String s : this.context.getComments()) {
                    configEntry.comment(s);
                }
            }
            this.context.clear();
        }
    }

    private static class EntryBuilderContext {
        private final List<String> comments = new ArrayList<String>();

        private EntryBuilderContext() {
        }

        private void add(String comment) {
            this.comments.add(comment);
        }

        private List<String> getComments() {
            return this.comments;
        }

        private void clear() {
            this.comments.clear();
        }
    }
}

