/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.telluriumforge.config;

import com.mikitellurium.telluriumforge.config.NumberConfigEntry;
import com.mikitellurium.telluriumforge.config.TelluriumConfig;
import com.mikitellurium.telluriumforge.config.writer.EntryWriter;

public class RangedConfigEntry<N extends Number>
extends NumberConfigEntry<N> {
    private final N minValue;
    private final N maxValue;

    protected RangedConfigEntry(TelluriumConfig parent, Class<N> type, String key, N defaultValue, N minValue, N maxValue) {
        super(parent, type, key, defaultValue);
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public N getMinValue() {
        return this.minValue;
    }

    public N getMaxValue() {
        return this.maxValue;
    }

    @Override
    public void set(N value) {
        if (this.compare(value, this.minValue) < 0) {
            super.set(this.minValue);
        } else if (this.compare(value, this.maxValue) > 0) {
            super.set(this.maxValue);
        } else {
            super.set(value);
        }
    }

    private int compare(N value1, N value2) {
        return ((Comparable)value1).compareTo(value2);
    }

    @Override
    public void writeEntry(EntryWriter writer) {
        this.writeComments(writer, this.getComments());
        N minValue = this.getMinValue();
        N maxValue = this.getMaxValue();
        writer.writeComment("Range: min=" + this.serialize(minValue) + ", max=" + this.serialize(maxValue));
        writer.writeComment("Default = " + this.serialize((Number)this.getDefault()));
        writer.writeLine(this.getKey() + "=" + this.serialize((Number)this.get()));
    }
}

