/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.telluriumforge.config;

import com.mikitellurium.telluriumforge.config.ConfigEntry;
import com.mikitellurium.telluriumforge.config.TelluriumConfig;

public class NumberConfigEntry<N extends Number>
extends ConfigEntry<N> {
    protected NumberConfigEntry(TelluriumConfig parent, Class<N> type, String key, N defaultValue) {
        super(parent, type, key, defaultValue);
    }

    @Override
    public String serialize(N value) {
        return String.valueOf(value);
    }

    @Override
    public N deserialize(String string) {
        Class type = this.getType();
        if (type == Integer.class) {
            return (N)((Number)type.cast(Integer.parseInt(string)));
        }
        if (type == Double.class) {
            return (N)((Number)type.cast(Double.parseDouble(string)));
        }
        if (type == Long.class) {
            return (N)((Number)type.cast(Long.parseLong(string)));
        }
        throw new IllegalStateException("Unsupported number type: " + type);
    }
}

