/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.telluriumforge.config;

import com.mikitellurium.telluriumforge.config.ConfigEntry;
import com.mikitellurium.telluriumforge.config.TelluriumConfig;
import com.mikitellurium.telluriumforge.config.writer.EntryWriter;

public class EnumConfigEntry<E extends Enum<E>>
extends ConfigEntry<E> {
    protected EnumConfigEntry(TelluriumConfig parent, Class<E> type, String key, E defaultValue) {
        super(parent, type, key, defaultValue);
    }

    @Override
    public String serialize(E value) {
        return ((Enum)value).name();
    }

    @Override
    public E deserialize(String string) {
        return (E)Enum.valueOf(this.getType(), string);
    }

    @Override
    public void writeEntry(EntryWriter writer) {
        Enum[] constants;
        this.writeComments(writer, this.getComments());
        writer.write("# Options: ");
        for (Enum constant : constants = (Enum[])this.getType().getEnumConstants()) {
            writer.write(this.serialize((E)constant));
            if (!constants[constants.length - 1].equals(constant)) {
                writer.write(", ");
                continue;
            }
            writer.write(System.lineSeparator());
        }
        writer.writeComment("Default = " + this.serialize((E)((Enum)this.getDefault())));
        writer.writeLine(this.getKey() + "=" + this.serialize((E)((Enum)this.get())));
    }
}

