/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.telluriumforge.config;

import com.mikitellurium.telluriumforge.config.IConfigEntry;
import com.mikitellurium.telluriumforge.config.TelluriumConfig;
import com.mikitellurium.telluriumforge.config.writer.EntryWriter;
import java.util.ArrayList;
import java.util.List;

public abstract class ConfigEntry<T>
implements IConfigEntry<T> {
    private final TelluriumConfig builder;
    private final List<String> comments = new ArrayList<String>();
    private final Class<T> type;
    private final String key;
    private final T defaultValue;
    private T value;

    protected ConfigEntry(TelluriumConfig parent, Class<T> type, String key, T defaultValue) {
        this.builder = parent;
        this.type = type;
        this.key = key;
        this.defaultValue = defaultValue;
    }

    @Override
    public TelluriumConfig getParentConfig() {
        return this.builder;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public T getDefault() {
        return this.defaultValue;
    }

    @Override
    public T get() {
        return this.value != null ? this.value : this.defaultValue;
    }

    @Override
    public void set(T value) {
        this.value = value;
    }

    @Override
    public <E extends IConfigEntry<T>> E comment(String comment) {
        this.comments.add(comment);
        return (E)this;
    }

    @Override
    public List<String> getComments() {
        return this.comments;
    }

    @Override
    public void writeEntry(EntryWriter writer) {
        this.writeComments(writer, this.getComments());
        writer.writeComment("Default = " + this.serialize(this.getDefault()));
        writer.writeLine(this.getKey() + "=" + this.serialize(this.get()));
    }

    protected void writeComments(EntryWriter writer, List<String> comments) {
        if (!comments.isEmpty()) {
            for (String c : comments) {
                writer.writeComment(c);
            }
        }
    }
}

