/*
 * Decompiled with CFR 0.152.
 */
package myron.shaded.de.javagl.obj;

import myron.shaded.de.javagl.obj.DefaultObjFace;
import myron.shaded.de.javagl.obj.ObjFace;

public class ObjFaces {
    static DefaultObjFace create(ObjFace face) {
        int i;
        int[] v = new int[face.getNumVertices()];
        int[] vt = null;
        int[] vn = null;
        for (i = 0; i < face.getNumVertices(); ++i) {
            v[i] = face.getVertexIndex(i);
        }
        if (face.containsTexCoordIndices()) {
            vt = new int[face.getNumVertices()];
            for (i = 0; i < face.getNumVertices(); ++i) {
                vt[i] = face.getTexCoordIndex(i);
            }
        }
        if (face.containsNormalIndices()) {
            vn = new int[face.getNumVertices()];
            for (i = 0; i < face.getNumVertices(); ++i) {
                vn[i] = face.getNormalIndex(i);
            }
        }
        DefaultObjFace result = new DefaultObjFace(v, vt, vn);
        return result;
    }

    static DefaultObjFace createWithOffsets(ObjFace face, int verticesOffset, int texCoordsOffset, int normalsOffset) {
        int i;
        int[] v = new int[face.getNumVertices()];
        int[] vt = null;
        int[] vn = null;
        for (i = 0; i < face.getNumVertices(); ++i) {
            v[i] = face.getVertexIndex(i) + verticesOffset;
        }
        if (face.containsTexCoordIndices()) {
            vt = new int[face.getNumVertices()];
            for (i = 0; i < face.getNumVertices(); ++i) {
                vt[i] = face.getTexCoordIndex(i) + texCoordsOffset;
            }
        }
        if (face.containsNormalIndices()) {
            vn = new int[face.getNumVertices()];
            for (i = 0; i < face.getNumVertices(); ++i) {
                vn[i] = face.getNormalIndex(i) + normalsOffset;
            }
        }
        DefaultObjFace result = new DefaultObjFace(v, vt, vn);
        return result;
    }

    static DefaultObjFace create(ObjFace face, int ... n) {
        int i;
        int[] v = new int[n.length];
        int[] vt = null;
        int[] vn = null;
        for (i = 0; i < n.length; ++i) {
            v[i] = face.getVertexIndex(n[i]);
        }
        if (face.containsTexCoordIndices()) {
            vt = new int[n.length];
            for (i = 0; i < n.length; ++i) {
                vt[i] = face.getTexCoordIndex(n[i]);
            }
        }
        if (face.containsNormalIndices()) {
            vn = new int[n.length];
            for (i = 0; i < n.length; ++i) {
                vn[i] = face.getNormalIndex(n[i]);
            }
        }
        DefaultObjFace result = new DefaultObjFace(v, vt, vn);
        return result;
    }

    public static ObjFace create(int[] v, int[] vt, int[] vn) {
        return ObjFaces.createDefault(v, vt, vn);
    }

    static DefaultObjFace createDefault(int[] v, int[] vt, int[] vn) {
        DefaultObjFace result = new DefaultObjFace(v, vt, vn);
        return result;
    }

    public static String createString(ObjFace face) {
        StringBuilder sb = new StringBuilder("f ");
        for (int i = 0; i < face.getNumVertices(); ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(face.getVertexIndex(i) + 1);
            if (face.containsTexCoordIndices() || face.containsNormalIndices()) {
                sb.append("/");
            }
            if (face.containsTexCoordIndices()) {
                sb.append(face.getTexCoordIndex(i) + 1);
            }
            if (!face.containsNormalIndices()) continue;
            sb.append("/").append(face.getNormalIndex(i) + 1);
        }
        return sb.toString();
    }

    private ObjFaces() {
    }
}

