/*
 * Decompiled with CFR 0.152.
 */
package myron.shaded.de.javagl.obj;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import myron.shaded.de.javagl.obj.FloatTuples;
import myron.shaded.de.javagl.obj.Mtl;

public class MtlWriter {
    public static void write(Iterable<? extends Mtl> mtls, OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        MtlWriter.write(mtls, (Writer)outputStreamWriter);
    }

    public static void write(Iterable<? extends Mtl> mtls, Writer writer) throws IOException {
        for (Mtl mtl : mtls) {
            MtlWriter.write(mtl, writer);
        }
    }

    private static void write(Mtl mtl, Writer writer) throws IOException {
        writer.write("newmtl " + mtl.getName() + "\n");
        writer.write("Ka " + FloatTuples.createString(mtl.getKa()) + "\n");
        writer.write("Kd " + FloatTuples.createString(mtl.getKd()) + "\n");
        writer.write("Ks " + FloatTuples.createString(mtl.getKs()) + "\n");
        if (mtl.getMapKd() != null) {
            writer.write("map_Kd " + mtl.getMapKd() + "\n");
        }
        writer.write("Ns " + mtl.getNs() + "\n");
        writer.write("d " + mtl.getD() + "\n");
        writer.flush();
    }

    private MtlWriter() {
    }
}

