/*
 * Decompiled with CFR 0.152.
 */
package myron.shaded.de.javagl.obj;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import myron.shaded.de.javagl.obj.DefaultMtl;
import myron.shaded.de.javagl.obj.Mtl;

public class MtlReader {
    public static List<Mtl> read(InputStream inputStream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        return MtlReader.readImpl(reader);
    }

    public static List<Mtl> read(Reader reader) throws IOException {
        if (reader instanceof BufferedReader) {
            return MtlReader.readImpl((BufferedReader)reader);
        }
        return MtlReader.readImpl(new BufferedReader(reader));
    }

    private static List<Mtl> readImpl(BufferedReader reader) throws IOException {
        String line;
        ArrayList<Mtl> mtlList = new ArrayList<Mtl>();
        DefaultMtl currentMtl = null;
        while ((line = reader.readLine()) != null) {
            boolean finished = false;
            while (line.endsWith("\\")) {
                line = line.substring(0, line.length() - 2);
                String nextLine = reader.readLine();
                if (nextLine == null) {
                    finished = true;
                    break;
                }
                line = line + " " + nextLine;
            }
            if (finished) break;
            StringTokenizer st = new StringTokenizer(line);
            if (!st.hasMoreTokens()) continue;
            String identifier = st.nextToken();
            if (identifier.equalsIgnoreCase("newmtl")) {
                String name = line.substring("newmtl".length()).trim();
                currentMtl = new DefaultMtl(name);
                mtlList.add(currentMtl);
                continue;
            }
            if (identifier.equalsIgnoreCase("Ka")) {
                float ka0 = MtlReader.parse(st.nextToken());
                float ka1 = MtlReader.parse(st.nextToken());
                float ka2 = MtlReader.parse(st.nextToken());
                currentMtl.setKa(ka0, ka1, ka2);
                continue;
            }
            if (identifier.equalsIgnoreCase("Ks")) {
                float ks0 = MtlReader.parse(st.nextToken());
                float ks1 = MtlReader.parse(st.nextToken());
                float ks2 = MtlReader.parse(st.nextToken());
                currentMtl.setKs(ks0, ks1, ks2);
                continue;
            }
            if (identifier.equalsIgnoreCase("Kd")) {
                float kd0 = MtlReader.parse(st.nextToken());
                float kd1 = MtlReader.parse(st.nextToken());
                float kd2 = MtlReader.parse(st.nextToken());
                currentMtl.setKd(kd0, kd1, kd2);
                continue;
            }
            if (identifier.equalsIgnoreCase("map_Kd")) {
                String mapKd = line.substring("map_Kd".length()).trim();
                currentMtl.setMapKd(mapKd);
                continue;
            }
            if (identifier.equalsIgnoreCase("d")) {
                float d = MtlReader.parse(st.nextToken());
                currentMtl.setD(d);
                continue;
            }
            if (!identifier.equalsIgnoreCase("Ns")) continue;
            float ns = MtlReader.parse(st.nextToken());
            currentMtl.setNs(ns);
        }
        return mtlList;
    }

    private static float parse(String s) throws IOException {
        try {
            return Float.parseFloat(s);
        }
        catch (NumberFormatException e) {
            throw new IOException(e);
        }
    }

    private MtlReader() {
    }
}

