/*
 * Decompiled with CFR 0.152.
 */
package myron.shaded.de.javagl.obj;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import myron.shaded.de.javagl.obj.DefaultFloatTuple;
import myron.shaded.de.javagl.obj.DefaultObjFace;
import myron.shaded.de.javagl.obj.DefaultObjGroup;
import myron.shaded.de.javagl.obj.FloatTuple;
import myron.shaded.de.javagl.obj.Obj;
import myron.shaded.de.javagl.obj.ObjFace;
import myron.shaded.de.javagl.obj.ObjGroup;

final class DefaultObj
implements Obj {
    private final List<FloatTuple> vertices;
    private final List<FloatTuple> texCoords;
    private final List<FloatTuple> normals;
    private final List<ObjFace> faces;
    private final List<ObjGroup> groups;
    private final List<ObjGroup> materialGroups;
    private final Map<String, DefaultObjGroup> groupMap;
    private final Map<String, DefaultObjGroup> materialGroupMap;
    private List<String> mtlFileNames = Collections.emptyList();
    private final Map<ObjFace, Set<String>> startedGroupNames;
    private final Map<ObjFace, String> startedMaterialGroupNames;
    private Set<String> nextActiveGroupNames = null;
    private String nextActiveMaterialGroupName = null;
    private List<DefaultObjGroup> activeGroups = null;
    private Set<String> activeGroupNames = null;
    private DefaultObjGroup activeMaterialGroup = null;
    private String activeMaterialGroupName = null;

    DefaultObj() {
        this.vertices = new ArrayList<FloatTuple>();
        this.normals = new ArrayList<FloatTuple>();
        this.texCoords = new ArrayList<FloatTuple>();
        this.faces = new ArrayList<ObjFace>();
        this.groups = new ArrayList<ObjGroup>();
        this.materialGroups = new ArrayList<ObjGroup>();
        this.groupMap = new LinkedHashMap<String, DefaultObjGroup>();
        this.materialGroupMap = new LinkedHashMap<String, DefaultObjGroup>();
        this.startedGroupNames = new HashMap<ObjFace, Set<String>>();
        this.startedMaterialGroupNames = new HashMap<ObjFace, String>();
        this.setActiveGroupNames(Arrays.asList("default"));
        this.getGroupInternal("default");
    }

    @Override
    public int getNumVertices() {
        return this.vertices.size();
    }

    @Override
    public FloatTuple getVertex(int index) {
        return this.vertices.get(index);
    }

    @Override
    public int getNumTexCoords() {
        return this.texCoords.size();
    }

    @Override
    public FloatTuple getTexCoord(int index) {
        return this.texCoords.get(index);
    }

    @Override
    public int getNumNormals() {
        return this.normals.size();
    }

    @Override
    public FloatTuple getNormal(int index) {
        return this.normals.get(index);
    }

    @Override
    public int getNumFaces() {
        return this.faces.size();
    }

    @Override
    public ObjFace getFace(int index) {
        return this.faces.get(index);
    }

    @Override
    public Set<String> getActivatedGroupNames(ObjFace face) {
        return this.startedGroupNames.get(face);
    }

    @Override
    public String getActivatedMaterialGroupName(ObjFace face) {
        return this.startedMaterialGroupNames.get(face);
    }

    @Override
    public int getNumGroups() {
        return this.groups.size();
    }

    @Override
    public ObjGroup getGroup(int index) {
        return this.groups.get(index);
    }

    @Override
    public ObjGroup getGroup(String name) {
        return this.groupMap.get(name);
    }

    @Override
    public int getNumMaterialGroups() {
        return this.materialGroups.size();
    }

    @Override
    public ObjGroup getMaterialGroup(int index) {
        return this.materialGroups.get(index);
    }

    @Override
    public ObjGroup getMaterialGroup(String name) {
        return this.materialGroupMap.get(name);
    }

    @Override
    public List<String> getMtlFileNames() {
        return this.mtlFileNames;
    }

    @Override
    public void addVertex(FloatTuple vertex) {
        Objects.requireNonNull(vertex, "The vertex is null");
        this.vertices.add(vertex);
    }

    @Override
    public void addVertex(float x, float y, float z) {
        this.vertices.add(new DefaultFloatTuple(x, y, z));
    }

    @Override
    public void addTexCoord(FloatTuple texCoord) {
        Objects.requireNonNull(texCoord, "The texCoord is null");
        this.texCoords.add(texCoord);
    }

    @Override
    public void addTexCoord(float x) {
        this.texCoords.add(new DefaultFloatTuple(x));
    }

    @Override
    public void addTexCoord(float x, float y) {
        this.texCoords.add(new DefaultFloatTuple(x, y));
    }

    @Override
    public void addTexCoord(float x, float y, float z) {
        this.texCoords.add(new DefaultFloatTuple(x, y, z));
    }

    @Override
    public void addNormal(FloatTuple normal) {
        Objects.requireNonNull(normal, "The normal is null");
        this.normals.add(normal);
    }

    @Override
    public void addNormal(float x, float y, float z) {
        this.normals.add(new DefaultFloatTuple(x, y, z));
    }

    @Override
    public void setActiveGroupNames(Collection<? extends String> groupNames) {
        if (groupNames == null) {
            return;
        }
        if (groupNames.size() == 0) {
            groupNames = Arrays.asList("default");
        } else if (groupNames.contains(null)) {
            throw new NullPointerException("The groupNames contains null");
        }
        this.nextActiveGroupNames = Collections.unmodifiableSet(new LinkedHashSet<String>(groupNames));
    }

    @Override
    public void setActiveMaterialGroupName(String materialGroupName) {
        if (materialGroupName == null) {
            return;
        }
        this.nextActiveMaterialGroupName = materialGroupName;
    }

    @Override
    public void addFace(ObjFace face) {
        if (face == null) {
            throw new NullPointerException("The face is null");
        }
        if (this.nextActiveGroupNames != null) {
            this.activeGroups = this.getGroupsInternal(this.nextActiveGroupNames);
            if (!this.nextActiveGroupNames.equals(this.activeGroupNames)) {
                this.startedGroupNames.put(face, this.nextActiveGroupNames);
            }
            this.activeGroupNames = this.nextActiveGroupNames;
            this.nextActiveGroupNames = null;
        }
        if (this.nextActiveMaterialGroupName != null) {
            this.activeMaterialGroup = this.getMaterialGroupInternal(this.nextActiveMaterialGroupName);
            if (!this.nextActiveMaterialGroupName.equals(this.activeMaterialGroupName)) {
                this.startedMaterialGroupNames.put(face, this.nextActiveMaterialGroupName);
            }
            this.activeMaterialGroupName = this.nextActiveMaterialGroupName;
            this.nextActiveMaterialGroupName = null;
        }
        this.faces.add(face);
        if (this.activeMaterialGroup != null) {
            this.activeMaterialGroup.addFace(face);
        }
        for (DefaultObjGroup group : this.activeGroups) {
            group.addFace(face);
        }
    }

    @Override
    public void addFace(int ... v) {
        this.addFace(v, (int[])null, (int[])null);
    }

    @Override
    public void addFaceWithTexCoords(int ... v) {
        this.addFace(v, v, (int[])null);
    }

    @Override
    public void addFaceWithNormals(int ... v) {
        this.addFace(v, (int[])null, v);
    }

    @Override
    public void addFaceWithAll(int ... v) {
        this.addFace(v, v, v);
    }

    @Override
    public void addFace(int[] v, int[] vt, int[] vn) {
        Objects.requireNonNull(v, "The vertex indices are null");
        DefaultObj.checkIndices(v, this.getNumVertices(), "Vertex");
        DefaultObj.checkIndices(vt, this.getNumTexCoords(), "TexCoord");
        DefaultObj.checkIndices(vn, this.getNumNormals(), "Normal");
        DefaultObjFace face = new DefaultObjFace(v, vt, vn);
        this.addFace(face);
    }

    @Override
    public void setMtlFileNames(Collection<? extends String> mtlFileNames) {
        this.mtlFileNames = Collections.unmodifiableList(new ArrayList<String>(mtlFileNames));
    }

    public String toString() {
        return "Obj[#vertices=" + this.vertices.size() + ",#texCoords=" + this.texCoords.size() + ",#normals=" + this.normals.size() + ",#faces=" + this.faces.size() + ",#groups=" + this.groups.size() + ",#materialGroups=" + this.materialGroups.size() + ",mtlFileNames=" + this.mtlFileNames + "]";
    }

    private List<DefaultObjGroup> getGroupsInternal(Collection<? extends String> groupNames) {
        ArrayList<DefaultObjGroup> groups = new ArrayList<DefaultObjGroup>(groupNames.size());
        for (String string : groupNames) {
            DefaultObjGroup group = this.getGroupInternal(string);
            groups.add(group);
        }
        return groups;
    }

    private DefaultObjGroup getGroupInternal(String groupName) {
        DefaultObjGroup group = this.groupMap.get(groupName);
        if (group == null) {
            group = new DefaultObjGroup(groupName);
            this.groupMap.put(groupName, group);
            this.groups.add(group);
        }
        return group;
    }

    private DefaultObjGroup getMaterialGroupInternal(String materialGroupName) {
        DefaultObjGroup group = this.materialGroupMap.get(materialGroupName);
        if (group == null) {
            group = new DefaultObjGroup(materialGroupName);
            this.materialGroupMap.put(materialGroupName, group);
            this.materialGroups.add(group);
        }
        return group;
    }

    private static void checkIndices(int[] indices, int max, String name) {
        if (indices == null) {
            return;
        }
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i] < 0) {
                throw new IllegalArgumentException(name + " index is negative: " + indices[i]);
            }
            if (indices[i] < max) continue;
            throw new IllegalArgumentException(name + " index is " + indices[i] + ", but must be smaller than " + max);
        }
    }
}

