/*
 * Decompiled with CFR 0.152.
 */
package dev.monarkhes.myron_neepmeat.impl.client.obj;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.monarkhes.myron_neepmeat.impl.Namespaces;
import dev.monarkhes.myron_neepmeat.impl.client.Myron;
import dev.monarkhes.myron_neepmeat.impl.client.obj.AbstractObjLoader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_804;
import net.minecraft.class_809;
import org.jetbrains.annotations.Nullable;

public class ObjLoader
extends AbstractObjLoader
implements ModelLoadingPlugin {
    public static final ObjLoader INSTANCE = new ObjLoader();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(class_809.class, (Object)new ModelTransformDeserializer()).registerTypeAdapter(class_804.class, (Object)new TransformDeserializer()).create();

    private ObjLoader() {
    }

    @Nullable
    public class_1100 loadModelResource(class_2960 identifier, AbstractObjLoader.ResourceGetter resourceManager) {
        if (!Namespaces.check(identifier.method_12836())) {
            return null;
        }
        return this.loadModel(resourceManager, identifier, class_809.field_4301, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public class_1100 loadModelVariant(class_2960 identifier, AbstractObjLoader.ResourceGetter resourceManager) {
        if (!(identifier instanceof class_1091)) return null;
        class_1091 modelIdentifier = (class_1091)identifier;
        if (!Namespaces.check(modelIdentifier.method_12836())) {
            return null;
        }
        class_2960 resource = new class_2960(modelIdentifier.method_12836(), "models/item/" + modelIdentifier.method_12832() + ".json");
        if (!modelIdentifier.method_4740().equals("inventory")) return null;
        if (resourceManager.getResource(resource).isEmpty()) {
            return null;
        }
        try (InputStreamReader reader = new InputStreamReader(resourceManager.getResource(resource).get().method_14482());){
            JsonObject rawModel = class_3518.method_15255((Reader)reader);
            JsonElement model = rawModel.get("model");
            if (!(model instanceof JsonPrimitive) || !((JsonPrimitive)model).isString()) {
                class_1100 class_11002 = null;
                return class_11002;
            }
            class_2960 modelPath = new class_2960(model.getAsString());
            class_809 transformation = this.getTransformation(rawModel, resourceManager);
            boolean isSideLit = true;
            if (rawModel.has("gui_light")) {
                isSideLit = class_3518.method_15265((JsonObject)rawModel, (String)"gui_light").equals("side");
            }
            class_1100 class_11003 = this.loadModel(resourceManager, modelPath, transformation, isSideLit);
            return class_11003;
        }
        catch (IOException e) {
            Myron.LOGGER.warn("Failed to load model {}:\n{}", (Object)resource, (Object)e.getMessage());
            return null;
        }
    }

    private class_809 getTransformation(JsonObject rawModel, AbstractObjLoader.ResourceGetter resourceManager) throws IOException {
        if (rawModel.has("display")) {
            JsonObject rawTransform = class_3518.method_15296((JsonObject)rawModel, (String)"display");
            return (class_809)GSON.fromJson((JsonElement)rawTransform, class_809.class);
        }
        if (rawModel.has("parent")) {
            class_2960 parent = new class_2960(class_3518.method_15265((JsonObject)rawModel, (String)"parent"));
            parent = new class_2960(parent.method_12836(), "models/" + parent.method_12832() + ".json");
            return this.getTransformation(parent, resourceManager);
        }
        return class_809.field_4301;
    }

    private class_809 getTransformation(class_2960 model, AbstractObjLoader.ResourceGetter resourceManager) throws IOException {
        if (resourceManager.getResource(model).isPresent()) {
            InputStreamReader reader = new InputStreamReader(resourceManager.getResource(model).get().method_14482());
            return this.getTransformation(class_3518.method_15255((Reader)reader), resourceManager);
        }
        return class_809.field_4301;
    }

    public void onInitializeModelLoader(ModelLoadingPlugin.Context loaderCtx) {
        loaderCtx.resolveModel().register(context -> this.loadModelResource(context.id(), arg_0 -> ((class_3300)class_310.method_1551().method_1478()).method_14486(arg_0)));
        loaderCtx.modifyModelBeforeBake().register((unbakedModel, context) -> Objects.requireNonNullElse(this.loadModelVariant(context.id(), arg_0 -> ((class_3300)class_310.method_1551().method_1478()).method_14486(arg_0)), unbakedModel));
    }

    @Environment(value=EnvType.CLIENT)
    public static class ModelTransformDeserializer
    extends class_809.class_810 {
    }

    @Environment(value=EnvType.CLIENT)
    public static class TransformDeserializer
    extends class_804.class_805 {
    }
}

