/*
 * Decompiled with CFR 0.152.
 */
package dev.monarkhes.myron_neepmeat.impl.client.obj;

import dev.monarkhes.myron_neepmeat.impl.client.model.MyronMaterial;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.minecraft.class_2350;
import net.minecraft.class_2960;

public class MaterialReader {
    private static final Map<String, Option> OPTIONS = new HashMap<String, Option>();
    private static final Option NONE = (tokenizer, line, token, material) -> {};

    private MaterialReader() {
    }

    public static void register(Option option, String ... tokens) {
        for (String key : tokens) {
            OPTIONS.putIfAbsent(key.toLowerCase(Locale.ROOT), option);
        }
    }

    public static List<MyronMaterial> read(BufferedReader reader) throws IOException {
        ArrayList<MyronMaterial> materials = new ArrayList<MyronMaterial>();
        MyronMaterial currentMaterial = null;
        String line = reader.readLine();
        while (line != null) {
            StringTokenizer tokenizer;
            int comment = line.indexOf(35);
            if (comment > 0) {
                line = line.substring(0, comment);
            }
            if ((tokenizer = new StringTokenizer(line)).hasMoreTokens()) {
                String token = tokenizer.nextToken().toLowerCase(Locale.ROOT);
                if (token.equals("newmtl")) {
                    String name = line.substring("newmtl".length()).trim();
                    currentMaterial = new MyronMaterial(name);
                    materials.add(currentMaterial);
                }
                if (currentMaterial != null) {
                    OPTIONS.getOrDefault(token, NONE).parse(tokenizer, line, token, currentMaterial);
                }
            }
            line = MaterialReader.next(reader);
        }
        return materials;
    }

    private static String next(BufferedReader reader) throws IOException {
        String line = MaterialReader.trim(reader.readLine());
        if (line == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(line);
        while (line != null && line.endsWith("\\")) {
            line = MaterialReader.trim(reader.readLine());
            if (line == null) continue;
            result.append(" ").append(line);
        }
        return result.toString();
    }

    private static String trim(String line) {
        return line == null ? null : line.trim();
    }

    private static float parseFloat(String s) throws IOException {
        try {
            return Float.parseFloat(s);
        }
        catch (NumberFormatException e) {
            throw new IOException(e);
        }
    }

    private static int parseInt(String s, int radix) throws IOException {
        if (radix == 16 && s.startsWith("0x")) {
            s = s.substring(2);
        }
        try {
            return Integer.parseInt(s, radix);
        }
        catch (NumberFormatException e) {
            throw new IOException(e);
        }
    }

    private static boolean parseBoolean(String s) {
        return s.equalsIgnoreCase("true");
    }

    static {
        MaterialReader.register((tokenizer, line, key, material) -> material.setTexture(class_2960.method_12829((String)line.substring(key.length()).trim())), "map_Kd", "texture");
        MaterialReader.register((tokenizer, line, key, material) -> material.setColor(MaterialReader.parseFloat(tokenizer.nextToken()), MaterialReader.parseFloat(tokenizer.nextToken()), MaterialReader.parseFloat(tokenizer.nextToken())), "Kd");
        MaterialReader.register((tokenizer, line, key, material) -> material.setBlendMode(BlendMode.valueOf((String)tokenizer.nextToken().toUpperCase(Locale.ROOT))), "blend_mode");
        MaterialReader.register((tokenizer, line, key, material) -> material.setColorIndex(MaterialReader.parseBoolean(tokenizer.nextToken())), "color_index");
        MaterialReader.register((tokenizer, line, key, material) -> material.setDiffuseShading(MaterialReader.parseBoolean(tokenizer.nextToken())), "diffuse_shading");
        MaterialReader.register((tokenizer, line, key, material) -> material.setAmbientOcclusion(MaterialReader.parseBoolean(tokenizer.nextToken())), "ambient_occlusion", "ambientocclusion", "ao");
        MaterialReader.register((tokenizer, line, key, material) -> material.setColor(MaterialReader.parseInt(tokenizer.nextToken(), 16)), "diffuse_color", "color");
        MaterialReader.register((tokenizer, line, key, material) -> material.setEmissive(MaterialReader.parseBoolean(tokenizer.nextToken())), "emission", "emissive");
        MaterialReader.register((tokenizer, line, key, material) -> material.lockUv(MaterialReader.parseBoolean(tokenizer.nextToken())), "uvlock");
        MaterialReader.register((tokenizer, line, key, material) -> material.setTintIndex(MaterialReader.parseInt(tokenizer.nextToken(), 10)), "tint_index", "tintindex");
        MaterialReader.register((tokenizer, line, key, material) -> material.cull(class_2350.valueOf((String)tokenizer.nextToken().toUpperCase(Locale.ROOT))), "cull", "cullface");
    }

    @FunctionalInterface
    public static interface Option {
        public void parse(StringTokenizer var1, String var2, String var3, MyronMaterial var4) throws IOException;
    }
}

