/*
 * Decompiled with CFR 0.152.
 */
package dev.monarkhes.myron_neepmeat.impl.client.obj;

import dev.monarkhes.myron_neepmeat.impl.client.Myron;
import dev.monarkhes.myron_neepmeat.impl.client.model.MyronMaterial;
import dev.monarkhes.myron_neepmeat.impl.client.model.MyronUnbakedModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import myron.shaded.de.javagl.obj.Obj;
import myron.shaded.de.javagl.obj.ObjReader;
import net.minecraft.class_1047;
import net.minecraft.class_1100;
import net.minecraft.class_1723;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_4730;
import net.minecraft.class_809;
import org.jetbrains.annotations.Nullable;

public class AbstractObjLoader {
    public static final class_4730 DEFAULT_SPRITE = new class_4730(class_1723.field_21668, null);

    @Nullable
    protected class_1100 loadModel(ResourceGetter resourceManager, class_2960 identifier, class_809 transformation, boolean isSideLit) {
        boolean isBlock = identifier.method_12832().startsWith("block");
        if (!identifier.method_12832().endsWith(".obj")) {
            identifier = new class_2960(identifier.method_12836(), identifier.method_12832() + ".obj");
        }
        if (!identifier.method_12832().startsWith("models/")) {
            identifier = new class_2960(identifier.method_12836(), "models/" + identifier.method_12832());
        }
        if (resourceManager.getResource(identifier).isPresent()) {
            try {
                InputStream inputStream = resourceManager.getResource(identifier).get().method_14482();
                Obj obj = ObjReader.read(inputStream);
                Map<String, MyronMaterial> materials = Myron.getMaterials(resourceManager, identifier, obj);
                HashSet<class_4730> textureDependencies = new HashSet<class_4730>();
                for (MyronMaterial material : materials.values()) {
                    class_2960 materialTexture = material.getTexture();
                    if (materialTexture != null) {
                        textureDependencies.add(new class_4730(class_1723.field_21668, materialTexture));
                        continue;
                    }
                    textureDependencies.add(new class_4730(class_1723.field_21668, class_1047.method_4539()));
                    Myron.LOGGER.warn("No texture specified for material '{}' in model '{}'; using missing texture.", (Object)material.name, (Object)identifier);
                }
                MyronMaterial material = materials.get("sprite");
                return new MyronUnbakedModel(obj, materials, textureDependencies, !materials.isEmpty() ? new class_4730(class_1723.field_21668, (material == null ? materials.values().iterator().next() : material).getTexture()) : DEFAULT_SPRITE, transformation, isSideLit, isBlock);
            }
            catch (IOException e) {
                Myron.LOGGER.warn("Failed to load model {}:\n{}", (Object)identifier, (Object)e.getMessage());
            }
        }
        return null;
    }

    public static interface ResourceGetter {
        public Optional<class_3298> getResource(class_2960 var1);
    }
}

