/*
 * Decompiled with CFR 0.152.
 */
package dev.monarkhes.myron_neepmeat.impl.client;

import dev.monarkhes.myron_neepmeat.impl.client.model.MyronMaterial;
import dev.monarkhes.myron_neepmeat.impl.client.model.MyronModelProvider;
import dev.monarkhes.myron_neepmeat.impl.client.obj.AbstractObjLoader;
import dev.monarkhes.myron_neepmeat.impl.client.obj.MaterialReader;
import dev.monarkhes.myron_neepmeat.impl.client.obj.ObjLoader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import myron.shaded.de.javagl.obj.FloatTuple;
import myron.shaded.de.javagl.obj.Obj;
import myron.shaded.de.javagl.obj.ObjFace;
import myron.shaded.de.javagl.obj.ObjReader;
import myron.shaded.de.javagl.obj.ObjSplitting;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.class_1058;
import net.minecraft.class_1723;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3665;
import net.minecraft.class_4590;
import net.minecraft.class_4730;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

@Environment(value=EnvType.CLIENT)
public class Myron
implements ClientModInitializer {
    private static final Vector3f NONE_OFFSET = new Vector3f(0.5f, 0.0f, 0.5f);
    private static final Vector3f BLOCK_OFFSET = new Vector3f(0.5f, 0.5f, 0.5f);
    public static final String MOD_ID = "myron-neepmeat";
    public static final Logger LOGGER = LogManager.getLogger((String)"Myron-NEEPMeat");
    public static final Map<class_2960, Mesh> MESHES = new HashMap<class_2960, Mesh>();

    public void onInitializeClient() {
        ModelLoadingPlugin.register((ModelLoadingPlugin)ObjLoader.INSTANCE);
        ModelLoadingPlugin.register((ModelLoadingPlugin)MyronModelProvider.INSTANCE);
        LOGGER.info("Myron Initialized!");
    }

    @Nullable
    public static Mesh load(class_2960 modelPath, Function<class_4730, class_1058> textureGetter, class_3665 bakeSettings, boolean isBlock) {
        class_3300 resourceManager = class_310.method_1551().method_1478();
        if (!modelPath.method_12832().endsWith(".obj")) {
            modelPath = new class_2960(modelPath.method_12836(), modelPath.method_12832() + ".obj");
        }
        if (!modelPath.method_12832().startsWith("models/")) {
            modelPath = new class_2960(modelPath.method_12836(), "models/" + modelPath.method_12832());
        }
        if (resourceManager.method_14486(modelPath).isPresent()) {
            try {
                InputStream inputStream = ((class_3298)resourceManager.method_14486(modelPath).get()).method_14482();
                Obj obj = ObjReader.read(inputStream);
                Map<String, MyronMaterial> materials = Myron.getMaterials(arg_0 -> ((class_3300)resourceManager).method_14486(arg_0), modelPath, obj);
                return Myron.build(obj, materials, textureGetter, bakeSettings, isBlock);
            }
            catch (IOException e) {
                LOGGER.warn("Failed to load model {}:\n{}", (Object)modelPath, (Object)e.getMessage());
            }
        }
        return null;
    }

    public static Map<String, MyronMaterial> getMaterials(AbstractObjLoader.ResourceGetter resourceManager, class_2960 identifier, Obj obj) throws IOException {
        LinkedHashMap<String, MyronMaterial> materials = new LinkedHashMap<String, MyronMaterial>();
        for (String s : obj.getMtlFileNames()) {
            Object path = identifier.method_12832();
            path = ((String)path).substring(0, ((String)path).lastIndexOf(47) + 1) + s;
            class_2960 resource = new class_2960(identifier.method_12836(), (String)path);
            if (resourceManager.getResource(resource).isPresent()) {
                MaterialReader.read(new BufferedReader(new InputStreamReader(resourceManager.getResource(resource).get().method_14482()))).forEach(material -> materials.put(material.name, (MyronMaterial)material));
                continue;
            }
            LOGGER.warn("Texture does not exist: {}", (Object)resource);
        }
        return materials;
    }

    @Nullable
    public static Mesh build(Obj obj, Map<String, MyronMaterial> materials, Function<class_4730, class_1058> textureGetter, class_3665 bakeSettings, boolean isBlock) {
        Renderer renderer = RendererAccess.INSTANCE.getRenderer();
        if (renderer == null) {
            return null;
        }
        MeshBuilder builder = renderer.meshBuilder();
        QuadEmitter emitter = builder.getEmitter();
        for (Map.Entry<String, Obj> entry : ObjSplitting.splitByMaterialGroups(obj).entrySet()) {
            Obj group = entry.getValue();
            MyronMaterial material = materials.get(entry.getKey());
            if (material == null) {
                if (!entry.getKey().equals("none")) {
                    LOGGER.warn("Material '{}' found model not found in {}; using default material.", (Object)entry.getKey(), obj.getMtlFileNames());
                }
                material = MyronMaterial.DEFAULT;
            }
            int materialColor = material.getColor();
            class_1058 sprite = textureGetter.apply(new class_4730(class_1723.field_21668, material.getTexture()));
            for (int faceIndex = 0; faceIndex < group.getNumFaces(); ++faceIndex) {
                Myron.face(renderer, emitter, group, group.getFace(faceIndex), material, materialColor, sprite, bakeSettings, isBlock);
            }
        }
        return builder.build();
    }

    private static void face(Renderer renderer, QuadEmitter emitter, Obj group, ObjFace face, MyronMaterial material, int materialColor, class_1058 sprite, class_3665 settings, boolean isBlock) {
        if (face.getNumVertices() <= 4) {
            for (int vertex = 0; vertex < face.getNumVertices(); ++vertex) {
                Myron.vertex(emitter, group, face, vertex, settings, isBlock);
            }
            Myron.emit(renderer, emitter, material, materialColor, sprite, settings);
        } else {
            int vertices = face.getNumVertices();
            FloatTuple textureCoords = face.containsTexCoordIndices() ? group.getTexCoord(face.getTexCoordIndex(0)) : null;
            Vector3f pos = Myron.of(group.getVertex(face.getVertexIndex(0)));
            pos.add((Vector3fc)(isBlock ? BLOCK_OFFSET : NONE_OFFSET));
            Vector3f normal = Myron.of(group.getNormal(face.getNormalIndex(0)));
            Myron.rotate(settings, pos, normal);
            Vertex start = new Vertex(pos, normal, textureCoords == null ? 0.0f : textureCoords.getX(), textureCoords == null ? 0.0f : textureCoords.getY());
            for (int vertex = 1; vertex < vertices - 1; ++vertex) {
                Myron.vertex(emitter, 0, start.pos, start.normal, start.u, start.v);
                textureCoords = face.containsTexCoordIndices() ? group.getTexCoord(face.getTexCoordIndex(vertex)) : null;
                pos = Myron.of(group.getVertex(face.getVertexIndex(vertex)));
                pos.add((Vector3fc)(isBlock ? BLOCK_OFFSET : NONE_OFFSET));
                normal = Myron.of(group.getNormal(face.getNormalIndex(vertex)));
                Myron.rotate(settings, pos, normal);
                Myron.vertex(emitter, 1, pos, normal, textureCoords == null ? 0.0f : textureCoords.getX(), textureCoords == null ? 0.0f : textureCoords.getY());
                textureCoords = face.containsTexCoordIndices() ? group.getTexCoord(face.getTexCoordIndex(vertex + 1)) : null;
                pos = Myron.of(group.getVertex(face.getVertexIndex(vertex + 1)));
                pos.add((Vector3fc)(isBlock ? BLOCK_OFFSET : NONE_OFFSET));
                normal = Myron.of(group.getNormal(face.getNormalIndex(vertex + 1)));
                Myron.rotate(settings, pos, normal);
                Myron.vertex(emitter, 2, pos, normal, textureCoords == null ? 0.0f : textureCoords.getX(), textureCoords == null ? 0.0f : textureCoords.getY());
                Myron.vertex(emitter, 3, pos, normal, textureCoords == null ? 0.0f : textureCoords.getX(), textureCoords == null ? 0.0f : textureCoords.getY());
                Myron.emit(renderer, emitter, material, materialColor, sprite, settings);
            }
        }
    }

    private static void emit(Renderer renderer, QuadEmitter emitter, MyronMaterial material, int materialColor, class_1058 sprite, class_3665 settings) {
        emitter.material(material.getMaterial(renderer));
        emitter.spriteColor(0, materialColor, materialColor, materialColor, materialColor);
        emitter.colorIndex(material.getTintIndex());
        emitter.nominalFace(emitter.lightFace());
        if (material.getCullDirection() != null) {
            emitter.cullFace(material.getCullDirection());
        }
        boolean bl = settings.method_3512() || material.isUvLocked();
        emitter.spriteBake(0, sprite, 0x20 | (bl ? 4 : 0));
        emitter.emit();
    }

    private static void vertex(QuadEmitter emitter, Obj group, ObjFace face, int vertex, class_3665 settings, boolean isBlock) {
        Vector3f pos = Myron.of(group.getVertex(face.getVertexIndex(vertex)));
        pos.add((Vector3fc)(isBlock ? BLOCK_OFFSET : NONE_OFFSET));
        Vector3f normal = face.containsNormalIndices() ? Myron.of(group.getNormal(face.getNormalIndex(vertex))) : Myron.calculateNormal(group, face);
        float u = 0.0f;
        float v = 0.0f;
        if (face.containsTexCoordIndices()) {
            FloatTuple textureCoords = group.getTexCoord(face.getTexCoordIndex(vertex));
            u = textureCoords.getX();
            v = 1.0f - textureCoords.getY();
            u = u > 1.0f || u < 0.0f ? (u % 1.0f + 1.0f) % 1.0f : u;
            v = v > 1.0f || v < 0.0f ? (v % 1.0f + 1.0f) % 1.0f : v;
        }
        Myron.rotate(settings, pos, normal);
        Myron.vertex(emitter, vertex, pos, normal, u, v);
        if (face.getNumVertices() == 3) {
            Myron.vertex(emitter, vertex + 1, pos, normal, u, v);
        }
    }

    private static Vector3f calculateNormal(Obj group, ObjFace face) {
        Vector3f p1 = Myron.of(group.getVertex(face.getVertexIndex(0)));
        Vector3f v1 = Myron.of(group.getVertex(face.getVertexIndex(1)));
        Vector3f v2 = Myron.of(group.getVertex(face.getVertexIndex(2)));
        v1.sub((Vector3fc)p1);
        v2.sub((Vector3fc)p1);
        return new Vector3f(v1.y() * v2.z() - v1.z() * v2.y(), v1.z() * v2.x() - v1.x() * v2.z(), v1.x() * v2.y() - v1.y() * v2.x());
    }

    private static void rotate(class_3665 settings, Vector3f pos, Vector3f normal) {
        if (settings.method_3509() != class_4590.method_22931()) {
            pos.add(-0.5f, -0.5f, -0.5f);
            Vector4f thing = new Vector4f((Vector3fc)pos, 1.0f).mul((Matrix4fc)settings.method_3509().method_22936());
            pos.x = thing.x;
            pos.y = thing.y;
            pos.z = thing.z;
            pos.add(0.5f, 0.5f, 0.5f);
            normal.rotate((Quaternionfc)settings.method_3509().method_22937());
        }
    }

    private static void vertex(QuadEmitter emitter, int vertex, Vector3f pos, Vector3f normal, float u, float v) {
        emitter.pos(vertex, pos);
        emitter.normal(vertex, normal);
        emitter.sprite(vertex, 0, u, v);
    }

    private static Vector3f of(FloatTuple tuple) {
        return new Vector3f(tuple.getX(), tuple.getY(), tuple.getZ());
    }

    private static class Vertex {
        public final Vector3f pos;
        public final Vector3f normal;
        public final float u;
        public final float v;

        private Vertex(Vector3f pos, Vector3f normal, float u, float v) {
            this.pos = pos;
            this.normal = normal;
            this.u = u;
            this.v = v;
        }
    }
}

