/*
 * Decompiled with CFR 0.152.
 */
package com.thunderbear06.entity.player;

import com.mojang.authlib.GameProfile;
import com.thunderbear06.ai.AndroidBrain;
import dan200.computercraft.shared.platform.PlatformHelper;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AndroidPlayer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AndroidPlayer.class);
    private static final GameProfile DEFAULT_PROFILE = new GameProfile(UUID.fromString("0d0c4ca0-4ff1-11e4-916c-0800200c9a66"), "[ComputerCraft]");
    private final class_3222 player;

    public AndroidPlayer(class_3222 player) {
        this.player = player;
    }

    private static AndroidPlayer create(AndroidBrain brain) {
        class_3218 world = (class_3218)brain.getAndroid().method_37908();
        GameProfile profile = brain.getOwningPlayerProfile();
        AndroidPlayer player = new AndroidPlayer(PlatformHelper.get().createFakePlayer(world, AndroidPlayer.getProfile(profile != null ? profile : DEFAULT_PROFILE)));
        player.setState(brain);
        return player;
    }

    public static AndroidPlayer get(AndroidBrain brain) {
        AndroidPlayer player = brain.fakePlayer;
        if (player != null && player.player.method_7334() == AndroidPlayer.getProfile(brain.getOwningPlayerProfile()) && player.player.method_37908() == brain.getAndroid().method_37908()) {
            player.setState(brain);
        } else {
            player = brain.fakePlayer = AndroidPlayer.create(brain);
        }
        return player;
    }

    public class_3222 player() {
        return this.player;
    }

    private void setState(AndroidBrain brain) {
        if (this.player.field_7512 != this.player.field_7498) {
            LOGGER.warn("Android has open container ({})", (Object)this.player.field_7512);
            this.player.method_14247();
        }
        this.setPosition(brain);
        this.loadHand(brain.getAndroid().method_6047(), class_1268.field_5808);
        this.loadHand(brain.getAndroid().method_6079(), class_1268.field_5810);
    }

    private void setRotation(class_243 rotation) {
        this.player.method_36456((float)rotation.field_1351);
        this.player.method_36457((float)rotation.field_1352);
    }

    public void setPosition(AndroidBrain brain) {
        this.setRotation(brain.getAndroid().method_5720());
        class_243 pos = brain.getAndroid().method_19538();
        this.player.method_33574(pos);
        this.player.field_6014 = pos.method_10216();
        this.player.field_6036 = pos.method_10214();
        this.player.field_5969 = pos.method_10215();
        this.player.field_6004 = this.player.method_36455();
        this.player.field_6241 = this.player.field_5982 = this.player.method_36454();
        this.player.field_6259 = this.player.field_5982;
    }

    private static GameProfile getProfile(@Nullable GameProfile profile) {
        return profile != null && profile.isComplete() ? profile : DEFAULT_PROFILE;
    }

    public void loadHand(class_1799 stack, class_1268 hand) {
        this.player.method_6122(hand, stack);
    }
}

