/*
 * Decompiled with CFR 0.152.
 */
package com.thunderbear06.entity.android.frame;

import com.thunderbear06.CCAndroids;
import com.thunderbear06.entity.EntityRegistry;
import com.thunderbear06.entity.android.BaseAndroidEntity;
import com.thunderbear06.item.ItemRegistry;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5712;
import net.minecraft.class_8103;
import org.jetbrains.annotations.Nullable;

public class AndroidFrame
extends class_1308 {
    private static final class_2940<Byte> BUILD_PROGRESS = class_2945.method_12791(AndroidFrame.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Byte> COMPONENTS_NEEDED = class_2945.method_12791(AndroidFrame.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Byte> INGOTS_NEEDED = class_2945.method_12791(AndroidFrame.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Boolean> HAS_CORE = class_2945.method_12791(AndroidFrame.class, (class_2941)class_2943.field_13323);
    private boolean isAdvanced = false;
    private long lastHitTime = 0L;

    public AndroidFrame(class_1299<? extends class_1308> entityType, class_1937 world) {
        super(entityType, world);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(BUILD_PROGRESS, (Object)0);
        this.field_6011.method_12784(COMPONENTS_NEEDED, (Object)CCAndroids.CONFIG.CompsForConstruction);
        this.field_6011.method_12784(INGOTS_NEEDED, (Object)CCAndroids.CONFIG.IngotsForConstruction);
        this.field_6011.method_12784(HAS_CORE, (Object)false);
    }

    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 handStack = hand == class_1268.field_5808 ? player.method_6047() : player.method_6079();
        class_1937 world = player.method_37908();
        if (handStack.method_31574((class_1792)ItemRegistry.COMPONENTS.get()) && this.addComponents(world)) {
            this.onSuccess(handStack, player, hand);
            return class_1269.field_5812;
        }
        if ((handStack.method_31574(class_1802.field_8620) || handStack.method_31574(class_1802.field_8695)) && this.addPlates(world, handStack.method_31574(class_1802.field_8695))) {
            this.onSuccess(handStack, player, hand);
            return class_1269.field_5812;
        }
        if (handStack.method_31574((class_1792)ItemRegistry.REDSTONE_REACTOR.get()) && this.insertCore(world)) {
            this.onSuccess(handStack, player, hand);
            return class_1269.field_5812;
        }
        if ((handStack.method_31574((class_1792)ItemRegistry.ANDROID_CPU.get()) || handStack.method_31574(class_1802.field_8866)) && this.isReadyForCPU()) {
            this.insertCPU(handStack);
            this.onSuccess(handStack, player, hand);
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    public void incrementProgress(int inc) {
        this.setBuildProgress((Byte)this.field_6011.method_12789(BUILD_PROGRESS) + inc);
    }

    private void setBuildProgress(int progress) {
        this.field_6011.method_12778(BUILD_PROGRESS, (Object)((byte)progress));
    }

    private void onSuccess(class_1799 stack, class_1657 player, class_1268 hand) {
        stack.method_7934(1);
        player.method_6122(hand, stack);
    }

    private boolean addComponents(class_1937 world) {
        byte comps = this.getComponentsNeeded();
        if (comps <= 0) {
            return false;
        }
        float pitch = (float)this.method_6051().method_39332(10, 12) * 0.1f;
        comps = (byte)(comps - 1);
        this.field_6011.method_12778(COMPONENTS_NEEDED, (Object)comps);
        if (comps <= 0) {
            world.method_43129(null, (class_1297)this, class_3417.field_14559, class_3419.field_15254, 1.0f, pitch);
        } else {
            world.method_43129(null, (class_1297)this, class_3417.field_21077, class_3419.field_15254, 1.0f, pitch);
        }
        return true;
    }

    private boolean addPlates(class_1937 world, boolean isGold) {
        if (this.getComponentsNeeded() > 0) {
            return false;
        }
        if (this.getIngotsNeeded() <= 0) {
            return false;
        }
        if (isGold && !this.isAdvanced) {
            if (this.getIngotsNeeded() < CCAndroids.CONFIG.IngotsForConstruction) {
                return false;
            }
            this.isAdvanced = true;
        }
        if (!isGold && this.isAdvanced) {
            return false;
        }
        float pitch = (float)this.method_6051().method_39332(10, 12) * 0.1f;
        byte ingots = (Byte)this.field_6011.method_12789(INGOTS_NEEDED);
        ingots = (byte)(ingots - 1);
        this.field_6011.method_12778(INGOTS_NEEDED, (Object)ingots);
        if (ingots == 0) {
            world.method_43129(null, (class_1297)this, class_3417.field_14559, class_3419.field_15254, 1.0f, pitch);
        } else {
            world.method_43129(null, (class_1297)this, class_3417.field_21077, class_3419.field_15254, 1.0f, pitch);
        }
        return true;
    }

    private boolean insertCore(class_1937 world) {
        if (this.hasCore()) {
            return false;
        }
        this.field_6011.method_12778(HAS_CORE, (Object)true);
        world.method_43129(null, (class_1297)this, class_3417.field_19197, class_3419.field_15254, 1.0f, 1.0f);
        return true;
    }

    private boolean isReadyForCPU() {
        return this.getComponentsNeeded() == 0 && this.hasCore() && this.getIngotsNeeded() == 0;
    }

    private void insertCPU(class_1799 cpu) {
        ComputerFamily family;
        int computerID = -1;
        if (cpu.method_31574(class_1802.field_8866)) {
            family = ComputerFamily.COMMAND;
        } else {
            ComputerFamily computerFamily = family = this.isAdvanced ? ComputerFamily.ADVANCED : ComputerFamily.NORMAL;
        }
        if (cpu.method_7985() && cpu.method_7969().method_10545("ComputerID")) {
            computerID = cpu.method_7969().method_10550("ComputerID");
        }
        this.finish(family, computerID);
    }

    private void finish(ComputerFamily family, int computerID) {
        BaseAndroidEntity android = switch (family) {
            case ComputerFamily.NORMAL -> (BaseAndroidEntity)((class_1299)EntityRegistry.ANDROID_ENTITY.get()).method_5883(this.method_37908());
            case ComputerFamily.ADVANCED -> (BaseAndroidEntity)((class_1299)EntityRegistry.ADVANCED_ANDROID_ENTITY.get()).method_5883(this.method_37908());
            case ComputerFamily.COMMAND -> (BaseAndroidEntity)((class_1299)EntityRegistry.COMMAND_ANDROID_ENTITY.get()).method_5883(this.method_37908());
            default -> throw new IllegalArgumentException("Unknown ComputerFamily " + family);
        };
        assert (android != null);
        android.method_5719((class_1297)this);
        android.getComputer().setComputerID(computerID);
        this.method_31472();
        this.method_37908().method_8649((class_1297)android);
        android.method_37908().method_43129(null, (class_1297)android, class_3417.field_14703, class_3419.field_15254, 1.0f, 1.0f);
    }

    public byte getComponentsNeeded() {
        return (Byte)this.field_6011.method_12789(COMPONENTS_NEEDED);
    }

    public byte getIngotsNeeded() {
        return (Byte)this.field_6011.method_12789(INGOTS_NEEDED);
    }

    public boolean hasCore() {
        return (Boolean)this.field_6011.method_12789(HAS_CORE);
    }

    protected void method_6087(class_1297 entity) {
    }

    public void method_5697(class_1297 entity) {
    }

    public void method_6005(double strength, double x, double z) {
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_37908().method_8608() || this.method_31481()) {
            return false;
        }
        if (source.method_48789(class_8103.field_42242)) {
            this.method_5768();
            return false;
        }
        if (this.method_5679(source)) {
            return false;
        }
        if (source.method_48789(class_8103.field_42249)) {
            this.onBreak();
            this.method_5768();
            return false;
        }
        if (!(source.method_5529() instanceof class_1657)) {
            return false;
        }
        if (!((class_1657)source.method_5529()).method_31549().field_7476) {
            return false;
        }
        if (source.method_5530()) {
            this.method_6013(source);
            this.method_5768();
        } else {
            long l = this.method_37908().method_8510();
            if (l - this.lastHitTime > 5L) {
                this.method_37908().method_8421((class_1297)this, (byte)32);
                this.method_32875(class_5712.field_28736, source.method_5529());
                this.lastHitTime = l;
            } else {
                this.onBreak();
            }
        }
        return true;
    }

    public void onBreak() {
        this.method_16078();
        this.method_5768();
    }

    public void method_5768() {
        this.method_5650(class_1297.class_5529.field_26998);
        this.method_32876(class_5712.field_37676);
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_14727;
    }

    protected void method_16078() {
        int components_dropped = CCAndroids.CONFIG.CompsForConstruction - this.getComponentsNeeded();
        for (int i = 0; i < components_dropped; ++i) {
            this.method_5775(new class_1799((class_1935)ItemRegistry.COMPONENTS.get()));
        }
        int ingots_dropped = CCAndroids.CONFIG.IngotsForConstruction - this.getIngotsNeeded();
        for (int j = 0; j < ingots_dropped; ++j) {
            this.method_5775(new class_1799((class_1935)(this.isAdvanced ? class_1802.field_8695 : class_1802.field_8620)));
        }
        if (this.hasCore()) {
            this.method_5775(new class_1799((class_1935)ItemRegistry.REDSTONE_REACTOR.get()));
        }
        this.method_5775(new class_1799((class_1935)ItemRegistry.ANDROID_FRAME.get()));
    }

    public void method_5652(class_2487 nbt) {
        nbt.method_10567("ComponentsNeeded", this.getComponentsNeeded());
        nbt.method_10567("IngotsNeeded", this.getIngotsNeeded());
        nbt.method_10556("IsAdvanced", this.isAdvanced);
        nbt.method_10556("HasCore", this.hasCore());
        super.method_5652(nbt);
    }

    public void method_5749(class_2487 nbt) {
        if (nbt.method_10545("ComponentsNeeded")) {
            this.field_6011.method_12778(COMPONENTS_NEEDED, (Object)nbt.method_10571("ComponentsNeeded"));
            this.field_6011.method_12778(INGOTS_NEEDED, (Object)nbt.method_10571("IngotsNeeded"));
            this.field_6011.method_12778(HAS_CORE, (Object)nbt.method_10577("HasCore"));
            this.isAdvanced = nbt.method_10577("IsAdvanced");
        }
        super.method_5749(nbt);
    }
}

