/*
 * Decompiled with CFR 0.152.
 */
package com.thunderbear06.entity.android;

import com.thunderbear06.AndroidPlatformHelper;
import com.thunderbear06.ai.AndroidBrain;
import com.thunderbear06.computer.AndroidComputerContainer;
import com.thunderbear06.computer.EntityComputer;
import com.thunderbear06.entity.player.AndroidPlayer;
import com.thunderbear06.inventory.AndroidInventory;
import com.thunderbear06.item.ItemRegistry;
import com.thunderbear06.tags.TagRegistry;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import java.util.UUID;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1409;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2556;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_7471;
import net.minecraft.class_8111;
import org.jetbrains.annotations.Nullable;

public class BaseAndroidEntity
extends class_1314 {
    public AndroidBrain brain;
    public final AndroidInventory inventory;
    protected final AndroidComputerContainer computerContainer;
    protected final int maxFuel = 10000;
    protected int fuel = 0;
    public boolean isOn = false;

    protected BaseAndroidEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
        ((class_1409)this.method_5942()).method_6363(true);
        this.inventory = new AndroidInventory(9);
        this.computerContainer = new AndroidComputerContainer(this);
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        return entityData;
    }

    public void method_6007() {
        super.method_6007();
        this.brain.getModules().interactionModule.tickDoorInteraction();
    }

    public void method_5773() {
        super.method_5773();
        this.method_6119();
        if (this.method_37908().method_8608()) {
            return;
        }
        this.computerContainer.onTick();
        if (this.field_6012 % 20 > 0) {
            return;
        }
        if (this.isIdle()) {
            this.updatePeripherals();
        } else {
            this.consumeFuel();
        }
    }

    protected boolean isIdle() {
        return true;
    }

    public void shutdown() {
        this.isOn = false;
        this.brain.onShutdown();
    }

    private void updatePeripherals() {
        if (this.computerContainer.getComputerID() < 0 || !this.computerContainer.isOn) {
            return;
        }
        for (class_2350 direction : class_2350.method_42013().toList()) {
            if (direction == class_2350.field_11036 || this.getComputer().hasUpgrade(ComputerSide.valueOf((int)direction.ordinal()))) continue;
            IPeripheral peripheral = AndroidPlatformHelper.get().getPeripheral((class_3218)this.method_37908(), this.method_24515().method_10093(direction), direction, () -> this.computerContainer.setPeripheral(ComputerSide.valueOf((int)direction.method_10146()), null));
            this.computerContainer.setPeripheral(ComputerSide.valueOf((int)direction.method_10146()), peripheral);
        }
    }

    public void method_6122(class_1268 hand, class_1799 stack) {
        super.method_6122(hand, stack);
        this.getComputer().onHandItemChanged(hand);
        if (this.getComputer().isOn) {
            this.getComputer().getUpgradePeripherals();
        }
    }

    protected void consumeFuel() {
        if (this.fuel > 0) {
            --this.fuel;
        }
    }

    private int getFuelMultiplier(class_1799 stack) {
        if (stack.method_31573(TagRegistry.MINOR_ANDROID_FUEL)) {
            return 10;
        }
        if (stack.method_31573(TagRegistry.MEDIUM_ANDROID_FUEL)) {
            return 80;
        }
        if (stack.method_31573(TagRegistry.MAJOR_ANDROID_FUEL)) {
            return 800;
        }
        return 0;
    }

    public boolean addFuel(int min, class_1799 stack) {
        int mult = this.getFuelMultiplier(stack);
        if (mult <= 0) {
            return false;
        }
        int fuelAvailable = Math.min(min, stack.method_7947());
        int fuelNeeded = this.maxFuel - this.fuel;
        int fuelUsed = Math.min(fuelAvailable, fuelNeeded);
        this.setFuel(Math.min(this.fuel + fuelUsed * mult, this.maxFuel));
        stack.method_7934(fuelUsed);
        return true;
    }

    public int getFuel() {
        return this.fuel;
    }

    public void setFuel(int newFuel) {
        this.fuel = newFuel;
    }

    public boolean hasFuel() {
        return this.fuel > 0;
    }

    public AndroidComputerContainer getComputer() {
        return this.computerContainer;
    }

    public MethodResult pickupGroundItem(class_1542 itemEntity) {
        if (itemEntity.method_31481()) {
            return MethodResult.of((Object)"Item does not exist");
        }
        if (itemEntity.method_6983().method_7960()) {
            return MethodResult.of((Object)"Cannot pickup item. Item is broken (Contact mod author)");
        }
        if (itemEntity.method_6977()) {
            return MethodResult.of((Object)"Unable to pickup item");
        }
        this.method_5949(itemEntity);
        return MethodResult.of();
    }

    public MethodResult dropHandItem() {
        class_1799 itemStack = this.method_6047();
        if (itemStack.method_7960()) {
            return MethodResult.of((Object)"Hand is empty");
        }
        this.method_5775(itemStack);
        this.method_6122(class_1268.field_5808, class_1799.field_8037);
        return MethodResult.of();
    }

    protected void method_16078() {
        this.dropCPU();
        this.method_5775(((class_1792)ItemRegistry.REDSTONE_REACTOR.get()).method_7854());
        for (class_1799 stack : this.inventory.method_24514()) {
            this.method_5775(stack);
        }
    }

    private void dropCPU() {
        boolean isCommand = this.computerContainer.getFamily() == ComputerFamily.COMMAND;
        class_1799 stack = new class_1799((class_1935)(isCommand ? class_1802.field_8866 : (class_1935)ItemRegistry.ANDROID_CPU.get()));
        if (this.computerContainer.getComputerID() >= 0) {
            class_2487 compound = new class_2487();
            compound.method_10569("ComputerID", this.computerContainer.getComputerID());
            stack.method_7980(compound);
        }
        this.method_5775(stack);
    }

    public class_1799 method_24523(class_1799 stack) {
        class_1304 equipmentSlot = class_1304.field_6173;
        class_1799 itemStack = this.method_6118(equipmentSlot);
        if (this.method_5939(stack)) {
            if (!itemStack.method_7960()) {
                this.method_5775(itemStack);
            }
            this.method_24834(equipmentSlot, stack);
            return stack;
        }
        return class_1799.field_8037;
    }

    public class_1799 stashStack(class_1799 stack, int index) {
        class_1799 storedStack = this.inventory.method_5438(index);
        if (storedStack.method_7960()) {
            this.inventory.method_5447(index, stack);
            return class_1799.field_8037;
        }
        if (storedStack.method_31574(stack.method_7909())) {
            int space = storedStack.method_7914() - storedStack.method_7947();
            int transfer = Math.min(stack.method_7947(), space);
            storedStack.method_7933(transfer);
            stack.method_7934(transfer);
        }
        return stack.method_7960() ? class_1799.field_8037 : stack;
    }

    public class_1799 getStashItem(int index, boolean remove) {
        class_1799 storedStack = this.inventory.method_5438(index);
        if (remove) {
            this.inventory.method_5447(index, class_1799.field_8037);
        }
        return storedStack;
    }

    public void swapOffHandStack() {
        class_1799 mainHandStack = this.method_6047().method_7972();
        this.method_6122(class_1268.field_5808, this.method_6079().method_7972());
        this.method_6122(class_1268.field_5810, mainHandStack);
    }

    @Nullable
    public MethodResult canStash(class_1799 itemStack, int index) {
        if (index < 0 || index > this.inventory.method_5439() - 1) {
            return MethodResult.of((Object)String.format("Index must be between 0 and %d", this.inventory.method_5439()));
        }
        class_1799 storedStack = this.inventory.method_5438(index);
        if (!storedStack.method_7960() && !class_1799.method_31577((class_1799)storedStack, (class_1799)itemStack)) {
            return MethodResult.of((Object)"Index is occupied by another item stack!");
        }
        return null;
    }

    public void sendChatMessage(String msg) {
        if (this.method_5682() == null) {
            return;
        }
        AndroidPlayer player = AndroidPlayer.get(this.brain);
        this.method_5682().method_3760().method_43673(class_7471.method_45041((String)msg), player.player(), class_2556.method_44832((class_5321)class_2556.field_11737, (class_1297)this));
    }

    public void readChatMessage(String msg, String senderName, UUID senderUUID) {
        if (!this.isOn) {
            return;
        }
        EntityComputer computer = this.getComputer().getServerComputer();
        if (computer == null) {
            return;
        }
        computer.queueEvent("onChatMessage", new Object[]{msg, senderName, senderUUID.toString()});
    }

    public void method_5652(class_2487 nbt) {
        nbt.method_10566("Items", (class_2520)this.inventory.toNbtCompound());
        nbt.method_10569("Fuel", this.getFuel());
        class_2487 computerCompound = new class_2487();
        this.computerContainer.writeNbt(computerCompound);
        this.brain.writeNbt(computerCompound);
        nbt.method_10566("ComputerEntity", (class_2520)computerCompound);
        super.method_5652(nbt);
    }

    public void method_5749(class_2487 nbt) {
        this.inventory.fromNbtCompound(nbt.method_10562("Items"));
        if (nbt.method_10545("Fuel")) {
            this.setFuel(nbt.method_10550("Fuel"));
        }
        if (nbt.method_10545("ComputerEntity")) {
            class_2487 computerCompound = nbt.method_10562("ComputerEntity");
            this.computerContainer.readNbt(computerCompound);
            this.brain.readNbt(computerCompound);
        }
        super.method_5749(nbt);
    }

    public boolean method_17326() {
        return true;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (source.method_49708(class_8111.field_42345)) {
            return false;
        }
        if (source.method_49708(class_8111.field_42349)) {
            return false;
        }
        return super.method_5643(source, amount);
    }

    protected void method_6020(class_1293 effect, @Nullable class_1297 source) {
    }

    protected void method_6009(class_1293 effect, boolean reapplyEffect, @Nullable class_1297 source) {
    }

    public boolean method_6094() {
        return true;
    }

    public void method_5650(class_1297.class_5529 reason) {
        super.method_5650(reason);
        EntityComputer computer = this.computerContainer.getServerComputer();
        if (computer != null) {
            computer.close();
        }
    }

    public double getEntitySearchRadius() {
        return 10.0;
    }

    public int getBlockSearchRadius() {
        return 10;
    }
}

