/*
 * Decompiled with CFR 0.152.
 */
package com.thunderbear06.entity.android;

import com.thunderbear06.CCAndroids;
import com.thunderbear06.ai.AndroidBrain;
import com.thunderbear06.ai.AndroidLookAtEntityGoal;
import com.thunderbear06.entity.EntityRegistry;
import com.thunderbear06.entity.android.BaseAndroidEntity;
import com.thunderbear06.entity.android.frame.AndroidFrame;
import com.thunderbear06.item.ItemRegistry;
import com.thunderbear06.sounds.SoundRegistry;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3489;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import org.jetbrains.annotations.Nullable;

public class AndroidEntity
extends BaseAndroidEntity {
    private static final class_2940<Boolean> IS_LOCKED = class_2945.method_12791(AndroidEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Byte> VARIANT = class_2945.method_12791(AndroidEntity.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Byte> FACE = class_2945.method_12791(AndroidEntity.class, (class_2941)class_2943.field_13319);

    public AndroidEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
        this.brain = new AndroidBrain(this);
        this.computerContainer.setFamily(ComputerFamily.NORMAL);
        this.initAndroidGoals();
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(IS_LOCKED, (Object)false);
        this.field_6011.method_12784(VARIANT, (Object)0);
        this.field_6011.method_12784(FACE, (Object)0);
    }

    public static class_5132.class_5133 createAndroidAttributes() {
        return AndroidEntity.method_26828().method_26868(class_5134.field_23716, (double)CCAndroids.CONFIG.AndroidMaxHealth).method_26868(class_5134.field_23721, (double)CCAndroids.CONFIG.AndroidDamage).method_26868(class_5134.field_23719, (double)CCAndroids.CONFIG.AndroidSpeed).method_26868(class_5134.field_23724, (double)CCAndroids.CONFIG.AndroidArmor);
    }

    protected void initAndroidGoals() {
        this.field_6201.method_6277(0, (class_1352)new AndroidLookAtEntityGoal(this, class_1657.class, 10.0f));
    }

    @Override
    public void method_6007() {
        super.method_6007();
        if (this.hasFuel()) {
            this.brain.getTaskManager().tick();
        } else if (!this.method_5942().method_6357()) {
            this.method_5942().method_6340();
        }
    }

    @Override
    protected boolean isIdle() {
        return this.brain.getTaskManager().isIdle();
    }

    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (this.isLocked() && !this.brain.isOwningPlayer(player)) {
            this.method_37908().method_8396(null, this.method_24515(), class_3417.field_15131, class_3419.field_15254, 1.0f, 1.0f);
            player.method_7353((class_2561)class_2561.method_43471((String)"entity.cc_androids.android.locked"), true);
            return class_1269.field_5814;
        }
        if (player.method_5715()) {
            player.method_6122(class_1268.field_5808, this.swapHandStack(player.method_5998(hand)));
            return class_1269.field_5812;
        }
        class_1799 playerHandStack = player.method_5998(hand);
        class_1269 itemUseResult = this.handleItemUse(playerHandStack);
        if (itemUseResult != null) {
            return itemUseResult;
        }
        if (!this.method_37908().method_8608()) {
            if (playerHandStack.method_31574(class_1802.field_8366) && this.brain.isOwningPlayer(player)) {
                this.setLocked(!this.isLocked());
                return class_1269.field_5812;
            }
            if (this.brain.getOwningPlayerProfile() == null) {
                this.brain.setOwningPlayer(player.method_7334());
            }
            this.getComputer().openComputer((class_3222)player);
        }
        return class_1269.field_21466;
    }

    private class_1269 handleItemUse(class_1799 stack) {
        if (stack.method_31574((class_1792)ItemRegistry.WRENCH.get())) {
            return class_1269.field_5811;
        }
        if (stack.method_31574((class_1792)ItemRegistry.COMPONENTS.get())) {
            this.repair(stack);
            return class_1269.field_5812;
        }
        if (stack.method_31574(class_1802.field_8298)) {
            this.setVariant((byte)1);
            return class_1269.field_5812;
        }
        if (stack.method_31574(class_1802.field_8330)) {
            this.setVariant((byte)2);
            return class_1269.field_5812;
        }
        return null;
    }

    public boolean isLocked() {
        return (Boolean)this.field_6011.method_12789(IS_LOCKED);
    }

    public void setLocked(boolean locked) {
        this.field_6011.method_12778(IS_LOCKED, (Object)locked);
    }

    public byte getVariant() {
        return (Byte)this.field_6011.method_12789(VARIANT);
    }

    public void setVariant(byte variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant);
    }

    public boolean hasVariant() {
        return this.getVariant() > 0;
    }

    public void setFace(String faceName) {
        byte face = switch (faceName) {
            case "angry" -> 1;
            case "annoyed" -> 2;
            case "happy" -> 3;
            case "sad" -> 4;
            case "woozy" -> 5;
            default -> 0;
        };
        this.field_6011.method_12778(FACE, (Object)face);
    }

    public byte getFace() {
        return (Byte)this.field_6011.method_12789(FACE);
    }

    public void deconstruct() {
        super.method_16078();
        this.dropComponents(true);
        this.dropIngots(true);
        AndroidFrame frame = (AndroidFrame)this.method_29243((class_1299)EntityRegistry.ANDROID_FRAME_ENTITY.get(), false);
        frame.method_5719((class_1297)this);
        this.method_37908().method_8396(null, this.method_24515(), class_3417.field_14665, class_3419.field_15254, 1.0f, 1.0f);
    }

    protected class_1799 swapHandStack(class_1799 stack) {
        class_1799 heldStack = this.method_6047();
        if (stack.method_31573(class_3489.field_20344)) {
            this.spawnHearts();
        }
        this.method_6122(class_1268.field_5808, stack);
        return heldStack;
    }

    public boolean repair(class_1799 stack) {
        if (this.method_6032() < this.method_6063()) {
            this.method_37908().method_43129(null, (class_1297)this, class_3417.field_21077, class_3419.field_15254, 1.0f, 1.0f);
            this.method_6025(5.0f);
            stack.method_7934(1);
            return true;
        }
        return false;
    }

    private void spawnHearts() {
        double d = this.field_5974.method_43059() * 0.02;
        double e = this.field_5974.method_43059() * 0.02;
        double f = this.field_5974.method_43059() * 0.02;
        this.method_37908().method_8406((class_2394)class_2398.field_11201, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), d, e, f);
    }

    @Nullable
    protected class_3414 method_5994() {
        return (class_3414)SoundRegistry.ANDROID_AMBIENT.get();
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return (class_3414)SoundRegistry.ANDROID_HURT.get();
    }

    @Nullable
    protected class_3414 method_6002() {
        return (class_3414)SoundRegistry.ANDROID_DEATH.get();
    }

    @Override
    protected void method_16078() {
        super.method_16078();
        this.dropIngots(false);
        this.dropComponents(false);
    }

    protected void dropIngots(boolean full) {
        this.method_5775(class_1802.field_8620.method_7854().method_46651((int)((double)CCAndroids.CONFIG.IngotsForConstruction * (full ? 1.0 : (double)CCAndroids.CONFIG.IngotsDroppedOnDeathPercentage))));
    }

    protected void dropComponents(boolean full) {
        this.method_5775(((class_1792)ItemRegistry.COMPONENTS.get()).method_7854().method_46651((int)((double)CCAndroids.CONFIG.CompsForConstruction * (full ? 1.0 : (double)CCAndroids.CONFIG.CompsDroppedOnDeathPercentage))));
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10567("Variant", this.getVariant());
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.field_6011.method_12778(VARIANT, (Object)nbt.method_10571("Variant"));
    }
}

