/*
 * Decompiled with CFR 0.152.
 */
package com.thunderbear06.computer.api;

import com.thunderbear06.ai.AndroidBrain;
import com.thunderbear06.ai.task.tasks.AttackEntityTask;
import com.thunderbear06.ai.task.tasks.BreakBlockTask;
import com.thunderbear06.ai.task.tasks.InteractBlockTask;
import com.thunderbear06.ai.task.tasks.InteractEntityTask;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class AndroidAPI
implements ILuaAPI {
    private final AndroidBrain brain;

    public AndroidAPI(AndroidBrain android) {
        this.brain = android;
    }

    public String[] getNames() {
        return new String[]{"android"};
    }

    @Nullable
    public String getModuleName() {
        return "android";
    }

    private boolean missingFuel() {
        return !this.brain.getAndroid().hasFuel();
    }

    private class_2338 getPosFromArgs(IArguments args) throws LuaException {
        Object o = args.get(0);
        if (o instanceof Map) {
            Map pos = (Map)o;
            if (!(pos.containsKey("x") && pos.containsKey("y") && pos.containsKey("z"))) {
                throw new LuaException("x,y,z keys expected");
            }
            int x = ((Double)pos.get("x")).intValue();
            int y = ((Double)pos.get("y")).intValue();
            int z = ((Double)pos.get("z")).intValue();
            return new class_2338(x, y, z);
        }
        int x = args.getInt(0);
        int y = args.getInt(1);
        int z = args.getInt(2);
        return new class_2338(x, y, z);
    }

    @LuaFunction
    public final MethodResult currentTask() {
        return MethodResult.of((Object)this.brain.getTaskManager().getCurrentTaskName());
    }

    @LuaFunction
    public final MethodResult getSelf() throws LuaException {
        return MethodResult.of(this.brain.getModules().sensorModule.collectEntityInfo((class_1297)this.brain.getAndroid()));
    }

    @LuaFunction
    public final MethodResult attack(String entityUUID) throws LuaException {
        if (this.missingFuel()) {
            throw new LuaException("Android requires fuel.");
        }
        class_1309 target = (class_1309)((class_3218)this.brain.getAndroid().method_37908()).method_14190(UUID.fromString(entityUUID));
        if (target == null) {
            return MethodResult.of((Object[])new Object[]{true, "Unknown entity or invalid UUID"});
        }
        this.brain.setTask(new AttackEntityTask(this.brain.getAndroid(), 0.5, target));
        return MethodResult.of();
    }

    @LuaFunction
    public final MethodResult goTo(String entityUUID) throws LuaException {
        if (this.missingFuel()) {
            throw new LuaException("Android requires fuel.");
        }
        return this.brain.getModules().navigationModule.MoveToEntity(entityUUID);
    }

    @LuaFunction
    public final MethodResult moveTo(IArguments args) throws LuaException {
        if (this.missingFuel()) {
            throw new LuaException("Android requires fuel.");
        }
        return this.brain.getModules().navigationModule.MoveToBlock(this.getPosFromArgs(args));
    }

    @LuaFunction
    public final MethodResult breakBlock(IArguments args) throws LuaException {
        if (this.missingFuel()) {
            throw new LuaException("Android requires fuel.");
        }
        class_2338 pos = this.getPosFromArgs(args);
        if (!pos.method_19771((class_2382)this.brain.getAndroid().method_24515(), 100.0)) {
            return MethodResult.of((Object[])new Object[]{true, "Block position must be within a 100 block radius"});
        }
        if (!this.brain.getAndroid().method_37908().method_24794(pos)) {
            return MethodResult.of((Object[])new Object[]{true, "Block position must be in world build limit"});
        }
        this.brain.setTask(new BreakBlockTask(this.brain.getAndroid(), 0.5, pos));
        return MethodResult.of();
    }

    @LuaFunction
    public final MethodResult useBlock(IArguments args) throws LuaException {
        if (this.missingFuel()) {
            throw new LuaException("Android requires fuel.");
        }
        class_2338 pos = this.getPosFromArgs(args);
        if (!this.brain.getAndroid().method_37908().method_24794(pos)) {
            return MethodResult.of((Object[])new Object[]{true, "Block position must be in world build limit"});
        }
        this.brain.setTask(new InteractBlockTask(this.brain.getAndroid(), 0.5, pos));
        return MethodResult.of();
    }

    @LuaFunction
    public final MethodResult useEntity(String entityUUID) throws LuaException {
        if (this.missingFuel()) {
            throw new LuaException("Android requires fuel.");
        }
        class_1309 target = (class_1309)((class_3218)this.brain.getAndroid().method_37908()).method_14190(UUID.fromString(entityUUID));
        if (target == null || target.method_31481()) {
            return MethodResult.of((Object[])new Object[]{true, "Unknown entity or invalid UUID"});
        }
        this.brain.setTask(new InteractEntityTask(this.brain.getAndroid(), 0.5, target));
        return MethodResult.of();
    }

    @LuaFunction(mainThread=true)
    public final MethodResult pickup(IArguments args) throws LuaException {
        String type = args.optString(0).orElse(null);
        class_1542 itemEntity = this.brain.getModules().sensorModule.getGroundItem(type);
        if (itemEntity == null) {
            return MethodResult.of((Object[])new Object[]{true, "Could not find item"});
        }
        if (!this.brain.getAndroid().method_6047().method_7960()) {
            return MethodResult.of((Object[])new Object[]{true, "Cannot pickup item without an empty hand"});
        }
        return this.brain.getAndroid().pickupGroundItem(itemEntity);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult dropItem() {
        return this.brain.getAndroid().dropHandItem();
    }

    @LuaFunction(mainThread=true)
    public final MethodResult storeItem(int index) {
        class_1799 itemStack = this.brain.getAndroid().method_6047();
        if (itemStack.method_7960()) {
            return MethodResult.of((Object[])new Object[]{true, "No item in hand to stash"});
        }
        MethodResult result = this.brain.getAndroid().canStash(itemStack, index);
        if (result != null) {
            return result;
        }
        itemStack = this.brain.getAndroid().stashStack(itemStack, index);
        this.brain.getAndroid().method_6122(class_1268.field_5808, itemStack);
        return MethodResult.of((Object[])new Object[]{false, "Stashed held item at index " + index});
    }

    @LuaFunction(mainThread=true)
    public final MethodResult equipSlot(int index) {
        int size = this.brain.getAndroid().inventory.method_5439() - 1;
        if (index < 0 || index > size) {
            return MethodResult.of((Object[])new Object[]{true, String.format("Index must be between 0 and %d", size)});
        }
        if (!this.brain.getAndroid().method_6047().method_7960()) {
            return MethodResult.of((Object)"Cannot equip item while holding an item");
        }
        class_1799 storedItemstack = this.brain.getAndroid().getStashItem(index, true);
        if (storedItemstack.method_7960()) {
            return MethodResult.of((Object)"Index of stash is empty");
        }
        this.brain.getAndroid().method_6122(class_1268.field_5808, storedItemstack);
        return MethodResult.of((Object[])new Object[]{false, "Equipped stack from index " + index});
    }

    @LuaFunction(mainThread=true)
    public final MethodResult swapHands() {
        this.brain.getAndroid().swapOffHandStack();
        return MethodResult.of();
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getHandInfo(String handName) {
        class_1799 stack;
        if (handName.equals("right") || handName.equals("main")) {
            stack = this.brain.getAndroid().method_6047();
        } else if (handName.equals("left") || handName.equals("off")) {
            stack = this.brain.getAndroid().method_6079();
        } else {
            return MethodResult.of((Object[])new Object[]{true, "Invalid hand name"});
        }
        return MethodResult.of((Object[])new Object[]{stack.method_7964().getString(), stack.method_7947()});
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getSlotInfo(int index) {
        int size = this.brain.getAndroid().inventory.method_5439() - 1;
        if (index < 0 || index > size) {
            return MethodResult.of((Object[])new Object[]{true, String.format("Index must be between 0 and %d", size)});
        }
        class_1799 storedStack = this.brain.getAndroid().getStashItem(index, false);
        if (storedStack == null || storedStack.method_7960()) {
            return MethodResult.of((Object)"empty");
        }
        return MethodResult.of((Object[])new Object[]{false, storedStack.method_7909().method_7848().getString()});
    }

    @LuaFunction(mainThread=true)
    public final MethodResult refuel(IArguments args) throws LuaException {
        Optional amt = args.optInt(0);
        class_1799 heldStack = this.brain.getAndroid().method_6047();
        if (heldStack.method_7960()) {
            return MethodResult.of((Object[])new Object[]{true, "Hand is empty"});
        }
        if (!this.brain.getAndroid().addFuel(amt.orElse(heldStack.method_7947()), heldStack)) {
            return MethodResult.of((Object[])new Object[]{true, "Held item stack cannot be used for fuel"});
        }
        this.brain.getAndroid().method_6122(class_1268.field_5808, heldStack);
        return MethodResult.of((Object[])new Object[]{false, "Fuel level increased to " + this.brain.getAndroid().getFuel()});
    }

    @LuaFunction(mainThread=true)
    public final MethodResult fuelLevel() {
        return MethodResult.of((Object)this.brain.getAndroid().getFuel());
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getClosestPlayer() throws LuaException {
        return MethodResult.of(this.brain.getModules().sensorModule.getClosestPlayer());
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getNearbyMobs(IArguments args) throws LuaException {
        Optional type = args.optString(0);
        return MethodResult.of(this.brain.getModules().sensorModule.getMobs(type.orElse(null)));
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getClosestMob(IArguments args) throws LuaException {
        Optional type = args.optString(0);
        return MethodResult.of(this.brain.getModules().sensorModule.getClosestMobOfType(type.orElse(null)));
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getBlocksOfType(String type) {
        class_2338 pos = this.brain.getAndroid().method_24515();
        class_3218 world = (class_3218)this.brain.getAndroid().method_37908();
        return MethodResult.of(this.brain.getModules().sensorModule.getBlocksOfType(pos, this.brain.getAndroid().method_33571(), (class_1937)world, type));
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getContainerInfo(IArguments args) throws LuaException {
        class_2338 pos = this.getPosFromArgs(args);
        return MethodResult.of(this.brain.getModules().sensorModule.GetContainerInfo(pos));
    }

    @LuaFunction(mainThread=true)
    public final MethodResult storeHeldItemInContainer(IArguments args) throws LuaException {
        class_2338 pos = this.getPosFromArgs(args);
        int slot = args.count() == 2 ? args.getInt(1) : args.getInt(3);
        this.brain.getModules().interactionModule.StoreHeldItemInContainer(pos, slot);
        return MethodResult.of();
    }

    @LuaFunction(mainThread=true)
    public final MethodResult grabItemFromContainer(IArguments args) throws LuaException {
        class_2338 pos = this.getPosFromArgs(args);
        int slot = args.count() == 2 ? args.getInt(1) : args.getInt(3);
        this.brain.getModules().interactionModule.GrabItemFromContainer(pos, slot);
        return MethodResult.of();
    }

    @LuaFunction
    public final MethodResult sendChatMessage(String what) {
        this.brain.getAndroid().sendChatMessage(what);
        return MethodResult.of();
    }

    @LuaFunction
    public final MethodResult changeFace(String faceName) {
        this.brain.getAndroid().setFace(faceName);
        return MethodResult.of();
    }

    @LuaFunction
    public final MethodResult cancelTask() {
        this.brain.getTaskManager().clearCurrentTask();
        return MethodResult.of();
    }
}

