/*
 * Decompiled with CFR 0.152.
 */
package com.thunderbear06.computer;

import com.thunderbear06.CCAndroids;
import com.thunderbear06.ai.AndroidBrain;
import com.thunderbear06.component.ComputerComponents;
import com.thunderbear06.computer.EntityComputer;
import com.thunderbear06.computer.peripherals.DummyPocket;
import com.thunderbear06.entity.android.BaseAndroidEntity;
import com.thunderbear06.menu.AndroidMenu;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import dan200.computercraft.shared.network.container.ContainerData;
import dan200.computercraft.shared.platform.PlatformHelper;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class AndroidComputerContainer {
    private final BaseAndroidEntity android;
    public class_2561 label = class_2561.method_43471((String)"entity.cc_androids.android");
    public boolean isOn = false;
    public boolean fresh = false;
    @Nullable
    private UUID instanceID = null;
    private int computerID = -1;
    private boolean startOn = false;
    public ComputerFamily family;
    private UpgradeData<IPocketUpgrade> leftUpgrade;
    private UpgradeData<IPocketUpgrade> rightUpgrade;
    private final DummyPocket dummyPocket;

    public AndroidComputerContainer(BaseAndroidEntity android) {
        this.android = android;
        this.dummyPocket = new DummyPocket(android);
    }

    public void onTick() {
        if (this.computerID < 0 && !this.startOn) {
            return;
        }
        EntityComputer computer = this.getOrCreateServerComputer();
        if (this.startOn) {
            this.turnOn(computer);
            this.startOn = false;
        }
        this.fresh = false;
        this.computerID = computer.getID();
        this.updateOwnerLabel(computer);
        this.tickPeripherals();
        computer.keepAlive();
        if (!this.isOn && this.android.isOn) {
            this.android.shutdown();
        }
    }

    public void turnOn(ServerComputer computer) {
        computer.turnOn();
        this.computerID = computer.getID();
        this.android.isOn = true;
        this.isOn = true;
        this.onHandItemChanged(class_1268.field_5808);
        this.onHandItemChanged(class_1268.field_5810);
        this.getUpgradePeripherals();
    }

    public void openComputer(class_3222 player) {
        EntityComputer computer = this.getOrCreateServerComputer();
        if (!this.isOn) {
            this.turnOn(computer);
        }
        PlatformHelper.get().openMenu((class_1657)player, this.label, (syncId, playerInventory, player1) -> AndroidMenu.ofBrain(syncId, playerInventory, this.getBrain()), (ContainerData)new ComputerContainerData((ServerComputer)computer, class_1799.field_8037));
    }

    protected void updateOwnerLabel(ServerComputer computer) {
        String computerLabel = computer.getLabel();
        if (!this.label.toString().equals(computerLabel)) {
            this.label = computerLabel == null || computerLabel.isEmpty() ? class_2561.method_43471((String)"entity.cc_androids.android") : class_2561.method_43470((String)computerLabel);
            this.android.method_5665(this.label);
        }
    }

    public final EntityComputer getOrCreateServerComputer() {
        MinecraftServer server = this.android.method_37908().method_8503();
        if (server == null) {
            throw new IllegalStateException("Cannot access server computer on the client.");
        }
        EntityComputer computer = (EntityComputer)ServerContext.get((MinecraftServer)server).registry().get(this.instanceID);
        if (computer == null) {
            if (this.computerID < 0) {
                this.computerID = ComputerCraftAPI.createUniqueNumberedSaveDir((MinecraftServer)server, (String)"computer");
            }
            computer = this.createComputer(this.computerID);
            this.instanceID = computer.register();
            this.fresh = true;
        }
        return computer;
    }

    public void setPeripheral(ComputerSide side, IPeripheral peripheral) {
        EntityComputer computer = this.getServerComputer();
        if (computer == null) {
            CCAndroids.LOGGER.error("Failed to set peripheral of type {} on side {} of computer container owned by {}. Reason: Failed to get ServerComputer (It was null)", new Object[]{peripheral.getType(), side.getName(), this.android.method_5477()});
            return;
        }
        computer.setPeripheral(side, peripheral);
    }

    public boolean isOn() {
        EntityComputer computer = this.getServerComputer();
        return computer != null && computer.isOn();
    }

    public ComputerFamily getFamily() {
        return this.family;
    }

    public int getComputerID() {
        return this.computerID;
    }

    public void setFamily(ComputerFamily family) {
        this.family = family;
    }

    public void setComputerID(int id) {
        this.computerID = id;
    }

    public AndroidBrain getBrain() {
        return this.android.brain;
    }

    protected EntityComputer createComputer(int id) {
        ServerComputer.Properties properties = ServerComputer.properties((int)id, (ComputerFamily)this.getFamily()).addComponent(ComputerComponents.ANDROID_COMPUTER, (Object)this.android.brain).label(this.label.toString()).terminalSize(39, 13);
        return new EntityComputer((class_3218)this.android.method_37908(), this.android, properties);
    }

    @Nullable
    public EntityComputer getServerComputer() {
        return !this.android.method_37908().field_9236 && this.android.method_37908().method_8503() != null ? (EntityComputer)ServerContext.get((MinecraftServer)this.android.method_37908().method_8503()).registry().get(this.instanceID) : null;
    }

    public void writeNbt(class_2487 computerCompound) {
        computerCompound.method_10556("StartOn", this.startOn);
        computerCompound.method_10569("ComputerID", this.getComputerID());
    }

    public void readNbt(class_2487 computerCompound) {
        this.startOn = computerCompound.method_10577("StartOn");
        if (computerCompound.method_10545("ComputerID")) {
            this.setComputerID(computerCompound.method_10550("ComputerID"));
        }
    }

    public void getUpgradePeripherals() {
        this.setPeripheral(ComputerSide.LEFT, this.leftUpgrade == null ? null : ((IPocketUpgrade)this.leftUpgrade.upgrade()).createPeripheral((IPocketAccess)this.dummyPocket));
        this.setPeripheral(ComputerSide.RIGHT, this.rightUpgrade == null ? null : ((IPocketUpgrade)this.rightUpgrade.upgrade()).createPeripheral((IPocketAccess)this.dummyPocket));
    }

    private void tickPeripherals() {
        EntityComputer computer = this.getServerComputer();
        assert (computer != null);
        if (this.leftUpgrade != null) {
            ((IPocketUpgrade)this.leftUpgrade.upgrade()).update((IPocketAccess)this.dummyPocket, computer.getPeripheral(ComputerSide.LEFT));
        }
        if (this.rightUpgrade != null) {
            ((IPocketUpgrade)this.rightUpgrade.upgrade()).update((IPocketAccess)this.dummyPocket, computer.getPeripheral(ComputerSide.RIGHT));
        }
    }

    public boolean hasUpgrade(ComputerSide side) {
        return side == ComputerSide.LEFT && this.leftUpgrade != null || side == ComputerSide.RIGHT && this.rightUpgrade != null;
    }

    public void onHandItemChanged(class_1268 hand) {
        class_1799 handItem = this.android.method_5998(hand);
        if (hand == class_1268.field_5810) {
            this.leftUpgrade = this.dummyPocket.createUpgrade(handItem);
            return;
        }
        this.rightUpgrade = this.dummyPocket.createUpgrade(handItem);
    }
}

