/*
 * Decompiled with CFR 0.152.
 */
package com.thunderbear06.ai.modules;

import com.thunderbear06.ai.AndroidBrain;
import com.thunderbear06.ai.modules.AbstractAndroidModule;
import com.thunderbear06.entity.android.BaseAndroidEntity;
import com.thunderbear06.entity.player.AndroidPlayer;
import dan200.computercraft.api.lua.LuaException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2624;
import net.minecraft.class_3222;
import net.minecraft.class_3959;
import net.minecraft.class_4051;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class SensorModule
extends AbstractAndroidModule {
    private final double entitySearchRadius;
    private final int blockSearchRadius;

    public SensorModule(BaseAndroidEntity android, AndroidBrain brain, double searchRadius, int blockSearchRadius) {
        super(android, brain);
        this.entitySearchRadius = searchRadius;
        this.blockSearchRadius = blockSearchRadius;
    }

    public List<HashMap<String, Object>> getMobs(@Nullable String type) {
        ArrayList<HashMap<String, Object>> result = new ArrayList<HashMap<String, Object>>();
        this.android.method_37908().method_8390(class_1309.class, this.android.method_5829().method_1014(this.entitySearchRadius), this.getTypePredicate(type)).forEach(entity -> {
            try {
                result.add(this.collectEntityInfo((class_1297)entity));
            }
            catch (LuaException luaException) {
                // empty catch block
            }
        });
        return result;
    }

    public HashMap<String, Object> getClosestMobOfType(@Nullable String type) throws LuaException {
        class_1309 livingEntity;
        class_2338 pos = this.android.method_24515();
        class_1309 entity = this.android.method_37908().method_21726(class_1309.class, class_4051.field_18092.method_18420(this.getTypePredicate(type)), (class_1309)this.android, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10263(), this.android.method_5829().method_1014(this.entitySearchRadius));
        if (entity == null || entity instanceof class_1309 && (livingEntity = entity).method_29504()) {
            return new HashMap<String, Object>();
        }
        return this.collectEntityInfo((class_1297)entity);
    }

    public HashMap<String, Object> getClosestPlayer() throws LuaException {
        class_3222 player = (class_3222)this.android.method_37908().method_18460((class_1297)this.android, 100.0);
        if (player == null) {
            return new HashMap<String, Object>();
        }
        return this.collectEntityInfo((class_1297)player);
    }

    @Nullable
    public class_1542 getGroundItem(@Nullable String type) {
        List items = this.android.method_37908().method_18467(class_1542.class, this.android.method_5829().method_1014(5.0));
        for (class_1542 entity : items) {
            if (type != null && !class_7923.field_41178.method_10221((Object)entity.method_6983().method_7909()).toString().contains(type)) continue;
            return entity;
        }
        return null;
    }

    public List<HashMap<String, Integer>> getBlocksOfType(class_2338 origin, class_243 eyePos, class_1937 world, String type) {
        ArrayList<HashMap<String, Integer>> blocks = new ArrayList<HashMap<String, Integer>>();
        block0: for (final class_2338 pos : class_2338.method_25996((class_2338)origin, (int)this.blockSearchRadius, (int)this.blockSearchRadius, (int)this.blockSearchRadius)) {
            if (!class_7923.field_41175.method_10221((Object)world.method_8320(pos).method_26204()).toString().contains(type)) continue;
            for (class_2350 direction : class_2350.method_42013().toList()) {
                class_3959 context;
                if (world.method_8320(pos.method_10093(direction)).method_26212((class_1922)world, pos.method_10093(direction)) || !world.method_17742(context = new class_3959(eyePos, pos.method_10093(direction).method_46558(), class_3959.class_3960.field_17558, class_3959.class_242.field_1347, (class_1297)this.android)).method_17777().equals((Object)pos.method_10093(direction))) continue;
                blocks.add(new HashMap<String, Integer>(){
                    {
                        this.put("x", pos.method_10263());
                        this.put("y", pos.method_10264());
                        this.put("z", pos.method_10260());
                    }
                });
                continue block0;
            }
        }
        return blocks;
    }

    public HashMap<String, Object> collectEntityInfo(class_1297 entity) throws LuaException {
        HashMap<String, Object> infoMap = new HashMap<String, Object>();
        infoMap.put("uuid", entity.method_5845());
        infoMap.put("name", entity.method_5477().getString());
        infoMap.put("posX", entity.method_23317());
        infoMap.put("posY", entity.method_23318());
        infoMap.put("posZ", entity.method_23321());
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            infoMap.put("health", Float.valueOf(livingEntity.method_6032()));
        }
        return infoMap;
    }

    private Predicate<class_1309> getTypePredicate(@Nullable String type) {
        if (type == null) {
            return entity -> entity != this.android && this.android.method_6057((class_1297)entity);
        }
        return entity -> class_1299.method_5890((class_1299)entity.method_5864()).toString().contains(type) && entity != this.android && !entity.method_7325() && entity.method_5805() && this.android.method_6057((class_1297)entity);
    }

    public HashMap<String, Object> GetContainerInfo(class_2338 pos) throws LuaException {
        class_2624 locked;
        if (!pos.method_19769((class_2374)this.android.method_19538(), (double)this.android.getBlockSearchRadius())) {
            throw new LuaException("Position out of range");
        }
        class_3222 androidPlr = AndroidPlayer.get(this.brain).player();
        class_2586 blockEntity = this.android.method_37908().method_8321(pos);
        HashMap<String, Object> infoMap = new HashMap<String, Object>();
        if (!(blockEntity instanceof class_1263)) {
            return infoMap;
        }
        class_1263 inv = (class_1263)blockEntity;
        infoMap.put("slotCount", inv.method_5439());
        infoMap.put("locked", blockEntity instanceof class_2624 && !(locked = (class_2624)blockEntity).method_17489((class_1657)androidPlr));
        ArrayList items = new ArrayList();
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 stack = inv.method_5438(i);
            ArrayList<Object> itemInfo = new ArrayList<Object>();
            itemInfo.add(stack.method_7964().toString());
            itemInfo.add(stack.method_7947());
            items.add(itemInfo);
        }
        infoMap.put("slots", items);
        return infoMap;
    }
}

