/*
 * Decompiled with CFR 0.152.
 */
package com.thunderbear06.ai;

import com.mojang.authlib.GameProfile;
import com.thunderbear06.CCAndroids;
import com.thunderbear06.ai.modules.AndroidModules;
import com.thunderbear06.ai.task.Task;
import com.thunderbear06.ai.task.TaskManager;
import com.thunderbear06.entity.android.AndroidEntity;
import com.thunderbear06.entity.player.AndroidPlayer;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_3218;

public class AndroidBrain {
    protected final AndroidEntity android;
    protected final TaskManager taskManager;
    protected final AndroidModules modules;
    @Deprecated
    public AndroidPlayer fakePlayer;
    private GameProfile owningPlayerProfile;

    public AndroidBrain(AndroidEntity entity) {
        this.android = entity;
        this.taskManager = new TaskManager();
        this.modules = new AndroidModules(entity, this);
        this.fakePlayer = this.android.method_37908() instanceof class_3218 ? AndroidPlayer.get(this) : null;
    }

    public void onShutdown() {
        this.taskManager.clearCurrentTask();
    }

    public void setTask(Task task) {
        if (CCAndroids.CONFIG.DebugLogging) {
            CCAndroids.LOGGER.info("Set current android task to {}", (Object)task.getName());
        }
        this.taskManager.setCurrentTask(task);
    }

    public AndroidEntity getAndroid() {
        return this.android;
    }

    public AndroidModules getModules() {
        return this.modules;
    }

    public TaskManager getTaskManager() {
        return this.taskManager;
    }

    public boolean isOwningPlayer(class_1657 player) {
        return this.owningPlayerProfile == player.method_7334();
    }

    public GameProfile getOwningPlayerProfile() {
        return this.owningPlayerProfile;
    }

    public void setOwningPlayer(GameProfile gameProfile) {
        this.owningPlayerProfile = gameProfile;
    }

    public void writeNbt(class_2487 computerCompound) {
        if (this.owningPlayerProfile == null) {
            return;
        }
        computerCompound.method_25927("OwningPlayerUUID", this.owningPlayerProfile.getId());
        computerCompound.method_10582("OwningPlayerName", this.owningPlayerProfile.getName());
    }

    public void readNbt(class_2487 computerCompound) {
        if (!computerCompound.method_10545("OwningPlayerUUID")) {
            return;
        }
        this.owningPlayerProfile = new GameProfile(computerCompound.method_25926("OwningPlayerUUID"), computerCompound.method_10558("OwningPlayerName"));
    }
}

