/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.worm;

import com.neep.neepmeat.entity.skyworm.SkywormAnimationTimes;
import com.neep.neepmeat.init.NMComponents;
import com.neep.neepmeat.machine.live_machine.block.entity.DistributorPoint;
import com.neep.neepmeat.transport.worm.DistributorDestination;
import com.neep.neepmeat.transport.worm.DistributorParcel;
import com.neep.neepmeat.transport.worm.DistributorRoutingComponent;
import com.neep.neepmeat.transport.worm.RouteLock;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class GlobalDistributorRouting {
    @Nullable
    private static GlobalDistributorRouting INSTANCE = null;
    private final MinecraftServer server;
    private final Map<class_5321<class_1937>, DistributorRoutingComponent> components = new HashMap<class_5321<class_1937>, DistributorRoutingComponent>();

    public GlobalDistributorRouting(MinecraftServer server) {
        this.server = server;
    }

    public static GlobalDistributorRouting getInstance() {
        return INSTANCE;
    }

    public void registerComponent(DistributorRoutingComponent component) {
        this.components.put((class_5321<class_1937>)component.getWorld().method_27983(), component);
    }

    public static void updatePoint(DistributorPoint point) {
        NMComponents.DISTRIBUTOR.maybeGet((Object)point.getPointWorld()).ifPresent(d -> d.registerPoint(point));
    }

    public static void unregisterPoint(class_1937 world, class_2338 pos) {
        NMComponents.DISTRIBUTOR.maybeGet((Object)world).ifPresent(d -> d.unregisterPoint(pos));
    }

    private void onStart() {
        for (class_3218 world : this.server.method_3738()) {
            DistributorRoutingComponent component = (DistributorRoutingComponent)NMComponents.DISTRIBUTOR.get((Object)world);
            this.registerComponent(component);
        }
    }

    public List<DistributorDestination> getMatchingDest(String address) {
        ObjectArrayList result = new ObjectArrayList();
        for (DistributorRoutingComponent val : this.components.values()) {
            val.collectMatching((List<DistributorDestination>)result, address);
        }
        return result;
    }

    @Nullable
    public DistributorDestination findAndRoute(DistributorDestination exclude, String address) {
        List<DistributorDestination> result = this.getMatchingDest(address);
        Collections.shuffle(result);
        for (DistributorDestination entry : result) {
            if (entry.equals(exclude)) continue;
            return entry;
        }
        return null;
    }

    public void send(DistributorParcel parcel, DistributorDestination destination, SkywormAnimationTimes times) {
        DistributorRoutingComponent component = (DistributorRoutingComponent)NMComponents.DISTRIBUTOR.get((Object)destination.world());
        component.send(parcel, destination, times);
    }

    public static void init() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            INSTANCE = new GlobalDistributorRouting(server);
            INSTANCE.onStart();
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            INSTANCE = null;
        });
    }

    public RouteLock acquireRoute(DistributorDestination dest) {
        return ((DistributorRoutingComponent)NMComponents.DISTRIBUTOR.get((Object)dest.world())).acquireRoute(dest.pos());
    }

    public void releaseRoute(DistributorDestination dest) {
        ((DistributorRoutingComponent)NMComponents.DISTRIBUTOR.get((Object)dest.world())).releaseRoute(dest.pos());
    }
}

