/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.util;

import com.neep.meatlib.storage.MeatlibStorageUtil;
import com.neep.meatlib.util.graph.PipeGraphUtil;
import com.neep.neepmeat.transport.api.pipe.ItemPipe;
import com.neep.neepmeat.transport.api.pipe.PipeConnections;
import com.neep.neepmeat.transport.block.item_transport.entity.ItemPipeBlockEntity;
import com.neep.neepmeat.transport.item_network.ItemInPipe;
import com.neep.neepmeat.transport.item_network.ItemPipeVertex;
import com.neep.neepmeat.transport.item_network.ItemRoute;
import com.neep.neepmeat.transport.item_network.PipeRouteFinder;
import com.neep.neepmeat.transport.util.ItemPipeUtil;
import it.unimi.dsi.fastutil.longs.LongObjectPair;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class PipePathfinding {
    private static void miserableShift(int preferred, int[] sorted, int[] input) {
        if (preferred == -1) {
            System.arraycopy(input, 0, sorted, 0, input.length);
            return;
        }
        sorted[0] = preferred;
        int j = 0;
        for (int i = 1; i < input.length; ++i) {
            if (input[j] == preferred) {
                ++j;
            }
            sorted[i] = input[j];
            ++j;
        }
    }

    public static ItemRoute makeRoute(class_3218 world, PipeRouteFinder.Node node, class_2350 face) {
        ItemRoute route = new ItemRoute();
        PipeRouteFinder.Node n = node;
        while (n != null) {
            PipeGraphUtil.moreJankParticles(world, n.vertex);
            route.add(n.parentOutFace);
            n = n.parent;
        }
        route.remove(route.size() - 1);
        Collections.reverse(route);
        route.add(face);
        return route;
    }

    public static LongObjectPair<ItemRoute> uniformCostCapacity(ResourceAmount<ItemVariant> item, class_3218 world, class_2338 startPipe, class_2350 exit, @Nullable TransactionContext transaction) {
        ItemPipeVertex startVertex = ItemPipeVertex.find(world, startPipe);
        PriorityQueue<PipeRouteFinder.Node> frontier = new PriorityQueue<PipeRouteFinder.Node>();
        HashSet<ItemPipeVertex> visited = new HashSet<ItemPipeVertex>();
        HashMap<ItemPipeVertex, PipeRouteFinder.Node> vertexToNode = new HashMap<ItemPipeVertex, PipeRouteFinder.Node>();
        PipeRouteFinder.Node startNode = vertexToNode.computeIfAbsent(startVertex, PipeRouteFinder.Node::new);
        frontier.add(startNode);
        visited.add(startVertex);
        while (!frontier.isEmpty()) {
            PipeRouteFinder.Node node = (PipeRouteFinder.Node)frontier.poll();
            for (class_2350 face : class_2350.values()) {
                long transferable;
                Storage<ItemVariant> storage = node.vertex.getStorage(face);
                if (storage != null && (transferable = MeatlibStorageUtil.simulateInsert(storage, (ItemVariant)item.resource(), Long.MAX_VALUE, transaction)) > 0L) {
                    return LongObjectPair.of((long)transferable, (Object)((Object)PipePathfinding.makeRoute(world, node, face)));
                }
                ItemPipeVertex adj = node.vertex.getAdjVertex(face.ordinal());
                if (adj == null) continue;
                PipeRouteFinder.Node child = vertexToNode.computeIfAbsent(adj, PipeRouteFinder.Node::new);
                child.cost = node.cost + 1;
                if (!visited.contains(adj)) {
                    child.parent = node;
                    child.parentOutFace = face;
                    visited.add(adj);
                    frontier.add(child);
                    continue;
                }
                if (child.cost <= node.cost || !frontier.contains(child)) continue;
                child.parent = node;
                child.parentOutFace = face;
                frontier.remove(child);
                frontier.add(child);
            }
        }
        return LongObjectPair.of((long)0L, (Object)((Object)ItemRoute.EMPTY));
    }

    public static LongObjectPair<ItemRoute> singleRouteCapacityDFS(ResourceAmount<ItemVariant> item, class_3218 world, class_2338 startPipe, class_2350 exit, @Nullable TransactionContext transaction) {
        ItemPipeVertex startVertex = ItemPipeVertex.find(world, startPipe);
        if (startVertex == null) {
            return LongObjectPair.of((long)0L, (Object)((Object)ItemRoute.EMPTY));
        }
        HashSet<ItemPipeVertex> visited = new HashSet<ItemPipeVertex>();
        ObjectArrayList vertexRoute = new ObjectArrayList();
        ObjectArrayList route = new ObjectArrayList();
        visited.add(startVertex);
        ItemPipeVertex vertex = startVertex;
        class_2350 currentDirection = exit;
        while (true) {
            for (class_2350 direction : class_2350.values()) {
                long transferable;
                Storage<ItemVariant> storage = vertex.getStorage(direction);
                if (storage != null && (transferable = MeatlibStorageUtil.simulateInsert(storage, (ItemVariant)item.resource(), Long.MAX_VALUE, transaction)) > 0L) {
                    route.remove(0);
                    route.push((Object)direction);
                    return LongObjectPair.of((long)transferable, (Object)((Object)new ItemRoute((List<class_2350>)route)));
                }
                ItemPipeVertex adj = vertex.getAdjVertex(direction.ordinal());
                if (adj == null || visited.contains(adj)) continue;
                visited.add(adj);
                class_2350 enterDirection = adj.getDirection(vertex);
                if (!adj.canItemEnter((ItemVariant)item.resource(), item.amount(), enterDirection, false)) continue;
                route.push((Object)currentDirection);
                vertexRoute.push((Object)vertex);
                currentDirection = direction;
                vertex = adj;
            }
            if (route.isEmpty()) {
                return LongObjectPair.of((long)0L, (Object)((Object)ItemRoute.EMPTY));
            }
            vertex = (ItemPipeVertex)vertexRoute.pop();
            currentDirection = (class_2350)route.pop();
        }
    }

    public static LongObjectPair<ItemRoute> singleRouteCapacity2(ResourceAmount<ItemVariant> item, class_3218 world, class_2338 startPipe, class_2350 exit, @Nullable TransactionContext transaction) {
        ItemPipeVertex startVertex = ItemPipeVertex.find(world, startPipe);
        ArrayDeque<ItemPipeVertex> queue = new ArrayDeque<ItemPipeVertex>();
        HashSet<ItemPipeVertex> visited = new HashSet<ItemPipeVertex>();
        queue.add(startVertex);
        visited.add(startVertex);
        while (!queue.isEmpty()) {
            ItemPipeVertex vertex = (ItemPipeVertex)queue.poll();
            if (vertex == null) continue;
            for (class_2350 direction : class_2350.values()) {
                long transferable;
                Storage<ItemVariant> storage;
                ItemPipeVertex adj = vertex.getAdjVertex(direction.ordinal());
                if (adj != null && !visited.contains(adj)) {
                    visited.add(adj);
                    class_2350 enterDirection = adj.getDirection(vertex);
                    if (adj.canItemEnter((ItemVariant)item.resource(), item.amount(), enterDirection, false)) {
                        queue.add(adj);
                    }
                }
                if ((storage = vertex.getStorage(direction)) == null || (transferable = MeatlibStorageUtil.simulateInsert(storage, (ItemVariant)item.resource(), Long.MAX_VALUE, transaction)) <= 0L) continue;
                return LongObjectPair.of((long)transferable, (Object)((Object)ItemRoute.EMPTY));
            }
        }
        return LongObjectPair.of((long)0L, (Object)((Object)ItemRoute.EMPTY));
    }

    public static long singleRouteCapacity(ResourceAmount<ItemVariant> item, class_1937 world, class_2338 startPipe, class_2350 exit, @Nullable TransactionContext transaction) {
        ArrayDeque<class_2338> queue = new ArrayDeque<class_2338>();
        ArrayDeque<ItemPipe> pipeQueue = new ArrayDeque<ItemPipe>();
        ArrayDeque<class_2350> dirQueue = new ArrayDeque<class_2350>();
        LongOpenHashSet visited = new LongOpenHashSet();
        queue.add(startPipe);
        pipeQueue.add((ItemPipe)world.method_8320(startPipe).method_26204());
        dirQueue.add(exit.method_10153());
        visited.add(startPipe.method_10093(exit.method_10153()).method_10063());
        long alreadyInTransit = 0L;
        while (!queue.isEmpty()) {
            ItemPipe pipe;
            class_2338 current = (class_2338)queue.poll();
            ItemPipe currentPipe = (ItemPipe)pipeQueue.poll();
            class_2350 currentDir = (class_2350)dirQueue.poll();
            class_2680 currentState = world.method_8320(current);
            visited.add(current.method_10063());
            PipeConnections connections = currentPipe.getConnections(currentState, currentDir);
            if (!currentPipe.singleOutput() || connections.size() > 1) {
                return item.amount();
            }
            if (connections.isEmpty()) {
                return 0L;
            }
            class_2350 direction = connections.directions().iterator().next();
            class_2338 offset = current.method_10093(direction);
            class_2680 offsetState = world.method_8320(offset);
            class_2586 class_25862 = world.method_8321(current);
            if (class_25862 instanceof ItemPipeBlockEntity) {
                ItemPipeBlockEntity be = (ItemPipeBlockEntity)class_25862;
                for (ItemInPipe i : be.getItems()) {
                    if (!i.resource().equals(item.resource())) continue;
                    alreadyInTransit += i.amount();
                }
            }
            if (!currentPipe.canItemLeave(item, world, current, currentState, direction, false)) continue;
            if (ItemPipeUtil.canDumpInto(world, offset, offsetState)) {
                return item.amount();
            }
            class_2248 class_22482 = offsetState.method_26204();
            if (class_22482 instanceof ItemPipe && (pipe = (ItemPipe)class_22482).canItemEnter((ItemVariant)item.resource(), item.amount(), world, offset, offsetState, direction.method_10153(), false) && !visited.contains(offset.method_10063())) {
                queue.add(offset);
                pipeQueue.add(pipe);
                dirQueue.add(direction.method_10153());
                continue;
            }
            Storage storage = (Storage)ItemStorage.SIDED.find(world, offset, offsetState, null, (Object)direction.method_10153());
            if (storage == null) continue;
            return Math.max(0L, MeatlibStorageUtil.simulateInsert(storage, (ItemVariant)item.resource(), Long.MAX_VALUE, transaction) - alreadyInTransit);
        }
        return 0L;
    }

    public static enum OperationState {
        UNFINISHED,
        SUCCESS,
        FAIL;

    }
}

