/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.screen;

import com.neep.meatlib.api.network.ChannelFormat;
import com.neep.meatlib.api.network.ParamCodec;
import com.neep.meatlib.api.network.ParamCodecs;
import com.neep.meatlib.network.ChannelManager;
import com.neep.neepmeat.screen_handler.BasicScreenHandler;
import com.neep.neepmeat.transport.api.item_network.RoutingNetwork;
import com.neep.neepmeat.transport.block.item_transport.entity.PersistentCraftingInventory;
import com.neep.neepmeat.transport.screen.TransportScreenHandlers;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1731;
import net.minecraft.class_1734;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2596;
import net.minecraft.class_2653;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_8566;

public class ManualRequesterScreenHandler
extends BasicScreenHandler {
    public final List<class_1735> playerSlots;
    public final List<class_1735> returnSlots;
    public final List<class_1735> craftingSlots;
    public final class_1734 craftingResultSlot;
    public final ChannelManager<SyncItems> syncItemsS2C;
    public final ChannelManager<Consumer<ResourceAmount<ItemVariant>>> requestC2S;
    protected final class_1657 player;
    protected final List<ResourceAmount<ItemVariant>> items = new ArrayList<ResourceAmount<ItemVariant>>(20);
    private final class_8566 craftingInventory;
    private final class_1263 returnInventory;
    private final class_1731 craftingResultInventory = new class_1731();
    protected RoutingNetwork routingNetwork;
    protected class_2338 pos;
    private boolean dirty = true;

    public ManualRequesterScreenHandler(int syncId, class_1661 playerInventory) {
        this(syncId, playerInventory, new PersistentCraftingInventory.Simple(9), (class_1263)new class_1277(1), RoutingNetwork.DEFAULT, new class_2338(0, 0, 0), playerInventory.field_7546);
    }

    public ManualRequesterScreenHandler(int syncId, class_1661 playerInventory, class_8566 craftingInventory, class_1263 returnInventory, RoutingNetwork network, class_2338 pos, class_1657 player) {
        super(TransportScreenHandlers.ITEM_REQUESTER_HANDLER, playerInventory, returnInventory, syncId, null);
        this.craftingInventory = new PersistentCraftingInventory.Delegate(craftingInventory, this);
        this.returnInventory = returnInventory;
        this.routingNetwork = network;
        this.pos = pos;
        this.player = player;
        this.returnSlots = this.createSlotBlock(0, 0, 1, 1, returnInventory, 0, class_1735::new);
        this.craftingSlots = this.createSlotBlock(0, 0, 3, 3, (class_1263)this.craftingInventory, 0, class_1735::new);
        this.playerSlots = this.createPlayerSlots(0, 0, playerInventory);
        this.craftingResultSlot = new class_1734(player, this.craftingInventory, (class_1263)this.craftingResultInventory, this.field_7761.size(), 0, 0);
        this.method_7621((class_1735)this.craftingResultSlot);
        this.syncItemsS2C = this.addClosable(ChannelManager.create(class_2960.method_43902((String)"neepmeat", (String)"requester_screen/sync_items"), ChannelFormat.builder(SyncItems.class).param(ParamCodec.list(ParamCodecs.resourceAmount(ItemVariant::fromPacket))).build(), player));
        this.requestC2S = this.addClosable(ChannelManager.create(class_2960.method_43902((String)"neepmeat", (String)"requester_screen/request"), ChannelFormat.builder(ParamCodecs.as(Consumer.class)).param(ParamCodecs.resourceAmount(ItemVariant::fromPacket)).build(), player));
        if (!player.method_37908().method_8608()) {
            this.requestC2S.receiver(this::receiveRequest);
        }
    }

    protected static void sortItems(List<ResourceAmount<ItemVariant>> items) {
        items.sort((s1, s2) -> ((ItemVariant)s1.resource()).toStack().method_7960() ? 1 : ((ItemVariant)s1.resource()).toStack().method_7964().method_10858(256).compareTo(((ItemVariant)s2.resource()).toStack().method_7964().method_10858(256)));
    }

    protected void updateCraftingResult(class_1937 world) {
        class_1657 class_16572 = this.player;
        if (class_16572 instanceof class_3222) {
            class_1799 itemStack2;
            class_3955 craftingRecipe;
            class_3222 serverPlayer = (class_3222)class_16572;
            class_1799 itemStack = class_1799.field_8037;
            Optional optional = world.method_8433().method_8132(class_3956.field_17545, (class_1263)this.craftingInventory, world);
            if (optional.isPresent() && this.craftingResultInventory.method_7665(world, serverPlayer, (class_1860)(craftingRecipe = (class_3955)optional.get())) && (itemStack2 = craftingRecipe.method_8116((class_1263)this.craftingInventory, world.method_30349())).method_45435(world.method_45162())) {
                itemStack = itemStack2;
            }
            int resultId = this.craftingResultSlot.method_34266();
            this.craftingResultInventory.method_5447(0, itemStack);
            this.method_34245(resultId, itemStack);
            serverPlayer.field_13987.method_14364((class_2596)new class_2653(this.field_7763, this.method_37422(), resultId, itemStack));
        }
    }

    public void method_7609(class_1263 inventory) {
        super.method_7609(inventory);
        if (!this.player.method_37908().method_8608()) {
            this.updateCraftingResult(this.player.method_37908());
        }
    }

    @Override
    public class_1799 method_7601(class_1657 player, int index) {
        if (index == this.craftingResultSlot.field_7874) {
            class_1735 slot2 = this.method_7611(index);
            class_1799 itemStack2 = slot2.method_7677();
            class_1799 itemStack = itemStack2.method_7972();
            if (!player.method_37908().method_8608()) {
                itemStack2.method_7909().method_7843(itemStack2, player.method_37908(), player);
            }
            if (!this.method_7616(itemStack2, 10, 46, true)) {
                return class_1799.field_8037;
            }
            slot2.method_7670(itemStack2, itemStack);
            if (itemStack2.method_7960()) {
                slot2.method_48931(class_1799.field_8037);
            } else {
                slot2.method_7668();
            }
            if (itemStack2.method_7947() == itemStack.method_7947()) {
                return class_1799.field_8037;
            }
            slot2.method_7667(player, itemStack2);
            if (index == 0) {
                player.method_7328(itemStack2, false);
            }
            return itemStack;
        }
        if (index >= this.craftingSlots.get((int)0).field_7874 && index <= this.craftingSlots.get((int)(this.craftingSlots.size() - 1)).field_7874) {
            class_1799 originalCopy = class_1799.field_8037;
            class_1735 slot = (class_1735)this.field_7761.get(index);
            if (slot.method_7681()) {
                class_1799 mutableStack = slot.method_7677();
                originalCopy = mutableStack.method_7972();
                if (!this.method_7616(mutableStack, this.playerSlots.get((int)0).field_7874, this.playerSlots.get((int)0).field_7874 + this.playerSlots.size(), false)) {
                    return class_1799.field_8037;
                }
                if (mutableStack.method_7960()) {
                    slot.method_48931(class_1799.field_8037);
                } else {
                    slot.method_7668();
                }
            }
            return originalCopy;
        }
        return super.method_7601(player, index);
    }

    @Override
    public void method_7623() {
        super.method_7623();
        if (this.ready && (this.dirty || this.player.method_37908().method_8510() % 10L == 0L)) {
            this.syncToPacket(this.items, this.routingNetwork);
            this.dirty = false;
            this.updateCraftingResult(this.player.method_37908());
        }
    }

    private void syncToPacket(List<ResourceAmount<ItemVariant>> items, RoutingNetwork network) {
        try (Transaction transaction = Transaction.openOuter();){
            items.clear();
            List<ResourceAmount<ItemVariant>> available = network.listAllAvailable(v -> !v.isBlank(), (TransactionContext)transaction);
            items.addAll(available);
            transaction.commit();
        }
        ManualRequesterScreenHandler.sortItems(items);
        this.syncItemsS2C.emitter().apply(items);
    }

    public void receiveItems(List<ResourceAmount<ItemVariant>> items) {
        this.items.clear();
        this.items.addAll(items);
    }

    public List<ResourceAmount<ItemVariant>> getItems() {
        return this.items;
    }

    public void receiveRequest(ResourceAmount<ItemVariant> ra) {
        try (Transaction transaction = Transaction.openOuter();){
            if (this.routingNetwork.request(ra, this.pos, class_2350.field_11036, RoutingNetwork.RequestType.ANY_AMOUNT, new RoutingNetwork.RequestContext(), (TransactionContext)transaction)) {
                transaction.commit();
            }
        }
        this.dirty = true;
    }

    @Override
    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.method_7607(player, this.returnInventory);
    }

    public static interface SyncItems {
        public void apply(List<ResourceAmount<ItemVariant>> var1);
    }
}

