/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.item_network;

import com.neep.meatlib.storage.MeatlibStorageUtil;
import com.neep.neepmeat.transport.item_network.ItemPipeVertex;
import com.neep.neepmeat.transport.item_network.ItemRoute;
import com.neep.neepmeat.transport.util.ItemPipeUtil;
import com.neep.neepmeat.transport.util.PipePathfinding;
import it.unimi.dsi.fastutil.PriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectHeapPriorityQueue;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PipeRouteFinder {
    private final class_3218 world;
    private final class_2338 startPipe;

    public PipeRouteFinder(class_3218 world, class_2338 startPipe) {
        this.world = world;
        this.startPipe = startPipe;
    }

    public void thing() {
        Operation op = this.start((ResourceAmount<ItemVariant>)new ResourceAmount((Object)ItemVariant.of((class_1935)class_1802.field_20391), 1L), s -> true, class_2350.field_11043);
        op.iterate(null);
    }

    public Operation start(ResourceAmount<ItemVariant> item, Predicate<Storage<ItemVariant>> exclude, class_2350 inFace) {
        ItemPipeVertex startVertex = ItemPipeVertex.find(this.world, this.startPipe);
        return new Operation(item, startVertex, inFace, exclude);
    }

    public Operation run(ResourceAmount<ItemVariant> item, Predicate<Storage<ItemVariant>> exclude, class_2350 inFace, @Nullable TransactionContext transaction) {
        return this.start(item, exclude, inFace).run(transaction);
    }

    public class Operation {
        private final ResourceAmount<ItemVariant> item;
        private final Predicate<Storage<ItemVariant>> exclude;
        private final class_2350 inFace;
        private final ItemPipeVertex startVertex;
        private final Map<ItemPipeVertex, Node> vertexToNode = new HashMap<ItemPipeVertex, Node>();
        private final Set<ItemPipeVertex> visited = new HashSet<ItemPipeVertex>();
        private final PriorityQueue<Node> frontier = new ObjectHeapPriorityQueue();
        private long maxAmount = 0L;
        private final List<ItemRoute> routes = new ObjectArrayList();
        private PipePathfinding.OperationState state = PipePathfinding.OperationState.UNFINISHED;

        public Operation(ResourceAmount<ItemVariant> item, ItemPipeVertex startVertex, class_2350 inFace, Predicate<Storage<ItemVariant>> exclude) {
            this.item = item;
            this.startVertex = startVertex;
            this.exclude = exclude;
            this.inFace = inFace;
            Node startNode = this.vertexToNode.computeIfAbsent(startVertex, Node::new);
            startNode.inFace = inFace;
            this.frontier.enqueue((Object)startNode);
            this.visited.add(startVertex);
        }

        public Operation run(TransactionContext transaction) {
            while (this.state == PipePathfinding.OperationState.UNFINISHED) {
                this.iterate(transaction);
            }
            return this;
        }

        public void iterate(TransactionContext transaction) {
            if (!this.frontier.isEmpty()) {
                if (this.processVertex(this.item, this.startVertex, this.inFace, transaction)) {
                    this.state = PipePathfinding.OperationState.SUCCESS;
                }
            } else {
                this.state = PipePathfinding.OperationState.FAIL;
            }
        }

        private boolean processVertex(ResourceAmount<ItemVariant> item, ItemPipeVertex startVertex, class_2350 inFace, TransactionContext transaction) {
            Node node = (Node)this.frontier.dequeue();
            boolean foundRoute = false;
            for (int dir : node.vertex.getSortedIndices()) {
                class_2350 face = class_2350.values()[dir];
                if (node.vertex == startVertex && face == inFace || !node.vertex.canItemLeave(item, face, true)) continue;
                ItemPipeVertex adj = node.vertex.getAdjVertex(dir);
                if (adj != null) {
                    Node child = this.vertexToNode.computeIfAbsent(adj, Node::new);
                    if (this.visited.contains(adj)) continue;
                    this.visited.add(adj);
                    class_2350 enterDirection = adj.getDirection(node.vertex);
                    if (!adj.canItemEnter((ItemVariant)item.resource(), item.amount(), enterDirection, false)) continue;
                    child.cost = node.cost;
                    if (child.vertex.prioritise()) {
                        --child.cost;
                    }
                    child.parent = node;
                    child.parentOutFace = face;
                    this.frontier.enqueue((Object)child);
                    continue;
                }
                Storage<ItemVariant> storage = node.vertex.getStorage(face);
                if (this.exclude.test(storage) && storage != null) {
                    long transferable = MeatlibStorageUtil.simulateInsert(storage, (ItemVariant)item.resource(), Long.MAX_VALUE, transaction);
                    if (transferable <= 0L) continue;
                    this.maxAmount = transferable;
                    foundRoute = true;
                    continue;
                }
                class_2338 nodePos = node.vertex.getPos();
                class_2338 offsetPos = nodePos.method_10093(face);
                class_2680 offsetState = PipeRouteFinder.this.world.method_8320(offsetPos);
                if (!node.vertex.isConnected(face) || !ItemPipeUtil.canDumpInto((class_1937)PipeRouteFinder.this.world, offsetPos, offsetState)) continue;
                this.maxAmount = item.amount();
                foundRoute = true;
            }
            return foundRoute;
        }

        public List<ItemRoute> routes() {
            return this.routes;
        }

        public ItemRoute firstRoute() {
            return this.routes.isEmpty() ? ItemRoute.EMPTY : this.routes.get(0);
        }

        public long maxAmount() {
            return this.maxAmount;
        }
    }

    public static class Node
    implements Comparable<Node> {
        public final ItemPipeVertex vertex;
        public int cost;
        public Node parent;
        public class_2350 parentOutFace;
        public class_2350 inFace;

        public Node(ItemPipeVertex vertex) {
            this.vertex = vertex;
        }

        @Override
        public int compareTo(@NotNull Node other) {
            return Integer.compare(this.cost, other.cost);
        }
    }
}

