/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.fluid_network.node;

import com.neep.meatlib.util.NbtSerialisable;
import com.neep.neepmeat.transport.api.FluidTransportConstants;
import com.neep.neepmeat.transport.api.pipe.FluidPipe;
import com.neep.neepmeat.transport.block.fluid_transport.machine.FluidPipeBlockEntity;
import com.neep.neepmeat.transport.fluid_network.FluidPipeVertex;
import com.neep.neepmeat.transport.fluid_network.PipeFlowComponent;
import com.neep.neepmeat.transport.fluid_network.SimpleFluidPipeVertex;
import com.neep.neepmeat.transport.fluid_network.node.FluidNode;
import com.neep.neepmeat.transport.fluid_network.node.NodePos;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.Random;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public class BlockFluidPipeVertex
extends SimpleFluidPipeVertex
implements NbtSerialisable {
    protected final FluidPipeBlockEntity<?> parent;
    protected final FluidNode[] nodes = new FluidNode[6];
    private final ObjectArrayList<PipeFlowComponent> components = new ObjectArrayList(6);
    protected boolean dirty;
    protected Random jrandom = new Random();
    protected Long[] queuedPositions = null;
    protected boolean[] queuedNodes = null;
    protected Boolean canSimplify = null;

    public BlockFluidPipeVertex(FluidPipeBlockEntity<?> fluidPipeBlockEntity) {
        super(fluidPipeBlockEntity.method_11016().method_10063());
        this.parent = fluidPipeBlockEntity;
        this.setHeight(fluidPipeBlockEntity.method_11016().method_10264());
        this.components.size(6);
    }

    public void invalidateCanSimplify() {
        this.canSimplify = null;
    }

    public boolean canSimplify(FluidPipe pipe, class_2680 state) {
        return super.canSimplify() && this.numNodes() == 0 && pipe.countConnections(state) <= 2;
    }

    @Override
    public boolean canSimplify() {
        if (this.canSimplify == null) {
            this.canSimplify = this.canSimplify((FluidPipe)this.parent.method_11010().method_26204(), this.parent.method_11010());
        }
        return this.canSimplify;
    }

    @Override
    public void tickDeferredLoad() {
        this.deferredLoad();
    }

    @Override
    public void setAdjVertex(int dir, FluidPipeVertex vertex) {
        super.setAdjVertex(dir, vertex);
        this.parent.method_5431();
        this.invalidateCanSimplify();
    }

    public int numNodes() {
        int number = 0;
        for (FluidNode node : this.nodes) {
            if (node == null) continue;
            ++number;
        }
        return number;
    }

    @Override
    public void updateNodes(class_3218 world, class_2338 pos, class_2680 state) {
        Arrays.fill(this.nodes, null);
        FluidPipe pipe = FluidPipe.findFluidPipe((class_1937)world, pos, state);
        if (pipe != null) {
            for (class_2350 direction : pipe.getConnections(state).directions()) {
                FluidNode node = this.parent.getNode(direction);
                if (node == null) continue;
                this.nodes[direction.ordinal()] = node;
            }
        }
        this.invalidateCanSimplify();
        this.parent.method_5431();
    }

    protected float nodeHeight(int dir) {
        if (!FluidTransportConstants.INSTANCE.nodeGravityEnabled()) {
            return 0.0f;
        }
        return switch (dir) {
            case 0 -> -0.5f;
            case 1 -> 0.5f;
            default -> 0.0f;
        };
    }

    @Override
    public void reset() {
        this.pumpHeight = 0.0f;
        this.height = this.parent.method_11016().method_10264();
        this.clearEdges();
    }

    @Override
    public void preTick() {
        this.stepHeight();
        try (Transaction transaction = Transaction.openOuter();){
            for (FluidNode node : this.nodes) {
                long permittedAmount;
                long extracted;
                FluidVariant foundVariant;
                if (node == null) continue;
                Storage<FluidVariant> storage = node.getStorage((class_3218)this.parent.method_10997());
                float f = this.getNodeFlow(node.getNodePos(), node);
                long transferAmount = -((long)Math.ceil(f * (float)this.getCapacity()));
                if (transferAmount <= 0L || (foundVariant = (FluidVariant)StorageUtil.findExtractableResource(storage, (TransactionContext)transaction)) == null || !this.variant.isBlank() && !foundVariant.equals(this.variant) || (extracted = storage.extract((Object)foundVariant, permittedAmount = this.canInsert((class_3218)this.parent.method_10997(), node.getNodePos().face().method_10153().ordinal(), foundVariant, transferAmount), (TransactionContext)transaction)) <= 0L) continue;
                this.variant = foundVariant;
                this.amount += extracted;
                this.dirty = true;
            }
            transaction.commit();
            if (this.dirty) {
                this.parent.method_5431();
                this.dirty = false;
            }
        }
        super.preTick();
    }

    @Override
    public void tick() {
        if (this.amount <= 0L) {
            return;
        }
        try (Transaction transaction = Transaction.openOuter();){
            int[] ints;
            int dir;
            this.components.clear();
            this.components.size(6);
            int transfers = 0;
            for (dir = 0; dir < this.nodes.length; ++dir) {
                FluidNode node = this.nodes[dir];
                if (node == null || !(this.getNodeFlow(node.getNodePos(), node) >= 0.0f) || !node.getMode().canInsert()) continue;
                this.components.set(dir, (Object)node);
                ++transfers;
            }
            for (dir = 0; dir < this.getAdjVertices().length; ++dir) {
                FluidPipeVertex vertex = this.getAdjacent(dir);
                if (vertex == null || !(vertex.getTotalHeight() - this.getTotalHeight() <= 0.0f) || ((SimpleFluidPipeVertex)vertex).canInsert((class_3218)this.parent.method_10997(), dir, this.variant, this.amount) <= 0L) continue;
                this.components.set(dir, (Object)vertex);
                ++transfers;
            }
            for (int dir2 : ints = this.jrandom.ints(0, 6).distinct().limit(6L).toArray()) {
                PipeFlowComponent component = (PipeFlowComponent)this.components.get(dir2);
                if (component == null) continue;
                long amount1 = this.canOutput((class_3218)this.parent.method_10997(), dir2, this.variant, this.amount);
                long transferAmount = (long)Math.min((double)amount1, Math.ceil((float)this.amount / (float)transfers));
                long received = component.insert(dir2, 0, transferAmount, (class_3218)this.parent.method_10997(), this.variant, (TransactionContext)transaction);
                if (received > 0L) {
                    this.amount -= received;
                    if (this.amount <= 0L) {
                        this.variant = FluidVariant.blank();
                    }
                    this.dirty = true;
                }
                --transfers;
            }
            transaction.commit();
            if (this.dirty) {
                this.parent.method_5431();
                this.dirty = false;
            }
        }
    }

    protected float getNodeFlow(NodePos pos, FluidNode node) {
        float nodeFlow = node.getFlow();
        float heightFlow = -this.nodeHeight(pos.face().ordinal()) - (node.getPumpHeight() - this.pumpHeight);
        return nodeFlow != 0.0f ? nodeFlow : heightFlow;
    }

    protected void stepHeight() {
        float f;
        float total = 0.0f;
        int found = 1;
        total += this.getPumpHeight();
        for (int dir = 0; dir < 6; ++dir) {
            FluidPipeVertex vertex = this.getAdjacent(dir);
            FluidNode node = this.nodes[dir];
            if (vertex != null) {
                total += vertex.getPumpHeight();
                ++found;
                continue;
            }
            if (node == null) continue;
            total += node.getPumpHeight();
            ++found;
        }
        this.pumpHeight = found == 1 ? 0.0f : ((double)Math.abs(f = total / (float)found) <= 0.01 ? 0.0f : f);
        for (FluidNode node : this.nodes) {
            if (node == null) continue;
            node.setPumpHeight(this.pumpHeight / 2.0f);
        }
    }

    protected long canOutput(class_3218 world, int outDir, FluidVariant variant, long maxAmount) {
        return maxAmount;
    }

    @Override
    public float getPumpHeight() {
        return this.pumpHeight;
    }

    @Override
    public String toString() {
        StringBuilder adj = new StringBuilder();
        for (FluidPipeVertex v : this.getAdjVertices()) {
            if (v == null) continue;
            adj.append(System.identityHashCode(v)).append(", ");
        }
        return "Vertex@" + System.identityHashCode(this) + "{connection=" + String.valueOf(adj) + "nodes: " + Arrays.toString(this.nodes) + ", head:" + this.getTotalHeight() + "}";
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        nbt.method_10544("amount", this.amount);
        nbt.method_10566("variant", (class_2520)this.variant.toNbt());
        class_2499 adjacent = new class_2499();
        for (int dir = 0; dir < 6; ++dir) {
            class_2487 adjNbt = new class_2487();
            adjacent.add((Object)adjNbt);
            FluidPipeVertex adj = this.getAdjVertex(dir);
            if (adj != null) {
                adjNbt.method_10544("pos", adj.getPos());
            }
            if (this.nodes[dir] != null) {
                adjNbt.method_10556("node", true);
            }
            if (this.queuedPositions == null || this.queuedNodes == null) continue;
            if (this.queuedPositions[dir] != null) {
                adjNbt.method_10544("pos", this.queuedPositions[dir].longValue());
            }
            if (!this.queuedNodes[dir]) continue;
            adjNbt.method_10556("node", this.queuedNodes[dir]);
        }
        nbt.method_10566("adjacent", (class_2520)adjacent);
        return nbt;
    }

    @Override
    public void readNbt(class_2487 nbt) {
        this.amount = nbt.method_10537("amount");
        this.variant = FluidVariant.fromNbt((class_2487)nbt.method_10562("variant"));
        class_2499 adjacent = nbt.method_10554("adjacent", 10);
        this.queuedPositions = new Long[6];
        this.queuedNodes = new boolean[6];
        for (int dir = 0; dir < 6; ++dir) {
            class_2487 adjNbt = adjacent.method_10602(dir);
            if (adjNbt.method_10545("pos")) {
                this.queuedPositions[dir] = adjNbt.method_10537("pos");
            }
            this.queuedNodes[dir] = adjNbt.method_10545("node");
        }
    }

    @Override
    public void erase() {
        for (int dir = 0; dir < 6; ++dir) {
            FluidPipeVertex adj = this.getAdjVertex(dir);
            if (adj == null) continue;
            for (int outDir = 0; outDir < 6; ++outDir) {
                if (adj.getAdjVertex(outDir) != this) continue;
                adj.setAdjVertex(outDir, null);
            }
        }
    }

    protected void deferredLoad() {
        int dir;
        if (this.queuedPositions != null) {
            for (dir = 0; dir < 6; ++dir) {
                Long adjPos = this.queuedPositions[dir];
                if (adjPos == null) continue;
                this.setAdjVertex(dir, (FluidPipeVertex)FluidPipeVertex.LOOKUP.find(this.parent.method_10997(), class_2338.method_10092((long)adjPos), null));
            }
            this.queuedPositions = null;
        }
        if (this.queuedNodes != null) {
            for (dir = 0; dir < 6; ++dir) {
                FluidNode node;
                if (!this.queuedNodes[dir] || (node = this.parent.getNode(class_2350.values()[dir])) == null) continue;
                this.nodes[dir] = node;
            }
            this.queuedNodes = null;
            this.invalidateCanSimplify();
        }
    }
}

