/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.client.screen.widget;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.neep.meatlib.client.screen.GUIUtil;
import com.neep.meatlib.client.screen.auto.Panel;
import com.neep.meatlib.client.screen.auto.ScreenInitialisable;
import com.neep.meatlib.client.screen.auto.ScrollVStackPanel;
import com.neep.meatlib.client.screen.primitive.Rectangle;
import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.api.plc.PLCCols;
import com.neep.neepmeat.client.screen.plc.PLCScreenButton;
import com.neep.neepmeat.transport.api.item_network.RoutingNetwork;
import com.neep.neepmeat.transport.screen.widget.RequestListWidgetHandler;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;

public class RequestListWidget
extends ScrollVStackPanel {
    @NotNull
    private final RequestListWidgetHandler handler;
    private final Multimap<class_2338, RoutingNetwork.DeferredRequest> posToRequest = Multimaps.newListMultimap(new HashMap(), ObjectArrayList::new);
    private final class_327 textRenderer;

    public RequestListWidget(RequestListWidgetHandler handler) {
        super(0, 2, false, false);
        this.textRenderer = class_310.method_1551().field_1772;
        this.handler = handler;
        handler.syncEntriesS2C.receiver(this::receiveEntries);
    }

    private void receiveEntries(List<RoutingNetwork.DeferredRequest> deferredRequests) {
        this.clearChildren();
        this.posToRequest.clear();
        for (RoutingNetwork.DeferredRequest request : deferredRequests) {
            class_2338 requesterPos = request.requesterPos.method_10093(request.requesterFace);
            this.posToRequest.put((Object)requesterPos, (Object)request);
        }
        Iterator<Object> iterator = this.posToRequest.asMap().entrySet().iterator();
        while (iterator.hasNext()) {
            class_638 world = class_310.method_1551().field_1687;
            Map.Entry entry = (Map.Entry)iterator.next();
            class_2680 requestState = world.method_8320((class_2338)entry.getKey());
            if (requestState.method_26215()) {
                requestState = world.method_8320(((RoutingNetwork.DeferredRequest)((Collection)entry.getValue()).iterator().next()).requesterPos);
            }
            EntryWidget widget = new EntryWidget((class_2338)entry.getKey(), (Collection)entry.getValue(), requestState);
            this.addChild(widget);
        }
        this.init();
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
    }

    private class EntryWidget
    extends Panel
    implements Rectangle.Mutable,
    ScreenInitialisable {
        private final class_2338 requestPos;
        private final Collection<RoutingNetwork.DeferredRequest> requests;
        private final DeleteButton deleteButton;
        private final class_1792 requestIcon;

        public EntryWidget(class_2338 requestPos, Collection<RoutingNetwork.DeferredRequest> requests, class_2680 iconState) {
            this.requestPos = requestPos;
            this.requests = requests;
            this.deleteButton = new DeleteButton(0, 0, (class_2561)class_2561.method_43473());
            this.requestIcon = iconState.method_26204().method_8389();
        }

        @Override
        public void init() {
            int rows = (int)Math.ceil((double)(this.requests.size() * 20) / (double)this.itemsW());
            this.h = 20 + rows * 20;
            this.deleteButton.setPos(this.x2() - 18, this.y2() - 18);
        }

        private int itemsW() {
            return this.w() - 20;
        }

        @Override
        protected List<class_4068> drawables() {
            return List.of(this.deleteButton);
        }

        @Override
        public List<class_364> method_25396() {
            return List.of(this.deleteButton);
        }

        @Override
        public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
            super.method_25394(context, mouseX, mouseY, delta);
            GUIUtil.renderBorder(context, this.x(), this.y(), this.w(), this.h(), PLCCols.BORDER.col, 0);
            context.method_51427(this.requestIcon.method_7854(), this.x2() - 18, this.y() + 3);
            GUIUtil.renderBorderInner(context, this.x2() - 19, this.y() + 2, 18, 18, PLCCols.BORDER.col, 0);
            GUIUtil.drawText(context, RequestListWidget.this.textRenderer, (class_2561)NeepMeat.translationKey("screen", "item_requester.from", this.requestPos.method_10263(), this.requestPos.method_10264(), this.requestPos.method_10260()), (float)(this.x() + 2), (float)(this.y() + 2), PLCCols.TEXT.col, false);
            int cols = Math.floorDiv(this.itemsW(), 20);
            int iy = this.y() + 2 + 20;
            int ix = this.x() + 2;
            int i = 0;
            for (RoutingNetwork.DeferredRequest request : this.requests) {
                class_1799 stack = request.getItemVariant().toStack((int)request.getRequested());
                context.method_51427(stack, ix, iy);
                context.method_51431(RequestListWidget.this.textRenderer, stack, ix, iy);
                ix += 20;
                if (++i % cols != 0) continue;
                ix = this.x() + 2;
                iy += 20;
            }
        }

        private class DeleteButton
        extends PLCScreenButton {
            public DeleteButton(int x, int y, class_2561 message) {
                super(x, y, message);
                this.tooltip((class_2561)NeepMeat.translationKey("screen", "item_requester.cancel"));
            }

            @Override
            public void onClick(double mouseX, double mouseY) {
                super.onClick(mouseX, mouseY);
                RequestListWidget.this.handler.removeEntriesFromC2S.emitter().accept(EntryWidget.this.requests.stream().map(r -> r.requesterPos).toList());
            }

            @Override
            protected int getU() {
                return 112;
            }

            @Override
            protected int getV() {
                return 48;
            }
        }
    }
}

