/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.client.screen.filter;

import com.neep.meatlib.client.screen.GUIUtil;
import com.neep.meatlib.client.screen.primitive.Point;
import com.neep.meatlib.client.screen.primitive.Rectangle;
import com.neep.meatlib.client.screen.widget.AbstractClickableWidget;
import com.neep.meatlib.client.screen.widget.CheckboxWidget;
import com.neep.meatlib.client.screen.widget.ClickableWidget;
import com.neep.neepmeat.api.plc.PLCCols;
import com.neep.neepmeat.client.screen.ScreenSubElement;
import com.neep.neepmeat.item.filter.Filter;
import com.neep.neepmeat.item.filter.FilterList;
import com.neep.neepmeat.transport.screen.FilterWidgetHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_5348;

public abstract class FilterEntryWidget<T extends Filter>
extends ScreenSubElement
implements Point.Mutable,
Rectangle {
    protected final List<ClickableWidget> positionables = new ArrayList<ClickableWidget>();
    protected boolean focused;
    private final class_2561 name;
    protected FilterList.Entry entry;
    protected T filter;
    protected final int index;
    protected final FilterWidgetHandler handler;
    protected int h;
    protected final int w;

    public FilterEntryWidget(int w, int h, int index, class_2561 name, FilterList.Entry entry, T filter, FilterWidgetHandler handler) {
        this.w = w;
        this.h = h;
        this.index = index;
        this.name = name;
        this.entry = entry;
        this.filter = filter;
        this.handler = handler;
    }

    @Override
    protected void clearChildren() {
        super.clearChildren();
        this.positionables.clear();
    }

    @Override
    public void init() {
        this.addDrawableChild(new InvertButtonWidget(this.x2() - 18 - 2, this.y() + 3, 11, 11, () -> this.entry.getInverted(), class_2561.method_30163((String)"Invert"), (button, toggled) -> this.handler.setInverted(this.index, toggled)));
        this.addDrawableChild(new RemoveWidget()).setPos(this.x2() - 8, this.y() + 4);
    }

    @Override
    public void setPos(int x, int y) {
        int dx = x - this.x;
        int dy = y - this.y;
        this.x = x;
        this.y = y;
        this.positionables.forEach(c -> c.setPos(c.x() + dx, c.y() + dy));
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.method_25405(mouseX, mouseY)) {
            boolean sub = super.method_25402(mouseX, mouseY, button);
            class_364 focus = this.method_25399();
            return true;
        }
        return false;
    }

    @Override
    public boolean method_25405(double mouseX, double mouseY) {
        return this.isWithin(mouseX, mouseY) || super.method_25405(mouseX, mouseY);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public <V extends class_4068 & class_364> V addDrawableChild(V t) {
        super.addDrawableChild(t);
        if (t instanceof ClickableWidget) {
            ClickableWidget clickableWidget = (ClickableWidget)t;
            this.positionables.add(clickableWidget);
        }
        return t;
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        int col = this.method_25370() ? PLCCols.SELECTED.col : PLCCols.BORDER.col;
        GUIUtil.renderBorderInner(context, this.x, this.y, this.w, this.h, col, 0);
        GUIUtil.drawText(context, this.textRenderer, this.name, (float)(this.x() + 3), (float)(this.y() + 3), PLCCols.TEXT.col, false);
        super.method_25394(context, mouseX, mouseY, delta);
    }

    protected void updateToServer() {
        this.handler.updateToServer.emitter().apply(this.index, this.filter.writeNbt(new class_2487()));
    }

    @Override
    public int h() {
        return this.h;
    }

    @Override
    public int x() {
        return this.x;
    }

    @Override
    public int y() {
        return this.y;
    }

    @Override
    public int w() {
        return this.w;
    }

    public void updateFilter(FilterList.Entry entry) {
        this.entry = entry;
        this.filter = entry.getFilter();
    }

    protected T getFilter() {
        return this.filter;
    }

    public void method_25365(boolean focused) {
        this.focused = focused;
        super.method_25365(focused);
        if (!focused) {
            this.method_25395(null);
        }
    }

    public boolean method_25370() {
        return this.focused || super.method_25370();
    }

    public static class InvertButtonWidget
    extends CheckboxWidget {
        public InvertButtonWidget(int x, int y, int w, int h, BooleanSupplier toggled, class_2561 message, CheckboxWidget.ToggleAction onToggle) {
            super(x, y, w, h, toggled, message, onToggle);
        }

        @Override
        protected void renderButton(class_332 context, int mouseX, int mouseY, float delta) {
            String box = this.isToggled() ? "\u2612" : "\u2610";
            int borderCol = this.borderActive(mouseX, mouseY) ? PLCCols.SELECTED.col : PLCCols.BORDER.col;
            int boxWidth = this.textRenderer.method_1727(box);
            Objects.requireNonNull(this.textRenderer);
            int boxHeight = 9;
            class_2561 label = this.getMessage();
            int labelWidth = this.textRenderer.method_27525((class_5348)label);
            int textX = this.x() + (this.h() - boxWidth) / 2;
            int textY = this.y() + (this.h() - boxHeight) / 2;
            GUIUtil.drawText(context, this.textRenderer, class_2561.method_30163((String)box), (float)textX, (float)textY, borderCol, false);
            GUIUtil.drawText(context, this.textRenderer, label, (float)(textX - labelWidth - 3), (float)textY, PLCCols.TEXT.col, false);
        }
    }

    public class RemoveWidget
    extends AbstractClickableWidget {
        public RemoveWidget() {
            this.width = FilterEntryWidget.this.textRenderer.method_1727("\u00d7");
            Objects.requireNonNull(FilterEntryWidget.this.textRenderer);
            this.height = 9;
        }

        @Override
        public void onClick(double mouseX, double mouseY) {
            super.onClick(mouseX, mouseY);
            FilterEntryWidget.this.handler.removeFilter.emitter().apply(FilterEntryWidget.this.index);
        }

        @Override
        protected void renderButton(class_332 context, int mouseX, int mouseY, float delta) {
            int borderCol = this.isWithin(mouseX, mouseY) ? PLCCols.SELECTED.col : PLCCols.BORDER.col;
            GUIUtil.drawText(context, FilterEntryWidget.this.textRenderer, "\u00d7", (float)this.x(), (float)this.y(), borderCol, false);
        }
    }
}

