/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.block.item_transport.entity;

import com.google.common.collect.Streams;
import com.neep.neepmeat.transport.ItemTransport;
import com.neep.neepmeat.transport.api.item_network.PriorityPipe;
import com.neep.neepmeat.transport.api.item_network.RoutablePipe;
import com.neep.neepmeat.transport.api.item_network.RoutingNetwork;
import com.neep.neepmeat.transport.api.item_network.StorageDriver;
import com.neep.neepmeat.transport.block.item_transport.RoutingNetworkImpl;
import com.neep.neepmeat.transport.block.item_transport.entity.ItemPipeBlockEntity;
import com.neep.neepmeat.transport.fluid_network.node.NodePos;
import com.neep.neepmeat.transport.interfaces.IServerWorld;
import com.neep.neepmeat.transport.item_network.ItemRoute;
import com.neep.neepmeat.transport.item_network.PipeCacheImpl;
import com.neep.neepmeat.transport.item_network.RetrievalTarget;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public class StorageDriverBlockEntity
extends ItemPipeBlockEntity
implements StorageDriver,
PriorityPipe {
    protected final List<RetrievalTarget<ItemVariant>> targets = new ArrayList<RetrievalTarget<ItemVariant>>(6);
    protected boolean needsUpdate = true;
    private int outPriority;

    public StorageDriverBlockEntity(class_2338 pos, class_2680 state) {
        this(ItemTransport.STORAGE_BUS_BE, pos, state);
    }

    public StorageDriverBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    protected void updateTargets() {
        this.targets.clear();
        class_2338.class_2339 mutable = this.method_11016().method_25503();
        for (class_2350 direction : class_2350.values()) {
            mutable.method_25505((class_2382)this.method_11016(), direction);
            BlockApiCache storageCache = BlockApiCache.create((BlockApiLookup)ItemStorage.SIDED, (class_3218)((class_3218)this.field_11863), (class_2338)mutable);
            if (storageCache.find((Object)direction.method_10153()) == null) continue;
            this.targets.add(RetrievalTarget.of(storageCache, direction.method_10153()));
        }
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10569("out_priority", this.outPriority);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.outPriority = nbt.method_10550("out_priority");
    }

    @Override
    public void update(class_3218 world, class_2338 pos) {
        this.updateTargets();
    }

    @Override
    public List<RetrievalTarget<ItemVariant>> getTargets() {
        if (this.needsUpdate) {
            this.updateTargets();
            this.needsUpdate = false;
        }
        return this.targets;
    }

    @Override
    public RoutablePipe.Result request(Predicate<ItemVariant> predicate, long amount, NodePos fromPos, RoutingNetwork.RequestContext context, TransactionContext transaction) {
        PipeCacheImpl itemNetwork = ((IServerWorld)this.field_11863).getItemNetwork();
        AtomicLong routed = new AtomicLong();
        long remaining = amount;
        for (RetrievalTarget<ItemVariant> target : this.getTargets()) {
            Storage<ItemVariant> storage = target.find();
            if (storage == null) continue;
            ItemVariant extractable = null;
            for (StorageView view : storage) {
                ItemVariant resource = (ItemVariant)view.getResource();
                if (view.getAmount() <= 0L || view.isResourceBlank() || !predicate.test(resource)) continue;
                extractable = resource;
            }
            if (extractable == null) continue;
            long extracted = storage.extract(extractable, amount, transaction);
            remaining -= extracted;
            if (extracted > 0L) {
                ItemRoute route = itemNetwork.findPath((ResourceAmount<ItemVariant>)new ResourceAmount((Object)extractable, amount), this.field_11867, fromPos.pos(), fromPos.face());
                long l = itemNetwork.route(target.getPos(), target.accessFace(), route, extractable, extracted, transaction);
                routed.addAndGet(l);
            }
            if (remaining > 0L) continue;
            break;
        }
        return RoutablePipe.Result.immediate(routed.get());
    }

    @Override
    public Stream<StorageView<ItemVariant>> getAvailable(TransactionContext transaction) {
        return this.getTargets().stream().map(RetrievalTarget::find).filter(Objects::nonNull).flatMap(Streams::stream);
    }

    @Override
    public long store(ItemVariant variant, long maxAmount, RoutingNetworkImpl.StoreRouter router, TransactionContext transaction) {
        long amountRemaining = maxAmount;
        for (RetrievalTarget<ItemVariant> target : this.getTargets()) {
            long insertable;
            Storage<ItemVariant> storage = target.find();
            if (storage == null) continue;
            try (Transaction inner = transaction.openNested();){
                insertable = storage.insert((Object)variant, amountRemaining, (TransactionContext)inner);
                inner.abort();
            }
            if (insertable > 0L) {
                ItemRoute route = router.findPathTo(this.field_11867, target.accessFace().method_10153(), insertable);
                long routable = router.addOperation(route, variant, insertable);
                amountRemaining -= routable;
            }
            if (amountRemaining > 0L) continue;
            return maxAmount;
        }
        return maxAmount - amountRemaining;
    }

    @Override
    public class_2338 getRoutablePipePos() {
        return this.field_11867;
    }

    @Override
    public void setOutputPriority(int priority) {
        this.outPriority = priority;
        this.cache.update();
        this.method_5431();
    }

    @Override
    public int getOutputPriority() {
        return this.outPriority;
    }

    @Override
    public int priority() {
        return this.outPriority;
    }
}

