/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.block.item_transport.entity;

import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.meatlib.util.graph.ConnectablePipe;
import com.neep.neepbus.block.entity.ConfigProvider;
import com.neep.neepbus.util.NeepBusConfig;
import com.neep.neepbus.util.SimpleEntry;
import com.neep.neepbus.util.message.DataVariant;
import com.neep.neepmeat.item.filter.FilterList;
import com.neep.neepmeat.transport.api.item_network.RoutingNetwork;
import com.neep.neepmeat.transport.api.pipe.ItemPipe;
import com.neep.neepmeat.transport.block.item_transport.RequesterBlock;
import com.neep.neepmeat.transport.block.item_transport.entity.NetworkTrackingItemPipe;
import com.neep.neepmeat.transport.item_network.ItemPipeVertex;
import com.neep.neepmeat.transport.item_network.ItemPipeVertexImpl;
import com.neep.neepmeat.transport.item_network.RoutingNetworkCache;
import it.unimi.dsi.fastutil.Pair;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.jetbrains.annotations.Nullable;

public class RequesterBlockEntity
extends SyncableBlockEntity
implements ConfigProvider,
NetworkTrackingItemPipe {
    private final NeepBusConfig config = NeepBusConfig.builder(this::method_5431).input(new SimpleEntry("Request"), this::receive).applyChanges(this).build();
    private final Vertex vertex = new Vertex(this);
    private int amount = 1;
    private RoutingNetwork.RequestType requestType = RoutingNetwork.RequestType.EXACT_AMOUNT;
    private final FilterList filterList = new FilterList(1, this::method_5431);
    private final RoutingNetworkCache networkCache = new RoutingNetworkCache();
    public boolean prevHigh;

    public RequesterBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    private void receive(DataVariant dataVariant) {
        int requested = (int)dataVariant.floatValue();
        this.request(requested);
    }

    public void request() {
        this.request(this.amount);
    }

    public void request(int requested) {
        RoutingNetwork network = this.networkCache.getNetwork();
        if (network != null) {
            try (Transaction transaction = Transaction.openOuter();){
                if (network.request(this.filterList::matches, requested, this.field_11867, (class_2350)this.method_11010().method_11654((class_2769)RequesterBlock.field_10927), RoutingNetwork.RequestType.EXACT_AMOUNT, new RoutingNetwork.RequestContext(), (TransactionContext)transaction)) {
                    transaction.commit();
                }
            }
        }
    }

    @Nullable
    private Pair<class_2338, class_2350> findRequestPos(class_2350 exclude) {
        class_2338.class_2339 mutable = this.field_11867.method_25503();
        for (class_2350 face : class_2350.class_2353.field_11062) {
            if (face == exclude) continue;
            mutable.method_25505((class_2382)this.field_11867, face);
            ConnectablePipe pipe = ItemPipe.findItemPipe(this.field_11863, (class_2338)mutable, this.field_11863.method_8320((class_2338)mutable));
            if (pipe == null) continue;
            return Pair.of((Object)mutable, (Object)face.method_10153());
        }
        return null;
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10566("filter", (class_2520)this.filterList.writeNbt(new class_2487()));
        nbt.method_10566("config", (class_2520)this.config.writeNbt(new class_2487()));
        nbt.method_10566("vertex", (class_2520)this.vertex.writeNbt(new class_2487()));
        nbt.method_10569("amount", this.amount);
        nbt.method_10556("prev_high", this.prevHigh);
        nbt.method_10569("request_type", this.requestType.ordinal());
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.filterList.readNbt(nbt.method_10562("filter"));
        this.config.readNbt(nbt.method_10562("config"));
        this.vertex.readNbt(nbt.method_10562("vertex"));
        this.amount = nbt.method_10550("amount");
        this.prevHigh = nbt.method_10577("prev_high");
        this.requestType = RoutingNetwork.RequestType.values()[nbt.method_10550("request_type")];
    }

    @Override
    public NeepBusConfig getConfig() {
        return this.config;
    }

    public FilterList getFilter() {
        return this.filterList;
    }

    public boolean matches(ItemVariant variant, long amount) {
        return this.filterList.matches(variant);
    }

    public ItemPipeVertex getVertex() {
        return this.vertex;
    }

    @Override
    public RoutingNetworkCache getCache() {
        return this.networkCache;
    }

    public void setPrevHigh(boolean high) {
        this.prevHigh = high;
        this.method_5431();
    }

    public int getAmount() {
        return this.amount;
    }

    public RoutingNetwork.RequestType getRequestType() {
        return this.requestType;
    }

    public void setValues(int amount, RoutingNetwork.RequestType type) {
        this.amount = amount;
        this.requestType = type;
        this.method_5431();
    }

    private class Vertex
    extends ItemPipeVertexImpl {
        public Vertex(class_2586 parent) {
            super(parent);
        }

        @Override
        public boolean canItemEnter(ItemVariant variant, long amount, class_2350 inFace, boolean routed) {
            return super.canItemEnter(variant, amount, inFace, routed);
        }

        @Override
        public boolean canSimplify() {
            return false;
        }
    }
}

