/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.block.item_transport;

import com.neep.neepmeat.init.NMParticles;
import com.neep.neepmeat.transport.ItemTransport;
import com.neep.neepmeat.transport.api.item_network.RoutablePipe;
import com.neep.neepmeat.transport.api.item_network.RoutingNetwork;
import com.neep.neepmeat.transport.api.pipe.ItemPipe;
import com.neep.neepmeat.transport.block.item_transport.entity.NetworkTrackingItemPipe;
import com.neep.neepmeat.transport.fluid_network.node.NodePos;
import com.neep.neepmeat.transport.interfaces.IServerWorld;
import com.neep.neepmeat.transport.item_network.ItemRoute;
import com.neep.neepmeat.transport.item_network.PipeCacheImpl;
import com.neep.neepmeat.util.BFSGroupFinder;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class RoutingNetworkImpl
implements RoutingNetwork {
    protected boolean needsUpdate = true;
    protected final GroupFinder finder = new GroupFinder();
    protected long version;
    protected Supplier<class_3218> worldSupplier;
    protected final class_2338 pos;
    protected final Long2ObjectMap<BlockApiCache<RoutablePipe, class_2350>> routePipeMap = new Long2ObjectOpenHashMap();
    protected final List<RoutablePipe> routePipes = new ObjectArrayList();
    protected boolean valid;
    private final List<RoutingNetwork.DeferredRequest> deferredRequests = new ObjectArrayList();

    public List<RoutingNetwork.DeferredRequest> getActiveRequests() {
        return this.deferredRequests;
    }

    public RoutingNetworkImpl(class_2338 pos, Supplier<class_3218> worldSupplier) {
        this.pos = pos;
        this.worldSupplier = worldSupplier;
    }

    public static <T> ResourceAmount<T> viewToAmount(StorageView<T> view) {
        return new ResourceAmount(view.getResource(), view.getAmount());
    }

    @Override
    public void invalidate() {
        this.needsUpdate = true;
        ++this.version;
    }

    @Override
    public boolean needsUpdate() {
        return this.needsUpdate;
    }

    @Override
    public void update() {
        this.needsUpdate = false;
        this.routePipeMap.clear();
        this.routePipes.clear();
        this.finder.reset();
        this.finder.queueBlock(this.pos);
        this.finder.loop(800);
        if (this.finder.controllers > 1) {
            this.valid = false;
            return;
        }
        this.finder.getResult().forEach((k, v) -> this.routePipeMap.put(k.method_10063(), v));
        this.routePipeMap.values().stream().map(c -> (RoutablePipe)c.find(null)).filter(Objects::nonNull).sorted(RoutingNetworkImpl::compare).forEachOrdered(this.routePipes::add);
        this.finder.getVisited().forEach(p -> {
            class_2586 patt5066$temp = this.worldSupplier.get().method_8321(class_2338.method_10092((long)p));
            if (patt5066$temp instanceof NetworkTrackingItemPipe) {
                NetworkTrackingItemPipe be = (NetworkTrackingItemPipe)patt5066$temp;
                be.getCache().setNetwork(this.worldSupplier.get(), this.pos);
            }
        });
        this.valid = true;
    }

    private static int compare(RoutablePipe p0, RoutablePipe p1) {
        int x = p0.priority();
        int y = p1.priority();
        return Integer.compare(y, x);
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void serverTick() {
        class_1937 world = (class_1937)this.worldSupplier.get();
        if (world.method_8510() % 10L == 0L) {
            try (Transaction transaction = Transaction.openOuter();){
                Iterator<RoutingNetwork.DeferredRequest> it = this.deferredRequests.iterator();
                while (it.hasNext()) {
                    RoutingNetwork.DeferredRequest request = it.next();
                    RoutablePipe.DeferredResult result = request.getPipe((class_1937)this.worldSupplier.get()).deferredUpdate(request, this, (TransactionContext)transaction);
                    if (result != RoutablePipe.DeferredResult.SUCCESS && result != RoutablePipe.DeferredResult.FAIL) continue;
                    it.remove();
                }
                transaction.commit();
            }
        }
    }

    @Override
    public Stream<ResourceAmount<ItemVariant>> getAllAvailable(Predicate<ItemVariant> predicate, TransactionContext transaction) {
        return this.routePipes.stream().flatMap(p -> p.getAvailable(transaction)).filter(v -> predicate.test((ItemVariant)v.getResource())).map(RoutingNetworkImpl::viewToAmount);
    }

    @Override
    public boolean route(Predicate<ItemVariant> predicate, long amount, class_2338 inPos, class_2350 inDir, class_2338 outPos, class_2350 outDir, RoutingNetwork.RequestType type, TransactionContext transaction) {
        amount = Math.max(0L, amount);
        try (Transaction inner = transaction.openNested();){
            RoutablePipe.Result routed;
            RoutablePipe inPipe;
            BlockApiCache inPipeCache = (BlockApiCache)this.routePipeMap.get(inPos.method_10063());
            if (inPipeCache != null && (inPipe = (RoutablePipe)inPipeCache.find(null)) != null && type.satisfied(amount, (routed = inPipe.request(predicate, amount, new NodePos(outPos, outDir), new RoutingNetwork.RequestContext(), (TransactionContext)inner)).total())) {
                this.successAnimation();
                inner.commit();
                boolean bl = true;
                return bl;
            }
            inner.abort();
        }
        return false;
    }

    @Override
    public boolean request(Predicate<ItemVariant> predicate, long amount, class_2338 pos, class_2350 outDir, RoutingNetwork.RequestType type, RoutingNetwork.RequestContext context, TransactionContext transaction) {
        if (context.recursionDepth > 30) {
            this.failAnimation();
            return false;
        }
        if ((amount = Math.max(0L, amount)) == 0L) {
            return true;
        }
        try (Transaction inner = transaction.openNested();){
            AtomicLong amountRemaining = new AtomicLong(amount);
            boolean satisfied = false;
            for (RoutablePipe e : this.routePipes) {
                ++context.recursionDepth;
                RoutablePipe.Result retrieved = e.request(predicate, amountRemaining.get(), new NodePos(pos, outDir), context, (TransactionContext)inner);
                amountRemaining.addAndGet(-retrieved.total());
                if (retrieved.deferredAmount() > 0L) {
                    this.deferredRequests.add(new RoutingNetwork.DeferredRequest(e.getRoutablePipePos(), pos, outDir, retrieved.deferredAmount(), retrieved.deferredResult()));
                }
                --context.recursionDepth;
                if (amountRemaining.get() > 0L) continue;
                satisfied = true;
                break;
            }
            if (type.satisfied(amount, amount - amountRemaining.get())) {
                if (context.recursionDepth == 0) {
                    this.successAnimation();
                }
                inner.commit();
                boolean bl = satisfied;
                return bl;
            }
            this.failAnimation();
            inner.abort();
        }
        return false;
    }

    private void failAnimation() {
        this.worldSupplier.get().method_43128(null, (double)this.pos.method_10263(), (double)this.pos.method_10264(), (double)this.pos.method_10260(), class_3417.field_14710, class_3419.field_15245, 1.0f, 1.0f);
        this.worldSupplier.get().method_14199((class_2394)NMParticles.BLOOD_SHOWER, (double)this.pos.method_10263() + 0.5, (double)(this.pos.method_10264() + 1), (double)this.pos.method_10260() + 0.5, 20, 0.1, 0.5, 0.1, 0.1);
    }

    private void successAnimation() {
        this.worldSupplier.get().method_14199((class_2394)class_2398.field_11251, (double)this.pos.method_10263() + 0.5, (double)(this.pos.method_10264() + 1), (double)this.pos.method_10260() + 0.5, 20, 0.1, 0.0, 0.1, 0.01);
        this.worldSupplier.get().method_43128(null, (double)this.pos.method_10263(), (double)this.pos.method_10264(), (double)this.pos.method_10260(), class_3417.field_22266, class_3419.field_15245, 1.0f, 1.0f);
    }

    @Override
    public long store(final ItemVariant variant, long amount, final class_2338 inPos, final class_2350 inFace, final TransactionContext transaction) {
        RoutablePipe e;
        long insertable;
        final class_2338 inPipe = inPos.method_10093(inFace);
        final PipeCacheImpl itemNetwork = ((IServerWorld)this.worldSupplier.get()).getItemNetwork();
        StoreRouter storeRouter = new StoreRouter(){

            @Override
            public ItemRoute findPathTo(class_2338 toPos, class_2350 outDir, long amount) {
                return itemNetwork.findPath((ResourceAmount<ItemVariant>)new ResourceAmount((Object)variant, amount), inPipe, toPos, outDir);
            }

            @Override
            public long addOperation(ItemRoute route, ItemVariant variant2, long maxAmount) {
                return itemNetwork.route(inPos, inFace, route, variant2, maxAmount, transaction);
            }
        };
        long amountRemaining = amount;
        Iterator<RoutablePipe> iterator = this.routePipes.iterator();
        while (iterator.hasNext() && (amountRemaining -= (insertable = (e = iterator.next()).store(variant, amountRemaining, storeRouter, transaction))) > 0L) {
        }
        if (amount - amountRemaining > 0L) {
            this.successAnimation();
        } else {
            this.failAnimation();
        }
        return amount - amountRemaining;
    }

    public void removeDeferredFrom(List<class_2338> pos) {
        this.deferredRequests.removeIf(r -> pos.contains(r.requesterPos));
    }

    public class_2487 writeNbt(class_2487 nbt) {
        class_2499 list = new class_2499();
        for (RoutingNetwork.DeferredRequest deferredRequest : this.deferredRequests) {
            list.add((Object)deferredRequest.toNbt());
        }
        nbt.method_10566("deferred", (class_2520)list);
        return nbt;
    }

    public void readNbt(class_2487 nbt) {
        class_2499 list = nbt.method_10554("deferred", 10);
        this.deferredRequests.clear();
        for (int i = 0; i < list.size(); ++i) {
            class_2487 nbtCompound = list.method_10602(i);
            this.deferredRequests.add(i, RoutingNetwork.DeferredRequest.fromNbt(nbtCompound));
        }
    }

    protected class GroupFinder
    extends BFSGroupFinder<BlockApiCache<RoutablePipe, class_2350>> {
        protected int controllers = 0;

        protected GroupFinder() {
        }

        @Override
        public void reset() {
            super.reset();
            this.controllers = 0;
        }

        public Set<Long> getVisited() {
            return this.visited;
        }

        @Override
        protected BFSGroupFinder.State processPos(class_2338 pos) {
            ItemPipe fromPipe = (ItemPipe)ItemTransport.ITEM_PIPE_LOOKUP.find((class_1937)RoutingNetworkImpl.this.worldSupplier.get(), pos, null);
            if (this.checkController(RoutingNetworkImpl.this.worldSupplier.get(), pos)) {
                return BFSGroupFinder.State.FAIL;
            }
            class_2338.class_2339 mutable = pos.method_25503();
            for (class_2350 direction : fromPipe.getConnections(RoutingNetworkImpl.this.worldSupplier.get().method_8320(pos), null)) {
                ItemPipe toPipe;
                mutable.method_25505((class_2382)pos, direction);
                RoutablePipe routablePipe = (RoutablePipe)RoutablePipe.LOOKUP.find((class_1937)RoutingNetworkImpl.this.worldSupplier.get(), (class_2338)mutable, null);
                if (routablePipe != null) {
                    this.addResult((class_2338)mutable, BlockApiCache.create(RoutablePipe.LOOKUP, (class_3218)RoutingNetworkImpl.this.worldSupplier.get(), (class_2338)mutable));
                }
                if ((toPipe = (ItemPipe)ItemTransport.ITEM_PIPE_LOOKUP.find((class_1937)RoutingNetworkImpl.this.worldSupplier.get(), (class_2338)mutable, null)) == null) continue;
                this.queueBlock((class_2338)mutable);
            }
            return BFSGroupFinder.State.CONTINUE;
        }

        protected boolean checkController(class_3218 world, class_2338 current) {
            BlockApiCache cache = BlockApiCache.create(RoutingNetwork.LOOKUP, (class_3218)world, (class_2338)current);
            if (cache.find(null) != null) {
                ++this.controllers;
            }
            return false;
        }
    }

    public static interface StoreRouter {
        public ItemRoute findPathTo(class_2338 var1, class_2350 var2, long var3);

        public long addOperation(ItemRoute var1, ItemVariant var2, long var3);
    }
}

