/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.block.item_transport;

import com.neep.meatlib.item.ItemSettings;
import com.neep.meatlib.registry.RegistrationContext;
import com.neep.meatlib.storage.MeatlibStorageUtil;
import com.neep.meatlib.util.graph.PipeGraphUtil;
import com.neep.meatlib.util.graph.PipeVertex;
import com.neep.neepmeat.init.NMBlockEntities;
import com.neep.neepmeat.transport.ItemPipeBlockItem;
import com.neep.neepmeat.transport.api.pipe.ItemPipe;
import com.neep.neepmeat.transport.api.pipe.ItemPipeConnectable;
import com.neep.neepmeat.transport.api.pipe.PipeConnections;
import com.neep.neepmeat.transport.api.pipe.PrecisePipeBlock;
import com.neep.neepmeat.transport.block.item_transport.entity.ItemPipeBlockEntity;
import com.neep.neepmeat.transport.fluid_network.ConnectionType;
import com.neep.neepmeat.transport.item_network.ItemInPipe;
import com.neep.neepmeat.transport.item_network.ItemPipeGraphHelper;
import com.neep.neepmeat.transport.item_network.ItemPipeVertex;
import com.neep.neepmeat.transport.item_network.ItemPipeVertexImpl;
import com.neep.neepmeat.util.MiscUtil;
import java.util.EnumSet;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;

public class ItemPipeBlock
extends PrecisePipeBlock
implements class_2343,
ItemPipe {
    public ItemPipeBlock(RegistrationContext ctx, ItemSettings itemSettings, class_4970.class_2251 settings) {
        super(ctx, itemSettings.factory(ItemPipeBlockItem::new), settings);
    }

    protected static boolean matches(class_1799 stack) {
        class_1747 bi;
        class_1792 class_17922 = stack.method_7909();
        return class_17922 instanceof class_1747 && (bi = (class_1747)class_17922).method_7711() instanceof ItemPipeBlock;
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        ItemPipe.onStateReplaced(world, pos, state, newState);
        if (!state.method_27852(newState.method_26204())) {
            class_2586 class_25862 = world.method_8321(pos);
            if (class_25862 instanceof ItemPipeBlockEntity) {
                ItemPipeBlockEntity be = (ItemPipeBlockEntity)class_25862;
                be.getCallbacks().invalidate();
                be.dropItems();
                be.getCache().update();
            }
            world.method_8544(pos);
        }
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 fromPos, boolean notify) {
        if (world instanceof class_3218) {
            class_2338 subtracted;
            class_2350 direction;
            class_2680 nextState;
            class_3218 serverWorld = (class_3218)world;
            class_2586 class_25862 = world.method_8321(pos);
            if (class_25862 instanceof ItemPipeBlockEntity) {
                ItemPipeBlockEntity be = (ItemPipeBlockEntity)class_25862;
                be.getCache().neighbourUpdate(world, fromPos, sourceBlock);
                be.getCallbacks().invalidate();
            }
            if (!state.equals(nextState = (direction = class_2350.method_50026((int)(subtracted = fromPos.method_10059((class_2382)pos)).method_10263(), (int)subtracted.method_10264(), (int)subtracted.method_10260())) == null ? state : this.method_9559(state, direction, world.method_8320(fromPos), (class_1936)world, pos, fromPos))) {
                ItemPipeGraphHelper.find(serverWorld, pos, state).ifPresent(h -> h.updateConnectionChange(state, nextState));
            }
        }
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            ItemPipeGraphHelper.find(serverWorld, pos, state).ifPresent(h -> h.updateHiddenConnections(state));
        }
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        boolean otherIsPipe;
        boolean otherConnected;
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        boolean alreadyConnected = this.getConnection(state, direction).isConnected();
        boolean canConnect = this.canConnectTo(state, neighborState, direction.method_10153(), (class_1937)world, neighborPos, alreadyConnected);
        class_2248 class_22482 = neighborState.method_26204();
        if (class_22482 instanceof ItemPipeBlock) {
            ItemPipeBlock neighborPipe = (ItemPipeBlock)class_22482;
            otherConnected = neighborPipe.getConnection(neighborState, direction.method_10153()).isConnected();
            otherIsPipe = true;
        } else {
            otherConnected = canConnect && alreadyConnected;
            otherIsPipe = false;
        }
        ConnectionType finalConnection = otherConnected || !otherIsPipe && canConnect ? ConnectionType.SIDE : ConnectionType.NONE;
        return (class_2680)state.method_11657(this.getConnection(direction), (Comparable)((Object)finalConnection));
    }

    @Override
    public boolean canConnectTo(class_2680 hereState, class_2680 toState, class_2350 toFace, class_1937 world, class_2338 toPos, boolean newConnection) {
        class_2248 class_22482 = toState.method_26204();
        if (class_22482 instanceof ItemPipe) {
            ItemPipe otherPipe = (ItemPipe)class_22482;
            return otherPipe.canConnect((class_1922)world, toPos, toState, toFace) && (newConnection || ItemPipe.isConnectedIn(world, toPos, toState, toFace));
        }
        return (newConnection || toState.method_26204() instanceof ItemPipeConnectable) && this.canConnectToApi(world, toPos, toState, hereState, toFace);
    }

    @Override
    protected boolean adjacentAutoConnect(class_1937 world, class_2338 adjPos, class_2680 adjState, class_2680 hereState, class_2350 direction) {
        boolean canConnect = this.canConnectTo(hereState, adjState, direction.method_10153(), world, adjPos, true);
        if (canConnect) {
            class_2248 class_22482 = adjState.method_26204();
            if (class_22482 instanceof ItemPipe) {
                ItemPipe pipe = (ItemPipe)class_22482;
                int adjConnections = pipe.getConnections(adjState, null).size();
                return pipe.alwaysAutoConnect() || adjConnections <= 1;
            }
            if (adjState.method_26204() instanceof ItemPipeConnectable) {
                return true;
            }
        }
        return false;
    }

    protected boolean canConnectToApi(class_1937 world, class_2338 pos, class_2680 state, class_2680 hereState, class_2350 direction) {
        return ItemStorage.SIDED.find(world, pos, (Object)direction) != null;
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (player.method_5998(hand).method_31574(class_1802.field_8600)) {
            if (world instanceof class_3218) {
                ItemPipeBlockEntity be;
                ItemPipeVertex[] itemPipeVertexArray;
                class_3218 serverWorld = (class_3218)world;
                class_2586 class_25862 = world.method_8321(pos);
                if (class_25862 instanceof ItemPipeBlockEntity && (itemPipeVertexArray = (be = (ItemPipeBlockEntity)class_25862).getVertex()) instanceof ItemPipeVertexImpl) {
                    ItemPipeVertexImpl ipv = (ItemPipeVertexImpl)itemPipeVertexArray;
                    if (!ipv.canSimplify()) {
                        player.method_43496(class_2561.method_30163((String)"Vertex"));
                        for (ItemPipeVertex v : ipv.getAdjVertices()) {
                            PipeGraphUtil.jankParticles(serverWorld, v, true);
                        }
                    } else {
                        player.method_43496(class_2561.method_30163((String)"No vertex"));
                    }
                }
            }
            return class_1269.field_5812;
        }
        return super.method_9534(state, world, pos, player, hand, hit);
    }

    @Override
    public void onConnectionUpdate(class_1937 world, class_2680 state, class_2680 newState, class_2338 pos, class_1657 entity) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof ItemPipeBlockEntity) {
            ItemPipeBlockEntity be = (ItemPipeBlockEntity)class_25862;
            be.getCallbacks().invalidate();
        }
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            ItemPipeGraphHelper.find(serverWorld, pos, state).ifPresent(h -> h.updateConnectionChange(state, newState));
        }
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return NMBlockEntities.ITEM_PIPE.method_11032(pos, state);
    }

    @Override
    public boolean isConnected(class_1922 blockView, class_2338 pos, class_2680 state, class_2350 face) {
        return ((ConnectionType)((Object)state.method_11654((class_2769)DIR_TO_CONNECTION.get(face)))).isConnected();
    }

    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return MiscUtil.checkType(type, NMBlockEntities.ITEM_PIPE, (world1, pos, state1, blockEntity) -> blockEntity.serverTick(world1, pos, state1), null, world);
    }

    @Override
    public long insert(class_1937 world, class_2338 pos, class_2680 state, class_2350 direction, ItemInPipe item, TransactionContext transaction) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof ItemPipeBlockEntity) {
            ItemPipeBlockEntity be = (ItemPipeBlockEntity)class_25862;
            return be.insert(item, world, state, pos, direction, transaction);
        }
        return 0L;
    }

    @Override
    public class_2350 getOutputDirection(ItemInPipe item, class_2338 pos, class_2680 state, class_1937 world, class_2350 in, @Nullable class_2586 beIn, boolean overridePathNode, TransactionContext transaction) {
        PipeConnections connections = ((ItemPipe)state.method_26204()).getConnections(state, null);
        class_2350 out = item.getPreferredOutputDirection(state, in, this, overridePathNode);
        if (out != null && connections.contains(out)) {
            return out;
        }
        EnumSet<class_2350> excluded = EnumSet.noneOf(class_2350.class);
        if (beIn instanceof ItemPipeBlockEntity) {
            int outId;
            ItemPipeBlockEntity be = (ItemPipeBlockEntity)beIn;
            int initialOut = be.getCurrentOutput(connections);
            do {
                outId = be.nextOutput(connections);
                class_2350 outDir = class_2350.values()[outId];
                if (outDir == in) continue;
                BlockApiCache<Storage<ItemVariant>, class_2350> cache = be.getStorageCache(outDir);
                class_2680 adjState = world.method_8320(cache.getPos());
                ItemPipe pipe = ItemPipe.findItemPipe(adjState);
                if (pipe != null && pipe.prioritise()) {
                    boolean inserted = pipe.canItemEnter(item.resource(), item.amount(), world, cache.getPos(), adjState, outDir.method_10153(), item.hasRoute());
                    if (inserted) {
                        return outDir;
                    }
                    excluded.add(outDir);
                    continue;
                }
                Storage storage = (Storage)cache.find((Object)outDir.method_10153());
                if (storage == null) continue;
                long inserted = MeatlibStorageUtil.simulateInsert(storage, item.resource(), item.amount(), transaction);
                if (inserted >= item.amount()) {
                    return outDir;
                }
                excluded.add(outDir);
            } while (outId != initialOut);
        }
        connections.unset(in);
        connections.unsetAll(excluded);
        out = !connections.isEmpty() ? connections.get(world.method_8409().method_43048(connections.size())) : in;
        return out;
    }

    @Override
    public boolean supportsRouting() {
        return true;
    }

    @Override
    public PipeVertex getPipeVertex(class_3218 world, class_2338 pos, class_2680 state) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof ItemPipeBlockEntity) {
            ItemPipeBlockEntity be = (ItemPipeBlockEntity)class_25862;
            return be.getVertex();
        }
        return null;
    }

    @Override
    public boolean endPoint() {
        return false;
    }
}

