/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.block.fluid_transport.machine;

import com.neep.meatlib.util.NbtSerialisable;
import com.neep.meatlib.util.graph.ConnectablePipe;
import com.neep.meatlib.util.graph.PipeGraphUtil;
import com.neep.neepmeat.init.NMBlockEntities;
import com.neep.neepmeat.transport.api.pipe.FluidPipe;
import com.neep.neepmeat.transport.fluid_network.FluidNodeHelper;
import com.neep.neepmeat.transport.fluid_network.FluidNodeHolder;
import com.neep.neepmeat.transport.fluid_network.FluidPipeVertex;
import com.neep.neepmeat.transport.fluid_network.node.BlockFluidPipeVertex;
import com.neep.neepmeat.transport.fluid_network.node.FluidNode;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerBlockEntityEvents;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class FluidPipeBlockEntity<T extends FluidPipeVertex & NbtSerialisable>
extends class_2586
implements FluidNodeHolder {
    protected boolean replaced = false;
    public class_2487 queuedNbt;
    protected final T vertex;
    protected final PipeConstructor<T> constructor;
    protected final List<FluidNode> fluidNodes = new ObjectArrayList(Collections.nCopies(6, null));

    public FluidPipeBlockEntity(class_2338 pos, class_2680 state, PipeConstructor<T> constructor) {
        this(NMBlockEntities.FLUID_PIPE, pos, state, constructor);
    }

    public FluidPipeBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state, PipeConstructor<T> constructor) {
        super(type, pos, state);
        this.vertex = constructor.create(this);
        this.constructor = constructor;
    }

    public static Optional<FluidPipeBlockEntity<?>> find(class_1937 world, class_2338 pos) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof FluidPipeBlockEntity) {
            FluidPipeBlockEntity be = (FluidPipeBlockEntity)class_25862;
            return Optional.of(be);
        }
        return Optional.empty();
    }

    @Override
    public void clearNodes() {
        for (int i = 0; i < 6; ++i) {
            this.fluidNodes.set(i, null);
        }
    }

    @Override
    public boolean removeNode(class_2350 face) {
        if (this.fluidNodes.get(face.ordinal()) != null) {
            this.fluidNodes.set(face.ordinal(), null);
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public FluidNode getNode(class_2350 face) {
        return this.fluidNodes.get(face.ordinal());
    }

    @Override
    public void putNode(class_2350 face, FluidNode node) {
        this.fluidNodes.set(face.ordinal(), node);
    }

    public void updateHiddenConnections(class_2680 newState) {
        FluidPipe pipe = (FluidPipe)newState.method_26204();
        this.vertex.reset();
        this.vertex.updateNodes((class_3218)this.field_11863, this.field_11867, newState);
        int connections = pipe.countConnections(newState);
        if (connections > 2 || !this.vertex.canSimplify()) {
            this.findAdjacent(pipe);
        } else if (connections == 2) {
            PipeGraphUtil.linkVertices((class_3218)this.field_11863, this.field_11867, this.method_11010(), pipe, (world, pos) -> (FluidPipeVertex)FluidPipeVertex.LOOKUP.find((class_1937)world, pos, null), FluidPipe::findFluidPipe);
        }
        this.method_5431();
    }

    public void updateConnectionChange(class_2680 state, class_2680 newState) {
        FluidPipe pipe = (FluidPipe)newState.method_26204();
        int connections = pipe.countConnections(newState);
        if (this.vertex.canSimplify() && connections == 1) {
            this.vertex.reset();
            this.vertex.updateNodes((class_3218)this.field_11863, this.field_11867, newState);
            for (class_2350 direction : pipe.getConnections(this.method_11010())) {
                Pair<FluidPipeVertex, class_2350> adjacent = this.findNextVertex(this.field_11867, direction);
                if (adjacent == null) continue;
                ((FluidPipeVertex)adjacent.first()).setAdjVertex(((class_2350)adjacent.second()).ordinal(), null);
            }
        } else {
            this.updateHiddenConnections(newState);
        }
    }

    private void findAdjacent(FluidPipe pipe) {
        for (class_2350 direction : pipe.getConnections(this.method_11010())) {
            Pair<FluidPipeVertex, class_2350> adjacent = this.findNextVertex(this.field_11867, direction);
            if (adjacent == null) continue;
            this.vertex.setAdjVertex(direction.method_10146(), (FluidPipeVertex)adjacent.first());
            ((FluidPipeVertex)adjacent.first()).setAdjVertex(((class_2350)adjacent.second()).method_10146(), (FluidPipeVertex)this.vertex);
        }
    }

    private Pair<FluidPipeVertex, class_2350> findNextVertex(class_2338 pos, class_2350 out) {
        return PipeGraphUtil.findNextVertex((class_3218)this.field_11863, pos, out, (w, p) -> (FluidPipeVertex)FluidPipeVertex.LOOKUP.find((class_1937)w, p, null), FluidPipe::findFluidPipe);
    }

    public void method_5431() {
        if (this.field_11863 != null) {
            this.field_11863.method_8524(this.field_11867);
        }
    }

    public void method_31664(class_2680 state) {
        super.method_31664(state);
        T t = this.vertex;
        if (t instanceof BlockFluidPipeVertex) {
            BlockFluidPipeVertex blockPipeVertex = (BlockFluidPipeVertex)t;
            blockPipeVertex.invalidateCanSimplify();
        }
    }

    public void prepareForRemoval(class_2680 state, class_2680 newState) {
        this.markReplaced();
        PipeGraphUtil.eraseHiddenFromNeighbours((class_3218)this.field_11863, this.field_11867, state, (ConnectablePipe)this.method_11010().method_26204(), FluidPipe::findFluidPipe);
    }

    public void method_31662(class_1937 world) {
        super.method_31662(world);
        class_1937 class_19372 = this.method_10997();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            if (world.method_8503().method_18854() && this.queuedNbt != null) {
                FluidNodeHelper.readNodes(this, this.queuedNbt, serverWorld);
            }
        }
    }

    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        FluidNodeHelper.writeNodes(this, nbt);
        nbt.method_10566("vertex", (class_2520)((NbtSerialisable)this.vertex).writeNbt(new class_2487()));
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.queuedNbt = nbt.method_10553();
        ((NbtSerialisable)this.vertex).readNbt(nbt.method_10562("vertex"));
    }

    public void method_11012() {
        super.method_11012();
    }

    public void markReplaced() {
        this.replaced = true;
    }

    public T getPipeVertex() {
        return this.vertex;
    }

    public void onUnload(class_3218 world) {
    }

    public void onLoad(class_3218 world) {
    }

    public void onRemove(class_3218 world) {
        this.vertex.erase();
    }

    public void tick() {
        this.vertex.tickDeferredLoad();
        if (!this.vertex.canSimplify()) {
            this.vertex.preTick();
            this.vertex.tick();
        }
    }

    static {
        ServerBlockEntityEvents.BLOCK_ENTITY_UNLOAD.register((blockEntity, world) -> {
            if (blockEntity instanceof FluidPipeBlockEntity) {
                FluidPipeBlockEntity be = (FluidPipeBlockEntity)blockEntity;
                if (!be.replaced) {
                    be.onUnload(world);
                } else {
                    be.onRemove(world);
                    be.replaced = false;
                }
            }
        });
    }

    @FunctionalInterface
    public static interface PipeConstructor<T extends FluidPipeVertex & NbtSerialisable> {
        public T create(FluidPipeBlockEntity<T> var1);
    }
}

