/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.block.fluid_transport;

import com.google.common.collect.Lists;
import com.neep.meatlib.block.BaseColumnBlock;
import com.neep.meatlib.item.ItemSettings;
import com.neep.meatlib.registry.RegistrationContext;
import com.neep.neepmeat.api.storage.WritableSingleFluidStorage;
import com.neep.neepmeat.init.NMBlockEntities;
import com.neep.neepmeat.transport.block.fluid_transport.machine.TankBlockEntity;
import com.neep.neepmeat.transport.block.fluid_transport.machine.TankType;
import com.neep.neepmeat.util.ItemUtil;
import com.neep.neepmeat.util.Wrenchable;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.block.BlockPickInteractionAware;
import net.fabricmc.fabric.api.lookup.v1.item.ItemApiLookup;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantItemStorage;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;

public class TankBlock
extends BaseColumnBlock
implements class_2343,
BlockPickInteractionAware,
Wrenchable {
    public TankBlock(RegistrationContext ctx, ItemSettings itemSettings, class_4970.class_2251 settings) {
        super(ctx, itemSettings.maxCount(1), settings);
    }

    public class_1792 method_8389() {
        return super.method_8389();
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return NMBlockEntities.TANK.method_11032(pos, state);
    }

    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        return new class_1799((class_1935)this);
    }

    public class_1799 getPickedStack(class_2680 state, class_1922 view, class_2338 pos, class_1657 player, class_239 result) {
        if (player.method_7337()) {
            TankBlockEntity be;
            class_1799 stack = super.method_9574(view, pos, state);
            class_2586 class_25862 = view.method_8321(pos);
            if (class_25862 instanceof TankBlockEntity && !(be = (TankBlockEntity)class_25862).getStorage(null).isResourceBlank()) {
                be.method_38240(stack);
            }
            return stack;
        }
        class_2586 be = view.method_8321(pos);
        if (be instanceof TankBlockEntity) {
            TankBlockEntity be2 = (TankBlockEntity)be;
            FluidVariant storedVariant = (FluidVariant)be2.getStorage(null).getResource();
            class_1792 asItem = this.method_8389();
            ArrayList matching = Lists.newArrayList();
            ArrayList matchingFluid = Lists.newArrayList();
            for (int i = 0; i < player.method_31548().method_5439(); ++i) {
                FluidVariant fluidVariant;
                class_1799 stack = player.method_31548().method_5438(i);
                if (!stack.method_31574(asItem)) continue;
                matching.add(stack);
                class_2487 stackNbt = stack.method_7941("BlockEntityTag");
                if (stackNbt == null || (fluidVariant = WritableSingleFluidStorage.readFluidVariant(stackNbt)).getFluid() != storedVariant.getFluid()) continue;
                matchingFluid.add(stack);
            }
            if (!matchingFluid.isEmpty()) {
                return (class_1799)matchingFluid.get(0);
            }
            if (!matching.isEmpty()) {
                return (class_1799)matching.get(0);
            }
        }
        return this.method_9574(view, pos, state);
    }

    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        List stacks = super.method_9560(state, builder);
        class_2586 blockEntity = (class_2586)builder.method_51873(class_181.field_1228);
        if (blockEntity instanceof TankBlockEntity) {
            TankBlockEntity be = (TankBlockEntity)blockEntity;
            if (!be.getStorage(null).isResourceBlank()) {
                stacks.forEach(be::method_38240);
            }
            return stacks;
        }
        return stacks;
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        TankBlockEntity tank;
        if (ItemUtil.playerHoldingPipe(player, hand)) {
            return class_1269.field_5811;
        }
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof TankBlockEntity && (tank = (TankBlockEntity)class_25862).onUse(player, hand)) {
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    @Override
    public class_2680 rotate(class_2680 state, class_3965 hitResult) {
        class_2350 side = hitResult.method_17780();
        class_2350.class_2351 facing = (class_2350.class_2351)state.method_11654((class_2769)field_11459);
        return (class_2680)state.method_11657((class_2769)field_11459, (Comparable)Wrenchable.rotateAxis(side.method_10166(), facing));
    }

    public static ItemApiLookup.ItemApiProvider<Storage<FluidVariant>, ContainerItemContext> createStorageProvider(TankType tankType) {
        return (stack, ctx) -> new TankItemFluidStorage(stack, (ContainerItemContext)ctx, tankType);
    }

    public static class TankItemFluidStorage
    extends SingleVariantItemStorage<FluidVariant> {
        protected final class_1799 stack;
        protected final ContainerItemContext context;
        private final long capacity;

        public TankItemFluidStorage(class_1799 stack, ContainerItemContext context, TankType tankType) {
            super(context);
            this.stack = stack;
            this.context = context;
            this.capacity = tankType.capacity();
        }

        protected FluidVariant getBlankResource() {
            return FluidVariant.blank();
        }

        @Nullable
        private class_2487 getBlockEntityTag(ItemVariant itemVariant) {
            class_2487 nbt = itemVariant.getNbt();
            if (nbt == null || !nbt.method_10545("BlockEntityTag")) {
                return null;
            }
            return nbt.method_10562("BlockEntityTag");
        }

        protected FluidVariant getResource(ItemVariant currentVariant) {
            class_2487 nbt = this.getBlockEntityTag(currentVariant);
            if (nbt == null) {
                return FluidVariant.blank();
            }
            return WritableSingleFluidStorage.readFluidVariant(nbt);
        }

        protected long getAmount(ItemVariant currentVariant) {
            class_2487 nbt = this.getBlockEntityTag(currentVariant);
            if (nbt == null) {
                return 0L;
            }
            return WritableSingleFluidStorage.readAmount(nbt);
        }

        protected long getCapacity(FluidVariant variant) {
            return this.capacity;
        }

        protected ItemVariant getUpdatedVariant(ItemVariant currentVariant, FluidVariant newResource, long newAmount) {
            class_1799 stack = currentVariant.toStack();
            if (newResource.isBlank() || newAmount == 0L) {
                stack.method_7983("BlockEntityTag");
                return ItemVariant.of((class_1799)stack);
            }
            class_2487 subNbt = stack.method_7911("BlockEntityTag");
            subNbt.method_10566("resource", (class_2520)newResource.toNbt());
            subNbt.method_10544("amount", newAmount);
            return ItemVariant.of((class_1799)stack);
        }
    }
}

