/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.api.item_network;

import com.neep.meatlib.api.network.CompositeParamCodec;
import com.neep.meatlib.api.network.ParamCodec;
import com.neep.meatlib.api.network.ParamCodecs;
import com.neep.neepmeat.transport.api.item_network.RoutablePipe;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public interface RoutingNetwork {
    public static final BlockApiLookup<RoutingNetwork, Void> LOOKUP = BlockApiLookup.get((class_2960)new class_2960("neepmeat", "routing_network"), RoutingNetwork.class, Void.class);
    public static final RoutingNetwork DEFAULT = new RoutingNetwork(){

        @Override
        public Stream<ResourceAmount<ItemVariant>> getAllAvailable(Predicate<ItemVariant> predicate, TransactionContext transaction) {
            return Stream.empty();
        }

        @Override
        public boolean route(Predicate<ItemVariant> predicate, long amount, class_2338 inPos, class_2350 inDir, class_2338 outPos, class_2350 outDir, RequestType type, TransactionContext transaction) {
            return false;
        }

        @Override
        public boolean request(Predicate<ItemVariant> predicate, long amount, class_2338 pos, class_2350 outDir, RequestType type, RequestContext context, TransactionContext transaction) {
            return false;
        }

        @Override
        public long store(ItemVariant variant, long amount, class_2338 inPos, class_2350 inFace, TransactionContext transaction) {
            return 0L;
        }

        @Override
        public void invalidate() {
        }

        @Override
        public boolean needsUpdate() {
            return false;
        }

        @Override
        public void update() {
        }

        @Override
        public long getVersion() {
            return 0L;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public void serverTick() {
        }
    };

    public Stream<ResourceAmount<ItemVariant>> getAllAvailable(Predicate<ItemVariant> var1, TransactionContext var2);

    default public List<ResourceAmount<ItemVariant>> listAllAvailable(Predicate<ItemVariant> predicate, TransactionContext transaction) {
        return (List)this.getAllAvailable(predicate, transaction).collect(Collectors.collectingAndThen(Collectors.toMap(ResourceAmount::resource, Function.identity(), RoutingNetwork::combine), m -> new ObjectArrayList(m.values())));
    }

    public static <T> ResourceAmount<T> combine(ResourceAmount<T> am1, ResourceAmount<T> am2) {
        return new ResourceAmount(am1.resource(), am1.amount() + am2.amount());
    }

    public boolean route(Predicate<ItemVariant> var1, long var2, class_2338 var4, class_2350 var5, class_2338 var6, class_2350 var7, RequestType var8, TransactionContext var9);

    default public boolean request(ResourceAmount<ItemVariant> stack, class_2338 pos, class_2350 outDir, RequestType type, RequestContext context, TransactionContext transaction) {
        return this.request(v -> v.equals(stack.resource()), stack.amount(), pos, outDir, type, context, transaction);
    }

    public boolean request(Predicate<ItemVariant> var1, long var2, class_2338 var4, class_2350 var5, RequestType var6, RequestContext var7, TransactionContext var8);

    public long store(ItemVariant var1, long var2, class_2338 var4, class_2350 var5, TransactionContext var6);

    public void invalidate();

    public boolean needsUpdate();

    public void update();

    public long getVersion();

    public boolean isValid();

    public void serverTick();

    public static enum RequestType {
        ANY_AMOUNT(false),
        EXACT_AMOUNT(true);

        private final boolean matchExact;

        private RequestType(boolean matchExact) {
            this.matchExact = matchExact;
        }

        public boolean satisfied(long requested, long found) {
            return requested == found && this.matchExact || found >= requested && !this.matchExact;
        }
    }

    public static class RequestContext {
        public int recursionDepth;
    }

    public static final class DeferredRequest {
        private final class_2338 sourcePos;
        public final class_2338 requesterPos;
        public final class_2350 requesterFace;
        private final ItemVariant itemVariant;
        private final long requested;
        @Nullable
        private RoutablePipe pipe;
        public static final ParamCodec<DeferredRequest> PARAM_CODEC = CompositeParamCodec.builder(DeferredRequest.class).param(o -> o.sourcePos, ParamCodecs.BLOCK_POS).param(o -> o.requesterPos, ParamCodecs.BLOCK_POS).param(o -> o.requesterFace, ParamCodec.ofEnum(class_2350.class)).param(o -> o.requested, ParamCodec.LONG).param(o -> o.itemVariant, ParamCodecs.ITEM_VARIANT).build();

        public DeferredRequest(class_2338 sourcePos, class_2338 requesterPos, class_2350 requesterFace, long requested, ItemVariant itemVariant) {
            this.sourcePos = sourcePos;
            this.requesterPos = requesterPos;
            this.requesterFace = requesterFace;
            this.itemVariant = itemVariant;
            this.requested = requested;
        }

        public long getRequested() {
            return this.requested;
        }

        public ItemVariant getItemVariant() {
            return this.itemVariant;
        }

        public RoutablePipe getPipe(class_1937 world) {
            class_2586 class_25862;
            if (this.pipe == null && (class_25862 = world.method_8321(this.sourcePos)) instanceof RoutablePipe) {
                RoutablePipe routablePipe;
                this.pipe = routablePipe = (RoutablePipe)class_25862;
            }
            return this.pipe;
        }

        public String toString() {
            return "Request{requested=" + this.requested + ", itemVariant=" + String.valueOf(this.itemVariant) + ", requesterPos=" + String.valueOf(this.requesterPos) + ", sourcePos=" + String.valueOf(this.sourcePos) + "}";
        }

        public boolean equals(Object o) {
            if (!(o instanceof DeferredRequest)) {
                return false;
            }
            DeferredRequest that = (DeferredRequest)o;
            return this.requested == that.requested && Objects.equals(this.sourcePos, that.sourcePos) && Objects.equals(this.requesterPos, that.requesterPos) && this.requesterFace == that.requesterFace && Objects.equals(this.itemVariant, that.itemVariant);
        }

        public int hashCode() {
            return Objects.hash(this.sourcePos, this.requesterPos, this.requesterFace, this.itemVariant, this.requested);
        }

        public class_2487 toNbt() {
            class_2487 nbt = new class_2487();
            nbt.method_10566("pos", (class_2520)class_2512.method_10692((class_2338)this.sourcePos));
            nbt.method_10566("requester_pos", (class_2520)class_2512.method_10692((class_2338)this.requesterPos));
            nbt.method_10569("requester_face", this.requesterFace.ordinal());
            nbt.method_10566("item", (class_2520)this.itemVariant.toNbt());
            nbt.method_10544("amount", this.requested);
            return nbt;
        }

        public static DeferredRequest fromNbt(class_2487 nbt) {
            return new DeferredRequest(class_2512.method_10691((class_2487)nbt.method_10562("pos")), class_2512.method_10691((class_2487)nbt.method_10562("requester_pos")), class_2350.values()[nbt.method_10550("requester_face")], nbt.method_10537("amount"), ItemVariant.fromNbt((class_2487)nbt.method_10562("item")));
        }
    }
}

