/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.thord.token;

import com.google.common.collect.Lists;
import com.neep.meatlib.util.StringTokenView;
import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.neepasm.compiler.NeepAsmParser;
import com.neep.neepmeat.plc.instruction.Argument;
import com.neep.neepmeat.thord.Keyword;
import com.neep.neepmeat.thord.parser.ThordDictionary;
import com.neep.neepmeat.thord.parser.ThordMacro;
import com.neep.neepmeat.thord.parser.node.WorldTargetAliasToken;
import com.neep.neepmeat.thord.token.CoordsToken;
import com.neep.neepmeat.thord.token.IdentifierToken;
import com.neep.neepmeat.thord.token.InlineToken;
import com.neep.neepmeat.thord.token.IntLiteralToken;
import com.neep.neepmeat.thord.token.KeywordToken;
import com.neep.neepmeat.thord.token.LexerContext;
import com.neep.neepmeat.thord.token.ScopeEndToken;
import com.neep.neepmeat.thord.token.StringToken;
import com.neep.neepmeat.thord.token.ThordToken;
import com.neep.neepmeat.thord.token.ThordTokenView;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThordLexer {
    private final ThordDictionary dictionary;
    private final Set<String> inlineOperations;

    public ThordLexer(ThordDictionary dictionary, Set<String> inlineOperations) {
        this.dictionary = dictionary;
        this.inlineOperations = inlineOperations;
    }

    public List<ThordToken> tokenise(String source) throws NeepASM.ProgramBuildException {
        ObjectArrayList tokens = new ObjectArrayList();
        ThordTokenView view = new ThordTokenView(source);
        try {
            this.tokenise(new LexerContext(view), (List<ThordToken>)tokens);
        }
        catch (NeepASM.ParseException e) {
            throw new NeepASM.ProgramBuildException(view.line(), view.linePos(), e.getMessage());
        }
        return tokens;
    }

    private void tokenise(LexerContext context, List<ThordToken> tokens) throws NeepASM.ParseException {
        while (!context.view.eof()) {
            ThordToken token = this.nextToken(context);
            tokens.add(token);
        }
    }

    @Nullable
    public ThordToken nextToken(LexerContext context) throws NeepASM.ParseException {
        boolean newLine;
        List<ThordToken> buffer = context.buffer;
        ThordTokenView view = context.view;
        if (!buffer.isEmpty()) {
            return buffer.remove(0);
        }
        view.fastForward();
        char c = view.peek();
        boolean bl = newLine = view.pos() == 0;
        if (view.isWhitespace(c) && c == '\n') {
            view.next();
            view.fastForward();
            c = view.peek();
            newLine = true;
        }
        if (view.isWhitespace(c) && c != '\n') {
            view.next();
        } else if (c == '#') {
            while (view.peek() != '\n' && !view.eof()) {
                view.next();
            }
        } else if (c == '(') {
            char c1;
            do {
                if (!view.eof()) continue;
                throw new NeepASM.ParseException("reached EOF during word definition");
            } while ((c1 = view.next()) != ')');
        } else {
            if (c == ';') {
                view.next();
                return new ScopeEndToken(view.line());
            }
            if (c == '%' && view.peek(1) == ':') {
                this.parseMacro(view, context);
            } else {
                if (c == '%' && view.peek(1) == 'a') {
                    return this.parseAlias(view, context);
                }
                if (c == '@' && view.peek(1) == '(') {
                    return this.parseWorldTarget(view, context);
                }
                if (c == '\"') {
                    return this.parseString(view, context);
                }
                if (c == '.' && !view.isWhitespace(view.peek(1)) && view.peek(1) != '\u0000') {
                    view.next();
                    String identifier = view.nextIdentifier();
                    return this.processInline(identifier, view);
                }
                if (c == '-' && StringTokenView.isDigit(view.peek(1)) || StringTokenView.isDigit(c) && !this.isIdentifier(view)) {
                    return new IntLiteralToken(view.nextInteger(), view.line());
                }
                if (c == '\"') {
                    view.next();
                } else {
                    return this.processIdentifier(newLine, view, context);
                }
            }
        }
        return null;
    }

    @NotNull
    private ThordToken parseString(ThordTokenView view, LexerContext context) {
        return new StringToken(view.line(), view.nextString());
    }

    @NotNull
    private CoordsToken parseWorldTarget(ThordTokenView view, LexerContext context) throws NeepASM.ParseException {
        view.next(2);
        class_2350 direction = class_2350.field_11036;
        if (StringTokenView.isDigit(view.peekThing())) {
            int x = view.nextInteger();
            if (StringTokenView.isDigit(view.peekThing())) {
                int y = view.nextInteger();
                if (StringTokenView.isDigit(view.peekThing())) {
                    int z = view.nextInteger();
                    if (Character.isAlphabetic(view.peekThing())) {
                        StringBuilder sb = new StringBuilder();
                        while (view.peek() != ')' && !view.eof()) {
                            sb.append(view.next());
                        }
                        direction = NeepAsmParser.parseDirection(sb.toString());
                        if (direction == null) {
                            direction = class_2350.field_11036;
                        }
                    }
                    if (view.nextThing() == ')') {
                        return new CoordsToken(view.line(), new Argument(new class_2338(x, y, z), direction));
                    }
                }
            }
        }
        throw new NeepASM.ParseException("malformed target\n Targets should be of the form '@(<x> <y> <z> <direction>)");
    }

    private void parseMacro(ThordTokenView view, LexerContext context) throws NeepASM.ParseException {
        view.fastForward();
        view.next(2);
        StringBuilder macroText = new StringBuilder();
        String name = view.nextIdentifier();
        if (name.isEmpty()) {
            throw new NeepASM.ParseException("expected macro name");
        }
        int startLine = view.line();
        ArrayList parameters = Lists.newArrayList();
        view.fastForward();
        while (view.isIdentifier(0, view.peek())) {
            String parameter = view.nextIdentifier();
            parameters.add(parameter);
            view.fastForward();
        }
        if (!view.lineEnded() && !NeepAsmParser.isComment(view)) {
            throw new NeepASM.ParseException("unexpected token");
        }
        while (!view.eof()) {
            if (view.peek() == '%') {
                try (StringTokenView.Mark entry = view.mark();){
                    view.next();
                    String id = view.nextIdentifier();
                    if (id.equals(";")) {
                        entry.commit();
                        context.addMacro(new ThordMacro(name, parameters, macroText.toString(), startLine));
                        return;
                    }
                }
            }
            macroText.append(view.peek());
            view.next();
        }
        throw new NeepASM.ParseException("reached end of file while parsing macro '" + name + "'");
    }

    private ThordToken parseAlias(ThordTokenView view, LexerContext context) throws NeepASM.ParseException {
        char c;
        do {
            c = view.next();
            if (!view.eof()) continue;
            throw new NeepASM.ParseException("expected alias name");
        } while (!view.isWhitespace(c));
        view.fastForward();
        String name = view.nextIdentifier();
        if (name.isEmpty()) {
            throw new NeepASM.ParseException("expected value after alias");
        }
        if (view.nextThing() != '=') {
            throw new NeepASM.ParseException("expected = after alias name");
        }
        view.fastForward();
        CoordsToken token = this.parseWorldTarget(view, context);
        return new WorldTargetAliasToken(token.line(), name, token.argument());
    }

    private ThordToken processInline(String identifier, ThordTokenView view) {
        StringBuilder sb = new StringBuilder();
        while (!view.lineEnded()) {
            char c1 = view.next();
            sb.append(c1);
        }
        if (view.isTerminator(view.peek())) {
            view.next();
        }
        return new InlineToken(identifier, sb.toString(), view.line());
    }

    private ThordToken processIdentifier(boolean newLine, ThordTokenView view, LexerContext context) throws NeepASM.ParseException {
        String identifier = view.nextIdentifier();
        if (!identifier.isEmpty()) {
            for (Keyword keyword : Keyword.values()) {
                if (!keyword.matches(identifier)) continue;
                return new KeywordToken(keyword, view.line());
            }
            ThordMacro macro = context.getMacro(identifier);
            if (macro != null) {
                return this.expandMacro(context, macro);
            }
            if (newLine && !this.dictionary.contains(identifier) && this.inlineOperations.contains(identifier)) {
                return this.processInline(identifier, view);
            }
            return new IdentifierToken(identifier, view.line());
        }
        return null;
    }

    @Nullable
    private ThordToken expandMacro(LexerContext context, ThordMacro macro) throws NeepASM.ParseException {
        String expanded = macro.expand(context.view);
        if (context.macroLevel > 8) {
            throw new NeepASM.ParseException("reached maximum macro nesting depth");
        }
        this.tokenise(new LexerContext(new ThordTokenView(expanded, macro.getStartLine()), context.macros, context.macroLevel + 1), context.buffer);
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean isIdentifier(ThordTokenView view) {
        try (StringTokenView.Mark ignore = view.mark();){
            String s = view.nextIdentifier();
            if (s.equals("-")) {
                boolean bl = true;
                return bl;
            }
            StringTokenView.parseInteger(s);
            boolean bl = false;
            return bl;
        }
        catch (NeepASM.ParseException e) {
            return true;
        }
    }

    public boolean hasNext(LexerContext context) {
        return !context.view.eof() || !context.buffer.isEmpty();
    }
}

