/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.thord.parser;

import com.neep.meatlib.util.NeepAsmTokenView;
import com.neep.neepbus.util.message.DataVariant;
import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.neepasm.compiler.InstructionAcceptor;
import com.neep.neepmeat.neepasm.compiler.LabelLookup;
import com.neep.neepmeat.neepasm.compiler.NeepAsmParser;
import com.neep.neepmeat.neepasm.compiler.ParsedFunction;
import com.neep.neepmeat.neepasm.compiler.parser.ParsedInstruction;
import com.neep.neepmeat.neepasm.program.Label;
import com.neep.neepmeat.plc.SingletonInstructions;
import com.neep.neepmeat.plc.instruction.Argument;
import com.neep.neepmeat.plc.instruction.PushInstruction;
import com.neep.neepmeat.thord.compiler.CheckedIntStack;
import com.neep.neepmeat.thord.compiler.CompilerVM;
import com.neep.neepmeat.thord.parser.ExecutionProgram;
import com.neep.neepmeat.thord.parser.ParsedExecute;
import com.neep.neepmeat.thord.parser.ParsedImmediateWord;
import com.neep.neepmeat.thord.parser.ThordParsedSource;
import com.neep.neepmeat.thord.parser.ThordProgramTree;
import com.neep.neepmeat.thord.parser.node.ArrayNode;
import com.neep.neepmeat.thord.parser.node.ExecuteNode;
import com.neep.neepmeat.thord.parser.node.ImmediateWordDefinitionNode;
import com.neep.neepmeat.thord.parser.node.InlineNode;
import com.neep.neepmeat.thord.parser.node.LabelNode;
import com.neep.neepmeat.thord.parser.node.NonameWordDefinitionNode;
import com.neep.neepmeat.thord.parser.node.NumberLiteralNode;
import com.neep.neepmeat.thord.parser.node.PostponeNode;
import com.neep.neepmeat.thord.parser.node.ThordTreeVisitor;
import com.neep.neepmeat.thord.parser.node.TickNode;
import com.neep.neepmeat.thord.parser.node.TreeNode;
import com.neep.neepmeat.thord.parser.node.VariableDeclareNode;
import com.neep.neepmeat.thord.parser.node.WordDefinitionNode;
import com.neep.neepmeat.thord.parser.node.WordNode;
import com.neep.neepmeat.thord.token.CoordsToken;
import com.neep.neepmeat.thord.token.StringToken;
import com.neep.neepmeat.thord.word.ImmediateWord;
import com.neep.neepmeat.thord.word.Word;
import it.unimi.dsi.fastutil.Stack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class TreeVisitorImpl
implements ThordTreeVisitor {
    private final ThordProgramTree tree;
    private final NeepAsmParser neepAsmParser;
    private final Stack<InstructionAcceptor> acceptors = new ObjectArrayList();
    private int memoryHead = 1;
    private int nonameWords = 0;
    private final CheckedIntStack compilerStack = new CheckedIntStack(32, "compile stack");
    private final CompilerVM machine = new CompilerVM(this.compilerStack);
    private final Stack<TreeNode> route = new ObjectArrayList();
    private int line;

    public TreeVisitorImpl(ThordProgramTree tree, ThordParsedSource rootSource, NeepAsmParser neepAsmParser) {
        this.tree = tree;
        this.neepAsmParser = neepAsmParser;
        this.acceptors.push((Object)rootSource);
    }

    @Nullable
    private TreeNode lookAhead(TreeNode child) {
        TreeNode top;
        List<TreeNode> children;
        int index;
        if (!this.route.isEmpty() && (index = (children = (top = (TreeNode)this.route.peek(0)).children()).indexOf(child)) != -1 && children.size() > index + 1) {
            return children.get(index + 1);
        }
        return null;
    }

    private InstructionAcceptor peek() {
        return (InstructionAcceptor)this.acceptors.peek(0);
    }

    private void instruction(ParsedInstruction parsedInstruction, int line) {
        this.peek().instruction(parsedInstruction, line);
    }

    private void instruction(int position, ParsedInstruction parsedInstruction, int line) throws NeepASM.CompilationException {
        this.peek().instruction(position, parsedInstruction, line);
    }

    private void label(Label label) {
        this.peek().label(label);
    }

    public void process() throws NeepASM.ProgramBuildException {
        TreeNode node = this.tree.root();
        try {
            node.visit(this);
            if (!this.compilerStack.isEmpty()) {
                throw new NeepASM.ParseException("compiler stack not empty - probably unterminated construct");
            }
        }
        catch (NeepASM.NeepAsmException e) {
            throw new NeepASM.ProgramBuildException(this.line, 0, e.getMessage());
        }
    }

    private void visitChildren(TreeNode node) throws NeepASM.NeepAsmException {
        this.route.push((Object)node);
        for (TreeNode child : node.children()) {
            this.line = child.line();
            child.visit(this);
        }
        this.route.pop();
    }

    @Override
    public void visit(ThordProgramTree.RootNode node) throws NeepASM.NeepAsmException {
        this.visitChildren(node);
    }

    @Override
    public void visit(WordNode node) throws NeepASM.NeepAsmException {
        Word word = this.tree.dictionary().get(node.name());
        if (word == null) {
            throw new NeepASM.CompilationException("undefined word " + node.name());
        }
        word.expand(this.peek(), this.machine, node.line());
    }

    @Override
    public void visit(TickNode node) throws NeepASM.NeepAsmException {
        this.instruction((labelLookup, program) -> {
            Label label = labelLookup.findLabel(node.word());
            if (label == null) {
                throw new NeepASM.CompilationException("unknown label " + node.word());
            }
            return new PushInstruction(label.index(), true);
        }, node.line());
    }

    @Override
    public void visit(VariableDeclareNode node) {
        this.instruction((labelLookup, program) -> new PushInstruction(0), node.line());
        int address = this.memoryHead;
        this.instruction((labelLookup, program) -> new PushInstruction(address), node.line());
        this.instruction((labelLookup, program) -> SingletonInstructions.STORE, node.line());
        this.label(new Label(node.name(), this.memoryHead));
        ++this.memoryHead;
    }

    @Override
    public void visit(ArrayNode node) {
        this.instruction((labelLookup, program) -> new PushInstruction(node.size()), node.line());
        this.instruction((labelLookup, program) -> SingletonInstructions.ALLOT, node.line());
        int address = this.memoryHead;
        this.instruction((labelLookup, program) -> new PushInstruction(address), node.line());
        this.instruction((labelLookup, program) -> new PushInstruction(node.size()), node.line());
        this.instruction((labelLookup, program) -> new PushInstruction(0), node.line());
        this.instruction((labelLookup, program) -> SingletonInstructions.FILL, node.line());
        this.label(new Label(node.name(), this.memoryHead));
        this.memoryHead += node.size();
    }

    @Override
    public void visit(CoordsToken node) {
        int line = node.line();
        Argument argument = node.argument();
        this.instruction((labelLookup, program) -> new PushInstruction(argument.pos().method_10263()), line);
        this.instruction((labelLookup, program) -> new PushInstruction(argument.pos().method_10264()), line);
        this.instruction((labelLookup, program) -> new PushInstruction(argument.pos().method_10260()), line);
        this.instruction((labelLookup, program) -> new PushInstruction(argument.face().ordinal()), line);
    }

    @Override
    public void visit(StringToken node) {
        this.instruction((labelLookup, program) -> new PushInstruction(DataVariant.of(node.value()), true), node.line());
    }

    @Override
    public void visit(WordDefinitionNode node) throws NeepASM.NeepAsmException {
        ParsedFunction function = new ParsedFunction(node.name(), s -> null);
        this.peek().function(function);
        this.acceptors.push((Object)function);
        this.visitChildren(node);
        this.acceptors.pop();
    }

    @Override
    public void visit(NonameWordDefinitionNode node) throws NeepASM.NeepAsmException {
        String name = "noname" + this.nonameWords;
        ParsedFunction function = new ParsedFunction(name, s -> null);
        this.peek().function(function);
        this.acceptors.push((Object)function);
        this.visitChildren(node);
        this.acceptors.pop();
        this.instruction((labelLookup, program) -> {
            Label label = labelLookup.findLabel(name);
            if (label == null) {
                throw new NeepASM.CompilationException("unknown label " + name);
            }
            return new PushInstruction(label.index(), true);
        }, node.line());
        ++this.nonameWords;
    }

    @Override
    public void visit(ImmediateWordDefinitionNode node) throws NeepASM.NeepAsmException {
        String name = node.name();
        ParsedImmediateWord collector = new ParsedImmediateWord(this.machine);
        this.acceptors.push((Object)collector);
        this.route.push((Object)node);
        for (TreeNode child : node.children()) {
            this.line = child.line();
            if (child instanceof NonameWordDefinitionNode) {
                NonameWordDefinitionNode nonameWordDefinitionNode = (NonameWordDefinitionNode)child;
                nonameWordDefinitionNode.visit(this);
                continue;
            }
            if (child instanceof PostponeNode) {
                PostponeNode postpone = (PostponeNode)child;
                for (TreeNode postponeChild : postpone.children()) {
                    if (postponeChild instanceof WordNode) {
                        WordNode wordNode = (WordNode)postponeChild;
                        Word word1 = this.tree.dictionary().get(wordNode.name());
                        if (word1 == null) {
                            throw new NeepASM.CompilationException("undefined word " + wordNode.name());
                        }
                        collector.word(word1, wordNode.line());
                        continue;
                    }
                    if (postponeChild instanceof NumberLiteralNode) {
                        NumberLiteralNode numberNode = (NumberLiteralNode)postponeChild;
                        collector.word((acceptor, stack, line1) -> acceptor.instruction((labelLookup, program) -> new PushInstruction(numberNode.value()), numberNode.line()), numberNode.line());
                        continue;
                    }
                    if (!(postponeChild instanceof InlineNode)) continue;
                    InlineNode inline = (InlineNode)postponeChild;
                    try {
                        ParsedInstruction parsed = inline.provider().getParser().parse(new NeepAsmTokenView(inline.arguments()), this.neepAsmParser, null);
                        collector.word((acceptor, stack, line1) -> acceptor.instruction(parsed, node.line()), node.line());
                    }
                    catch (NeepASM.ParseException e) {
                        throw new NeepASM.CompilationException(e.getMessage());
                    }
                }
                continue;
            }
            child.visit(this);
        }
        this.acceptors.pop();
        this.tree.dictionary().put(name, new ImmediateWord(name, collector, i -> {
            this.line = i;
        }));
    }

    @Override
    public void visit(ExecuteNode node) throws NeepASM.NeepAsmException {
        ExecutionProgram program = new ExecutionProgram();
        ParsedExecute collector = new ParsedExecute();
        this.acceptors.push((Object)collector);
        this.visitChildren(node);
        this.acceptors.pop();
        for (ObjectIntPair<ParsedInstruction> pair : collector.parsedInstructions()) {
            ParsedInstruction parsedInstruction = (ParsedInstruction)pair.key();
            if (parsedInstruction.supportsCompiler()) {
                program.addBack(parsedInstruction.build(LabelLookup.EMPTY, program));
                continue;
            }
            throw new NeepASM.CompilationException("operation not supported at compile time");
        }
        this.machine.resetCounter();
        while (this.machine.counter() < program.size()) {
            program.get(this.machine.counter()).start(this.machine);
        }
    }

    @Override
    public void visit(PostponeNode node) throws NeepASM.NeepAsmException {
    }

    @Override
    public void visit(LabelNode node) {
        this.label(new Label(node.name(), this.peek().size()));
    }

    @Override
    public void visit(NumberLiteralNode node) {
        this.instruction((labelLookup, program) -> new PushInstruction(node.value()), node.line());
    }

    @Override
    public void visit(InlineNode node) throws NeepASM.CompilationException {
        try {
            this.instruction(node.provider().getParser().parse(new NeepAsmTokenView(node.arguments()), this.neepAsmParser, null), node.line());
        }
        catch (NeepASM.ParseException e) {
            throw new NeepASM.CompilationException(e.getMessage());
        }
    }
}

