/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.neep.meatlib.recipe.MeatRecipeSerialiser;
import com.neep.meatlib.recipe.MeatlibRecipe;
import com.neep.meatlib.recipe.ingredient.RecipeOutput;
import com.neep.meatlib.recipe.ingredient.RecipeOutputImpl;
import com.neep.meatlib.recipe.ingredient.RecipeOutputs;
import com.neep.meatlib.util.MeatLibCodecs;
import com.neep.neepmeat.init.NMrecipeTypes;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2359;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_7923;

public class VivisectionRecipe
implements MeatlibRecipe<VivisectionContext> {
    private final class_2960 id;
    private final class_1299<?> entityType;
    private final int maxHealth;
    private final List<RecipeOutput<class_1792>> output;

    public VivisectionRecipe(class_2960 id, class_1299<?> entityType, int maxHealth, List<RecipeOutput<class_1792>> output) {
        this.id = id;
        this.entityType = entityType;
        this.maxHealth = maxHealth;
        this.output = output;
    }

    @Override
    public boolean matches(VivisectionContext context) {
        return context.entity.method_5864().equals(this.entityType) && context.entity.method_6032() <= (float)this.maxHealth;
    }

    @Override
    public boolean takeInputs(VivisectionContext context, TransactionContext transaction) {
        return true;
    }

    @Override
    public boolean ejectOutputs(VivisectionContext context, TransactionContext transaction) {
        for (RecipeOutput<class_1792> recipeOutput : this.output) {
            class_1792 resource = recipeOutput.resource();
            int amount = (int)recipeOutput.randomAmount(0.0f);
            class_1542 item = new class_1542(context.world, context.pos.field_1352, context.pos.field_1351, context.pos.field_1350, new class_1799((class_1935)resource, amount));
            context.world.method_8649((class_1297)item);
            context.entity.method_5768();
        }
        return true;
    }

    @Override
    public MeatRecipeSerialiser<?> getSerializer() {
        return NMrecipeTypes.VIVISECTION_SERIALISER;
    }

    public class_3956<?> method_17716() {
        return NMrecipeTypes.VIVISECTION;
    }

    @Override
    public class_2960 method_8114() {
        return this.id;
    }

    public class_1299<?> getEntityType() {
        return this.entityType;
    }

    public List<RecipeOutput<class_1792>> getRecipeOutput() {
        return this.output;
    }

    public static class VivisectionContext {
        private final class_1937 world;
        private final class_1309 entity;
        private final class_243 pos;

        public VivisectionContext(class_1937 world, class_1309 entity) {
            this.world = world;
            this.entity = entity;
            this.pos = entity.method_19538().method_1031(0.0, 0.5, 0.0);
        }
    }

    public static class Serializer
    implements MeatRecipeSerialiser<VivisectionRecipe> {
        private final Codec<MeatRecipeSerialiser.RecipeFunction<VivisectionRecipe>> codec = RecordCodecBuilder.create(instance -> instance.group((App)class_7923.field_41177.method_39673().fieldOf("entity").forGetter(MeatLibCodecs::notImplemented), (App)Codec.INT.fieldOf("max_health").forGetter(MeatLibCodecs::notImplemented), (App)Codec.list(RecipeOutputs.ITEM).fieldOf("output").forGetter(MeatLibCodecs::notImplemented)).apply((Applicative)instance, (e, h, o) -> id -> new VivisectionRecipe(id, (class_1299<?>)e, (int)h, (List<RecipeOutput<class_1792>>)o)));

        @Override
        public Codec<MeatRecipeSerialiser.RecipeFunction<VivisectionRecipe>> codec() {
            return this.codec;
        }

        @Override
        public VivisectionRecipe read(class_2960 id, class_2540 buf) {
            class_1299 type = (class_1299)buf.method_42064((class_2359)class_7923.field_41177);
            int maxHealth = buf.method_10816();
            List<RecipeOutput<class_1792>> output = RecipeOutputImpl.readList(class_7923.field_41178, buf);
            return new VivisectionRecipe(id, type, maxHealth, output);
        }

        @Override
        public void write(class_2540 buf, VivisectionRecipe recipe) {
            buf.method_42065((class_2359)class_7923.field_41177, recipe.entityType);
            buf.method_10804(recipe.maxHealth);
            RecipeOutputImpl.writeList(class_7923.field_41178, recipe.output, buf);
        }
    }
}

