/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.neep.meatlib.recipe.MeatRecipeSerialiser;
import com.neep.meatlib.recipe.ingredient.RecipeInputs;
import com.neep.meatlib.recipe.ingredient.RecipeOutput;
import com.neep.meatlib.recipe.ingredient.RecipeOutputImpl;
import com.neep.meatlib.recipe.ingredient.RecipeOutputs;
import com.neep.meatlib.recipe.ingredient.RegistryRecipeInput;
import com.neep.meatlib.util.MeatLibCodecs;
import com.neep.neepmeat.init.NMrecipeTypes;
import com.neep.neepmeat.machine.crucible.CrucibleStorage;
import com.neep.neepmeat.recipe.RenderingBasinRecipe;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1792;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3956;
import net.minecraft.class_7923;

public class RenderingRecipe
implements RenderingBasinRecipe {
    protected class_2960 id;
    protected RegistryRecipeInput<class_1792> itemInput;
    protected RegistryRecipeInput<class_3611> fluidInput;
    protected RecipeOutput<class_3611> fluidOutput;

    public RenderingRecipe(class_2960 id, RegistryRecipeInput<class_1792> itemInput, RegistryRecipeInput<class_3611> fluidInput, RecipeOutput<class_3611> fluidOutput) {
        this.itemInput = itemInput;
        this.fluidInput = fluidInput;
        this.fluidOutput = fluidOutput;
        this.id = id;
    }

    @Override
    public boolean matches(CrucibleStorage inventory) {
        return this.itemInput.testStorage(inventory.getItemStorage(null)) && this.fluidInput.testStorage(inventory.getStorage(null));
    }

    @Override
    public boolean takeInputs(CrucibleStorage context, TransactionContext transaction) {
        return false;
    }

    @Override
    public boolean ejectOutputs(CrucibleStorage context, TransactionContext transaction) {
        return false;
    }

    @Override
    public boolean method_8113(int width, int height) {
        return false;
    }

    public RegistryRecipeInput<class_1792> getItemInput() {
        return this.itemInput;
    }

    public RegistryRecipeInput<class_3611> getFluidInput() {
        return this.fluidInput;
    }

    public RecipeOutput<class_3611> getFluidOutput() {
        return this.fluidOutput;
    }

    @Override
    public class_2960 method_8114() {
        return this.id;
    }

    @Override
    public MeatRecipeSerialiser<?> getSerializer() {
        return NMrecipeTypes.RENDERING_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return NMrecipeTypes.RENDERING;
    }

    @Override
    public ItemVariant takeInputs(CrucibleStorage storage, int amount, TransactionContext transaction) {
        ItemVariant item;
        block18: {
            item = null;
            try (Transaction take = transaction.openNested();){
                Storage<ItemVariant> itemStorage = storage.getItemStorage(null);
                Storage<FluidVariant> fluidStorage = storage.getStorage(null);
                item = this.itemInput.getFirstMatching(itemStorage, ItemVariant::of).orElse(null);
                Optional<FluidVariant> fluid = this.fluidInput.getFirstMatching(fluidStorage, FluidVariant::of);
                if (item == null || fluid.isEmpty()) {
                    ItemVariant itemVariant = null;
                    return itemVariant;
                }
                long ex1 = itemStorage.extract((Object)item, this.itemInput.amount() * (long)amount, (TransactionContext)take);
                long ex2 = fluidStorage.extract((Object)fluid.get(), this.fluidInput.amount() * (long)amount, (TransactionContext)take);
                if (ex1 == this.itemInput.amount() * (long)amount && ex2 == this.fluidInput.amount() * (long)amount) {
                    take.commit();
                    break block18;
                }
                take.abort();
                ItemVariant itemVariant = null;
                return itemVariant;
            }
        }
        try (Transaction eject = transaction.openNested();){
            boolean bl1 = true;
            for (int i = 0; i < amount; ++i) {
                bl1 = bl1 && this.fluidOutput.insertInto(storage.getFluidOutput(), FluidVariant::of, (TransactionContext)eject);
            }
            if (bl1) {
                eject.commit();
                ItemVariant itemVariant = item;
                return itemVariant;
            }
            eject.abort();
        }
        return null;
    }

    public static class Serializer
    implements MeatRecipeSerialiser<RenderingRecipe> {
        private final RecipeFactory<RenderingRecipe> factory;
        private final Codec<MeatRecipeSerialiser.RecipeFunction<RenderingRecipe>> codec;

        public Serializer(RecipeFactory<RenderingRecipe> recipeFactory) {
            this.factory = recipeFactory;
            this.codec = RecordCodecBuilder.create(instance -> instance.group((App)RecipeInputs.ITEM.codec().fieldOf("item_input").forGetter(MeatLibCodecs::notImplemented), (App)RecipeInputs.FLUID.codec().fieldOf("fluid_input").forGetter(MeatLibCodecs::notImplemented), (App)RecipeOutputs.FLUID.fieldOf("output").forGetter(MeatLibCodecs::notImplemented)).apply((Applicative)instance, (ii, fi, o) -> id -> new RenderingRecipe(id, (RegistryRecipeInput<class_1792>)ii, (RegistryRecipeInput<class_3611>)fi, (RecipeOutput<class_3611>)o)));
        }

        @Override
        public Codec<MeatRecipeSerialiser.RecipeFunction<RenderingRecipe>> codec() {
            return this.codec;
        }

        @Override
        public RenderingRecipe read(class_2960 id, class_2540 buf) {
            RegistryRecipeInput<class_1792> itemInput = RegistryRecipeInput.fromBuffer(buf);
            RegistryRecipeInput<class_3611> fluidInput = RegistryRecipeInput.fromBuffer(buf);
            RecipeOutputImpl<class_3611> fluidOutput = RecipeOutputImpl.read(class_7923.field_41173, buf);
            return this.factory.create(id, itemInput, fluidInput, fluidOutput);
        }

        @Override
        public void write(class_2540 buf, RenderingRecipe recipe) {
            recipe.itemInput.write(buf);
            recipe.fluidInput.write(buf);
            recipe.fluidOutput.write(buf);
        }

        @FunctionalInterface
        public static interface RecipeFactory<T extends RenderingRecipe> {
            public T create(class_2960 var1, RegistryRecipeInput<class_1792> var2, RegistryRecipeInput<class_3611> var3, RecipeOutput<class_3611> var4);
        }
    }
}

