/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.neep.meatlib.recipe.MeatRecipeSerialiser;
import com.neep.meatlib.recipe.ingredient.RecipeInputs;
import com.neep.meatlib.recipe.ingredient.RecipeOutput;
import com.neep.meatlib.recipe.ingredient.RecipeOutputImpl;
import com.neep.meatlib.recipe.ingredient.RecipeOutputs;
import com.neep.meatlib.recipe.ingredient.RegistryRecipeInput;
import com.neep.meatlib.util.MeatLibCodecs;
import com.neep.neepmeat.api.processing.OreFatRegistry;
import com.neep.neepmeat.init.NMrecipeTypes;
import com.neep.neepmeat.machine.crucible.CrucibleStorage;
import com.neep.neepmeat.recipe.RenderingBasinRecipe;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3956;
import net.minecraft.class_7923;

public class OreFatRenderingRecipe
implements RenderingBasinRecipe {
    protected class_2960 id;
    protected RegistryRecipeInput<class_3611> fluidInput;
    protected RecipeOutput<class_3611> fluidOutput;

    public OreFatRenderingRecipe(class_2960 id, RegistryRecipeInput<class_3611> fluidInput, RecipeOutput<class_3611> fluidOutput) {
        this.fluidInput = fluidInput;
        this.fluidOutput = fluidOutput;
        this.id = id;
    }

    @Override
    public boolean matches(CrucibleStorage inventory) {
        boolean rightFluid = this.fluidInput.testStorage(inventory.getStorage(null));
        if (rightFluid) {
            for (StorageView view : inventory.getItemStorage(null).nonEmptyViews()) {
                if (OreFatRegistry.getFromRecipeInput((ItemVariant)view.getResource()) == null) continue;
                return true;
            }
        }
        return false;
    }

    public RegistryRecipeInput<class_3611> getFluidInput() {
        return this.fluidInput;
    }

    public RecipeOutput<class_3611> getFluidOutput() {
        return this.fluidOutput;
    }

    @Override
    public class_2960 method_8114() {
        return this.id;
    }

    @Override
    public MeatRecipeSerialiser<?> getSerializer() {
        return NMrecipeTypes.ORE_FAT_RENDERING_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return NMrecipeTypes.ORE_FAT_RENDERING;
    }

    @Override
    public ItemVariant takeInputs(CrucibleStorage storage, int itemAmount, TransactionContext transaction) {
        OreFatRegistry.Entry entry;
        ItemVariant item;
        block20: {
            Storage<ItemVariant> itemStorage = storage.getItemStorage(null);
            Storage<FluidVariant> fluidStorage = storage.getStorage(null);
            item = null;
            for (StorageView view : itemStorage.nonEmptyViews()) {
                if (OreFatRegistry.getFromRecipeInput((ItemVariant)view.getResource()) == null) continue;
                item = (ItemVariant)view.getResource();
            }
            if (item == null) {
                return null;
            }
            entry = OreFatRegistry.getFromRecipeInput(item);
            try (Transaction take = transaction.openNested();){
                Optional<class_3611> fluid = this.fluidInput.getFirstMatching(fluidStorage, (TransactionContext)take);
                if (entry == null || fluid.isEmpty()) {
                    ItemVariant itemVariant = null;
                    return itemVariant;
                }
                long ex1 = itemStorage.extract((Object)item, (long)itemAmount, (TransactionContext)take);
                long ex2 = fluidStorage.extract((Object)FluidVariant.of((class_3611)fluid.get()), this.fluidInput.amount() * (long)itemAmount, (TransactionContext)take);
                if (ex1 == (long)itemAmount && ex2 == this.fluidInput.amount() * (long)itemAmount) {
                    take.commit();
                    break block20;
                }
                take.abort();
                ItemVariant itemVariant = null;
                return itemVariant;
            }
        }
        try (Transaction eject = transaction.openNested();){
            boolean bl1 = true;
            FluidVariant outputVariant = FluidVariant.of((class_3611)this.fluidOutput.resource(), (class_2487)entry.nbt());
            for (int i = 0; i < itemAmount; ++i) {
                bl1 = bl1 && storage.getFluidOutput().insert((Object)outputVariant, 9000L * this.fluidOutput.randomAmount(entry.renderingYield() - 1.0f), (TransactionContext)eject) > 0L;
            }
            if (bl1) {
                eject.commit();
                ItemVariant itemVariant = item;
                return itemVariant;
            }
            eject.abort();
        }
        return null;
    }

    public static class Serializer
    implements MeatRecipeSerialiser<OreFatRenderingRecipe> {
        RecipeFactory<OreFatRenderingRecipe> factory;
        private final Codec<MeatRecipeSerialiser.RecipeFunction<OreFatRenderingRecipe>> codec;

        public Serializer(RecipeFactory<OreFatRenderingRecipe> recipeFactory) {
            this.factory = recipeFactory;
            this.codec = RecordCodecBuilder.create(instance -> instance.group((App)RecipeInputs.FLUID.codec().fieldOf("fluid_input").forGetter(MeatLibCodecs::notImplemented), (App)RecipeOutputs.FLUID.fieldOf("output").forGetter(MeatLibCodecs::notImplemented)).apply((Applicative)instance, (i, o) -> id -> this.factory.create(id, (RegistryRecipeInput<class_3611>)i, (RecipeOutput<class_3611>)o)));
        }

        @Override
        public Codec<MeatRecipeSerialiser.RecipeFunction<OreFatRenderingRecipe>> codec() {
            return this.codec;
        }

        @Override
        public OreFatRenderingRecipe read(class_2960 id, class_2540 buf) {
            RegistryRecipeInput<class_3611> fluidInput = RegistryRecipeInput.fromBuffer(buf);
            RecipeOutputImpl<class_3611> fluidOutput = RecipeOutputImpl.read(class_7923.field_41173, buf);
            return this.factory.create(id, fluidInput, fluidOutput);
        }

        @Override
        public void write(class_2540 buf, OreFatRenderingRecipe recipe) {
            recipe.fluidInput.write(buf);
            recipe.fluidOutput.write(buf);
        }

        @FunctionalInterface
        public static interface RecipeFactory<T extends OreFatRenderingRecipe> {
            public T create(class_2960 var1, RegistryRecipeInput<class_3611> var2, RecipeOutput<class_3611> var3);
        }
    }
}

