/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.neep.meatlib.recipe.MeatRecipeSerialiser;
import com.neep.meatlib.recipe.MeatlibRecipe;
import com.neep.meatlib.recipe.ingredient.RecipeInputs;
import com.neep.meatlib.recipe.ingredient.RecipeOutput;
import com.neep.meatlib.recipe.ingredient.RecipeOutputImpl;
import com.neep.meatlib.recipe.ingredient.RecipeOutputs;
import com.neep.meatlib.recipe.ingredient.RegistryRecipeInput;
import com.neep.meatlib.util.MeatLibCodecs;
import com.neep.neepmeat.api.DataResource;
import com.neep.neepmeat.api.storage.WritableStackStorage;
import com.neep.neepmeat.init.NMrecipeTypes;
import com.neep.neepmeat.machine.integrator.Integrator;
import com.neep.neepmeat.machine.pedestal.PedestalBlockEntity;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_7923;

public class EnlighteningRecipe
implements MeatlibRecipe<PedestalBlockEntity.RecipeBehaviour> {
    protected class_2960 id;
    protected RegistryRecipeInput<class_1792> itemInput;
    protected RecipeOutput<class_1792> itemOutput;
    protected long data;

    public EnlighteningRecipe(class_2960 id, RegistryRecipeInput<class_1792> fluidInput, RecipeOutput<class_1792> itemOutput, long data) {
        this.itemInput = fluidInput;
        this.itemOutput = itemOutput;
        this.data = data;
        this.id = id;
    }

    @Override
    public boolean matches(PedestalBlockEntity.RecipeBehaviour inventory) {
        return this.itemInput.test(inventory.getStorage()) && inventory.getIntegrator() != null && inventory.getIntegrator().getData(DataResource.NORMAL) >= this.data;
    }

    public RegistryRecipeInput<class_1792> getItemInput() {
        return this.itemInput;
    }

    @Override
    public class_2960 method_8114() {
        return this.id;
    }

    @Override
    public MeatRecipeSerialiser<?> getSerializer() {
        return NMrecipeTypes.ENLIGHTENING_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return NMrecipeTypes.ENLIGHTENING;
    }

    @Override
    public boolean takeInputs(PedestalBlockEntity.RecipeBehaviour context, TransactionContext transaction) {
        return true;
    }

    @Override
    public boolean ejectOutputs(PedestalBlockEntity.RecipeBehaviour context, TransactionContext transaction) {
        try (Transaction inner = transaction.openNested();){
            WritableStackStorage stackStorage = context.getStorage();
            long amount = stackStorage.getAmount();
            class_1792 input = this.itemInput.getFirstMatching(stackStorage).orElse(null);
            Integrator integrator = context.getIntegrator();
            if (integrator == null) {
                boolean bl = false;
                return bl;
            }
            float storedData = integrator.getData(DataResource.NORMAL);
            if (input == null || storedData < (float)this.data) {
                boolean bl = false;
                return bl;
            }
            long ext = stackStorage.extract((TransferVariant)((ItemVariant)stackStorage.getResource()), amount * this.itemInput.amount(), (TransactionContext)inner);
            float dataExt = integrator.extract(DataResource.NORMAL, amount * this.data, transaction);
            if (ext != amount * this.itemInput.amount() || dataExt != (float)(amount * this.data)) {
                inner.abort();
                boolean bl = false;
                return bl;
            }
            long outputAmount = amount * this.itemOutput.randomAmount(0.0f);
            long ins = stackStorage.insert((TransferVariant)ItemVariant.of((class_1935)((class_1935)this.itemOutput.resource())), outputAmount, (TransactionContext)inner);
            if (ins == outputAmount) {
                inner.commit();
                boolean bl = true;
                return bl;
            }
            inner.abort();
        }
        return false;
    }

    public RecipeOutput<class_1792> getItemOutput() {
        return this.itemOutput;
    }

    public long getData() {
        return this.data;
    }

    public static class Serializer
    implements MeatRecipeSerialiser<EnlighteningRecipe> {
        private final Codec<MeatRecipeSerialiser.RecipeFunction<EnlighteningRecipe>> codec = RecordCodecBuilder.create(instance -> instance.group((App)RecipeInputs.ITEM.codec().fieldOf("item_input").forGetter(MeatLibCodecs::notImplemented), (App)RecipeOutputs.ITEM.fieldOf("output").forGetter(MeatLibCodecs::notImplemented), (App)Codec.INT.fieldOf("data").forGetter(MeatLibCodecs::notImplemented)).apply((Applicative)instance, (i, o, d) -> id -> new EnlighteningRecipe(id, (RegistryRecipeInput<class_1792>)i, (RecipeOutput<class_1792>)o, d.intValue())));

        @Override
        public Codec<MeatRecipeSerialiser.RecipeFunction<EnlighteningRecipe>> codec() {
            return this.codec;
        }

        @Override
        public EnlighteningRecipe read(class_2960 id, class_2540 buf) {
            RegistryRecipeInput<class_1792> itemInput = RegistryRecipeInput.fromBuffer(buf);
            RecipeOutputImpl<class_1792> itemOutput = RecipeOutputImpl.read(class_7923.field_41178, buf);
            long data = buf.method_10792();
            return new EnlighteningRecipe(id, itemInput, itemOutput, data);
        }

        @Override
        public void write(class_2540 buf, EnlighteningRecipe recipe) {
            recipe.itemInput.write(buf);
            recipe.itemOutput.write(buf);
            buf.method_10791(recipe.data);
        }

        @FunctionalInterface
        public static interface RecipeFactory<T extends EnlighteningRecipe> {
            public T create(class_2960 var1, RegistryRecipeInput<class_1792> var2, RecipeOutputImpl<class_1792> var3, long var4);
        }
    }
}

