/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.neep.meatlib.recipe.MeatRecipeSerialiser;
import com.neep.meatlib.recipe.MeatRecipeType;
import com.neep.meatlib.recipe.ingredient.RecipeInputs;
import com.neep.meatlib.recipe.ingredient.RecipeOutput;
import com.neep.meatlib.util.MeatLibCodecs;
import com.neep.neepmeat.api.processing.BlockCrushingRegistry;
import com.neep.neepmeat.init.NMrecipeTypes;
import com.neep.neepmeat.machine.grinder.CrusherRecipeContext;
import com.neep.neepmeat.recipe.AdvancedCrushingRecipe;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class BlockCrushingRecipe
extends AdvancedCrushingRecipe {
    private final long mainAmount;
    private final long extraAmount;
    private final float outputChance;
    public static final BlockCrushingRecipe INSTANCE = new BlockCrushingRecipe(new class_2960("neepmeat", "block_crushing/instance"), 1L, 1L, 0.5f);

    public BlockCrushingRecipe(class_2960 id, long mainAmount, long extraAmount, float outputChance) {
        super(id, RecipeInputs.empty(), RecipeOutput.empty(), RecipeOutput.empty(), 5.0f, 40);
        this.mainAmount = mainAmount;
        this.extraAmount = extraAmount;
        this.outputChance = outputChance;
    }

    @Nullable
    protected BlockCrushingRegistry.Entry getFromInput(ItemVariant input) {
        return BlockCrushingRegistry.INSTANCE.getFromInputBasic(input);
    }

    @Override
    public boolean matches(CrusherRecipeContext storage) {
        for (StorageView view : storage.getInputStorage()) {
            if (this.getFromInput((ItemVariant)view.getResource()) == null) continue;
            return true;
        }
        return super.matches(storage);
    }

    @Override
    public boolean takeInputs(CrusherRecipeContext storage, TransactionContext transaction) {
        for (StorageView view : storage.getInputStorage()) {
            ItemVariant resource = (ItemVariant)view.getResource();
            BlockCrushingRegistry.Entry entry = this.getFromInput(resource);
            if (entry == null) continue;
            class_1792 item = resource.getItem();
            try (Transaction inner = transaction.openNested();){
                long extracted = storage.getInputStorage().extract((Object)ItemVariant.of((class_1935)item), entry.input().amount(), (TransactionContext)inner);
                if (extracted == entry.input().amount()) {
                    inner.commit();
                    boolean bl = true;
                    return bl;
                }
                inner.abort();
            }
            return false;
        }
        return false;
    }

    @Override
    public MeatRecipeSerialiser<?> getSerializer() {
        return NMrecipeTypes.BLOCK_CRUSHING_SERIALIZER;
    }

    @Override
    public MeatRecipeType<?> getType() {
        return NMrecipeTypes.GRINDING;
    }

    @Override
    public boolean ejectOutputs(CrusherRecipeContext storage, TransactionContext transaction) {
        for (StorageView view : storage.getInputStorage()) {
            ItemVariant resource = (ItemVariant)view.getResource();
            BlockCrushingRegistry.Entry entry = this.getFromInput(resource);
            if (entry == null) continue;
            try (Transaction inner = transaction.openNested();){
                boolean b1 = entry.output().insertInto(storage.getOutputStorage(), ItemVariant::of, (TransactionContext)inner);
                boolean b2 = entry.extra().insertInto(storage.getOutputStorage(), ItemVariant::of, storage.getChanceMod(), (TransactionContext)inner);
                if (b1 && b2) {
                    inner.commit();
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }
        return false;
    }

    public long getBaseAmount() {
        return this.mainAmount;
    }

    public long getExtraAmount() {
        return this.extraAmount;
    }

    public float getChance() {
        return this.outputChance;
    }

    public static class Serialiser<T extends BlockCrushingRecipe>
    implements MeatRecipeSerialiser<T> {
        private final Constructor<T> constructor;
        private final Codec<MeatRecipeSerialiser.RecipeFunction<T>> codec;

        public Serialiser(Constructor<T> constructor) {
            this.constructor = constructor;
            this.codec = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("base_amount").forGetter(MeatLibCodecs::notImplemented), (App)Codec.LONG.fieldOf("extra_amount").forGetter(MeatLibCodecs::notImplemented), (App)Codec.FLOAT.fieldOf("extra_chance").forGetter(MeatLibCodecs::notImplemented)).apply((Applicative)instance, (b, e, c) -> id -> constructor.create(id, (long)b, (long)e, c.floatValue())));
        }

        @Override
        public Codec<MeatRecipeSerialiser.RecipeFunction<T>> codec() {
            return this.codec;
        }

        @Override
        public T read(class_2960 id, class_2540 buf) {
            return this.constructor.create(id, buf.readLong(), buf.readLong(), buf.readFloat());
        }

        @Override
        public void write(class_2540 buf, BlockCrushingRecipe recipe) {
            buf.writeLong(recipe.mainAmount);
            buf.writeLong(recipe.extraAmount);
            buf.writeFloat(recipe.outputChance);
        }

        @FunctionalInterface
        public static interface Constructor<T extends BlockCrushingRecipe> {
            public T create(class_2960 var1, long var2, long var4, float var6);
        }
    }
}

