/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.neep.meatlib.recipe.MeatRecipeSerialiser;
import com.neep.meatlib.recipe.MeatRecipeType;
import com.neep.meatlib.recipe.ingredient.RecipeInputs;
import com.neep.meatlib.recipe.ingredient.RecipeOutput;
import com.neep.meatlib.recipe.ingredient.RecipeOutputImpl;
import com.neep.meatlib.recipe.ingredient.RecipeOutputs;
import com.neep.meatlib.recipe.ingredient.entity.EntityRecipeInput;
import com.neep.meatlib.util.MeatLibCodecs;
import com.neep.neepmeat.api.plc.recipe.ManufactureStep;
import com.neep.neepmeat.api.plc.recipe.Workpiece;
import com.neep.neepmeat.init.NMComponents;
import com.neep.neepmeat.plc.component.MutateInPlace;
import com.neep.neepmeat.plc.recipe.EntityMutateRecipe;
import com.neep.neepmeat.plc.recipe.ItemManufactureRecipe;
import com.neep.neepmeat.plc.recipe.PLCRecipes;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class EntityToItemRecipe
extends EntityMutateRecipe {
    private final RecipeOutput<class_1792> output;

    public EntityToItemRecipe(class_2960 id, EntityRecipeInput base, List<ManufactureStep<?>> steps, RecipeOutput<class_1792> output) {
        super(id, base, steps);
        this.output = output;
    }

    @Override
    public boolean matches(MutateInPlace<class_1297> context) {
        class_1297 entity = context.get();
        if (!this.base.test(entity)) {
            return false;
        }
        Workpiece workpiece = (Workpiece)NMComponents.WORKPIECE.getNullable((Object)entity);
        if (workpiece != null) {
            List<ManufactureStep<?>> workSteps = workpiece.getSteps();
            if (workSteps.size() < this.steps.size()) {
                return false;
            }
            int difference = workSteps.size() - this.steps.size();
            for (int i = this.steps.size() - 1; i >= 0; --i) {
                ManufactureStep<?> workStep = workSteps.get(i + difference);
                ManufactureStep recipeStep = (ManufactureStep)this.steps.get(i);
                if (ManufactureStep.matches(recipeStep, workStep)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public EntityRecipeInput getBase() {
        return this.base;
    }

    @Override
    public List<ManufactureStep<?>> getSteps() {
        return this.steps;
    }

    @Override
    public boolean takeInputs(MutateInPlace<class_1297> context, TransactionContext transaction) {
        return false;
    }

    @Override
    public boolean ejectOutputs(MutateInPlace<class_1297> context, TransactionContext transaction) {
        class_1297 entity = context.get();
        class_243 pos = entity.method_19538();
        class_1937 world = entity.method_37908();
        int amount = (int)this.output.randomAmount(0.0f);
        class_1799 stack = new class_1799((class_1935)this.output.resource(), amount);
        world.method_8649((class_1297)new class_1542(world, pos.field_1352, pos.field_1351 + 0.1, pos.field_1350, stack, 0.0, 0.1, 0.0));
        entity.method_31472();
        return false;
    }

    public MeatRecipeType<?> getType() {
        return PLCRecipes.ENTITY_TO_ITEM;
    }

    @Override
    public MeatRecipeSerialiser<?> getSerializer() {
        return PLCRecipes.ENTITY_TO_ITEM_SERIALISER;
    }

    public RecipeOutput<class_1792> getRecipeOutput() {
        return this.output;
    }

    public static class Serialiser
    implements MeatRecipeSerialiser<EntityToItemRecipe> {
        private final Codec<MeatRecipeSerialiser.RecipeFunction<EntityToItemRecipe>> codec = RecordCodecBuilder.create(instance -> instance.group((App)RecipeInputs.ENTITY.codec().fieldOf("base").forGetter(MeatLibCodecs::notImplemented), (App)ManufactureStep.LIST_CODEC.fieldOf("steps").forGetter(MeatLibCodecs::notImplemented), (App)RecipeOutputs.ITEM.fieldOf("result").forGetter(MeatLibCodecs::notImplemented)).apply((Applicative)instance, (b, s, r) -> id -> new EntityToItemRecipe(id, (EntityRecipeInput)b, (List<ManufactureStep<?>>)s, (RecipeOutput<class_1792>)r)));

        @Override
        public Codec<MeatRecipeSerialiser.RecipeFunction<EntityToItemRecipe>> codec() {
            return this.codec;
        }

        @Override
        public EntityToItemRecipe read(class_2960 id, class_2540 buf) {
            EntityRecipeInput base = RecipeInputs.ENTITY.fromBuffer(buf);
            List<ManufactureStep<?>> steps = ItemManufactureRecipe.Serialiser.readSteps(buf);
            RecipeOutputImpl<class_1792> output = RecipeOutputImpl.read(class_7923.field_41178, buf);
            return new EntityToItemRecipe(id, base, steps, output);
        }

        @Override
        public void write(class_2540 buf, EntityToItemRecipe recipe) {
            recipe.base.write(buf);
            ItemManufactureRecipe.Serialiser.writeSteps(recipe.getSteps(), buf);
            recipe.output.write(buf);
        }
    }
}

