/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.processor;

import com.neep.meatlib.util.NbtSerialisable;
import com.neep.neepmeat.api.plc.memory.MemoryManager;
import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.neepasm.vm.DataStack;
import com.neep.neepmeat.plc.memory.MemoryEntry;
import com.neep.neepmeat.plc.processor.VariableStack;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Objects;
import net.minecraft.class_2487;
import org.jetbrains.annotations.NotNull;

public class PLCMemory
implements MemoryManager,
NbtSerialisable {
    private final ObjectArrayList<MemoryEntry> entries = new ObjectArrayList();
    private final int maxSize = 32;
    private final VariableStack stack;

    public PLCMemory(VariableStack stack) {
        this.stack = stack;
        this.clear();
    }

    @Override
    public void clear() {
        this.entries.clear();
        this.entries.add(null);
    }

    @Override
    public int allocate(MemoryEntry entry) throws NeepASM.RuntimeException {
        for (int i = 1; i <= this.entries.size(); ++i) {
            if (i == 32) {
                this.gc();
                i = 0;
            }
            if (i == this.entries.size()) {
                this.size(this.entries.size() + 1);
                this.entries.add(i, (Object)entry);
                return i;
            }
            if (this.entries.get(i) != null) continue;
            this.entries.set(i, (Object)entry);
            return i;
        }
        return 0;
    }

    @Override
    public void allocate(int size) throws NeepASM.RuntimeException {
        this.size(this.entries.size() + size);
    }

    @Override
    public void store(int address, int data) throws NeepASM.RuntimeException {
        int stripped = Prefix.strip(address);
        this.size(Math.max(this.entries.size(), stripped + 1));
        this.entries.set(stripped, (Object)new MemoryEntry.IntegerEntry(data));
    }

    private void size(int size) throws NeepASM.RuntimeException {
        if (size > 32) {
            throw new NeepASM.RuntimeException(String.format("Out of memory: address %s is greater than %s", size, 32));
        }
        this.entries.size(size);
    }

    @Override
    public void free(int pointer) {
        if (pointer > 0 && pointer < this.entries.size()) {
            this.entries.set(pointer, null);
        }
    }

    @Override
    public MemoryEntry fetch(int address) {
        Prefix prefix = Prefix.get(address);
        return switch (prefix) {
            default -> throw new IncompatibleClassChangeError();
            case Prefix.PROGRAM -> MemoryEntry.NULL;
            case Prefix.PROGRAM_DATA -> MemoryEntry.NULL;
            case Prefix.VARIABLE -> this.getInternal(Prefix.strip(address));
            case Prefix.RESERVED -> MemoryEntry.NULL;
        };
    }

    @NotNull
    private MemoryEntry getInternal(int address) {
        if (address < this.entries.size()) {
            return Objects.requireNonNullElse((MemoryEntry)this.entries.get(address), MemoryEntry.NULL);
        }
        return MemoryEntry.NULL;
    }

    public void gc() throws NeepASM.RuntimeException {
        int i;
        IntOpenHashSet pointers = new IntOpenHashSet();
        for (i = 0; i < this.stack.size(); ++i) {
            DataStack.Entry entry = this.stack.peek(i);
            if (!entry.pointer()) continue;
            pointers.add(entry.value());
        }
        for (i = this.entries.size() - 1; i >= 0; --i) {
            if (pointers.contains(i)) continue;
            this.entries.set(i, null);
        }
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        ByteBuf bb = Unpooled.buffer();
        this.write(bb);
        byte[] bytes = new byte[bb.writerIndex()];
        bb.getBytes(0, bytes);
        nbt.method_10570("memory", bytes);
        return nbt;
    }

    @Override
    public void readNbt(class_2487 nbt) {
        byte[] memory = nbt.method_10547("memory");
        ByteBuf bb = Unpooled.wrappedBuffer((byte[])memory);
        this.read(bb);
    }

    public void write(ByteBuf bb) {
        bb.writeInt(this.entries.size());
        for (MemoryEntry entry : this.entries) {
            MemoryEntry.write(entry, bb);
        }
    }

    public void read(ByteBuf bb) {
        this.entries.clear();
        if (bb.capacity() > 4) {
            int size = bb.readInt();
            for (int i = 0; i < size; ++i) {
                this.entries.add((Object)MemoryEntry.read(bb));
            }
        }
    }

    public static enum Prefix {
        VARIABLE(0),
        PROGRAM(1),
        PROGRAM_DATA(2),
        RESERVED(3);

        public static final int ADDRESS_BITS = 14;
        public static final int ADDRESS_MASK = 16383;
        public final int prefix;

        public static Prefix get(int address) {
            int prefix = address >> 14 & 3;
            return Prefix.values()[prefix];
        }

        private Prefix(int prefix) {
            this.prefix = prefix;
        }

        public static int strip(int address) {
            return address & 0x3FFF;
        }

        public int encode(int address) {
            return address & 0x3FFF | this.prefix << 14;
        }
    }
}

