/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.instruction.memory;

import com.neep.meatlib.util.NeepAsmTokenView;
import com.neep.neepmeat.api.plc.PLC;
import com.neep.neepmeat.api.plc.memory.MemoryProvider;
import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.neepasm.compiler.NeepAsmParser;
import com.neep.neepmeat.neepasm.compiler.parser.PlcParsedInstruction;
import com.neep.neepmeat.neepasm.vm.DataStack;
import com.neep.neepmeat.plc.Instructions;
import com.neep.neepmeat.plc.instruction.Argument;
import com.neep.neepmeat.plc.instruction.InstructionProvider;
import com.neep.neepmeat.plc.instruction.PlcInstruction;
import com.neep.neepmeat.plc.memory.MemoryEntry;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import org.jetbrains.annotations.NotNull;

public class ExtStoreInstruction
implements PlcInstruction {
    private final Supplier<class_1937> world;
    private final Argument argument;

    public ExtStoreInstruction(Supplier<class_1937> world, class_2487 nbt) {
        this(world, Argument.fromNbt(nbt.method_10562("target")));
    }

    public ExtStoreInstruction(Supplier<class_1937> world, Argument argument) {
        this.world = world;
        this.argument = argument;
    }

    @Override
    public void start(PLC plc) throws NeepASM.RuntimeException {
        DataStack stack = plc.dataStack();
        class_2586 class_25862 = this.world.get().method_8321(this.argument.pos());
        if (class_25862 instanceof MemoryProvider) {
            MemoryProvider memoryProvider = (MemoryProvider)class_25862;
            DataStack.Entry entry = plc.dataStack().pop();
            if (entry.pointer()) {
                MemoryEntry memEntry = plc.getMemory().fetch(entry.value());
                memoryProvider.push(memEntry);
            } else {
                memoryProvider.push(new MemoryEntry.IntegerEntry(stack.popInt()));
            }
        } else {
            throw new NeepASM.RuntimeException("EXTSTORE: Block provides no memory");
        }
        plc.advanceCounter();
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        nbt.method_10566("target", (class_2520)this.argument.toNbt());
        return nbt;
    }

    @Override
    @NotNull
    public InstructionProvider getOpcode() {
        return Instructions.EXTSTORE;
    }

    public static PlcParsedInstruction parser(NeepAsmTokenView view, NeepAsmParser parser, String scope) throws NeepASM.ParseException {
        view.fastForward();
        Argument argument = parser.parseWorldTarget(view);
        if (argument == null) {
            throw new NeepASM.ParseException("Expected world target to store memory in");
        }
        parser.assureLineEnd(view);
        return (world, labelLookup, program) -> program.addBack(new ExtStoreInstruction(() -> world, argument));
    }
}

