/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.instruction.gui;

import com.google.common.collect.Maps;
import com.neep.neepmeat.plc.Instructions;
import com.neep.neepmeat.plc.instruction.InstructionProvider;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_2561;

public class InstructionAttributes {
    private static final Map<InstructionProvider, InstructionTooltip> TOOLTIPS = Maps.newHashMap();

    public static void register(InstructionProvider provider, InstructionTooltip tooltip) {
        TOOLTIPS.put(provider, tooltip);
    }

    private static void register(InstructionProvider provider, Category category) {
        InstructionAttributes.register(provider, new InstructionTooltip().tooltip((class_2561)class_2561.method_43471((String)("instruction.neepmeat." + provider.getParseName().toLowerCase(Locale.ROOT) + ".desc"))).category(category));
    }

    public static InstructionTooltip get(InstructionProvider provider) {
        return TOOLTIPS.getOrDefault(provider, InstructionTooltip.EMPTY);
    }

    public static void init() {
        InstructionAttributes.register(Instructions.END, Category.CONTROL);
        InstructionAttributes.register(Instructions.RESTART, Category.CONTROL);
        InstructionAttributes.register((InstructionProvider)Instructions.RET, Category.CONTROL);
        InstructionAttributes.register((InstructionProvider)Instructions.CALL, Category.CONTROL);
        InstructionAttributes.register((InstructionProvider)Instructions.IHANDLER, Category.CONTROL);
        InstructionAttributes.register((InstructionProvider)Instructions.IWAIT, Category.CONTROL);
        InstructionAttributes.register((InstructionProvider)Instructions.ICLEAR, Category.CONTROL);
        InstructionAttributes.register((InstructionProvider)Instructions.IENABLE, Category.CONTROL);
        InstructionAttributes.register((InstructionProvider)Instructions.IDISABLE, Category.CONTROL);
        InstructionAttributes.register((InstructionProvider)Instructions.PUSH, Category.VARIABLE);
        InstructionAttributes.register((InstructionProvider)Instructions.POP, Category.VARIABLE);
        InstructionAttributes.register((InstructionProvider)Instructions.DUP, Category.VARIABLE);
        InstructionAttributes.register((InstructionProvider)Instructions.SWAP, Category.VARIABLE);
        InstructionAttributes.register((InstructionProvider)Instructions.OVER, Category.VARIABLE);
        InstructionAttributes.register((InstructionProvider)Instructions.ROT, Category.VARIABLE);
        InstructionAttributes.register((InstructionProvider)Instructions.PICK, Category.VARIABLE);
        InstructionAttributes.register((InstructionProvider)Instructions.TO_RET, Category.VARIABLE);
        InstructionAttributes.register((InstructionProvider)Instructions.FROM_RET, Category.VARIABLE);
        InstructionAttributes.register((InstructionProvider)Instructions.RET_FETCH, Category.VARIABLE);
        InstructionAttributes.register(Instructions.EXTFETCH, Category.VARIABLE);
        InstructionAttributes.register(Instructions.FREE, Category.VARIABLE);
        InstructionAttributes.register(Instructions.STORE, Category.VARIABLE);
        InstructionAttributes.register(Instructions.FETCH, Category.VARIABLE);
        InstructionAttributes.register(Instructions.EXTSTORE, Category.VARIABLE);
        InstructionAttributes.register(Instructions.EXTFETCH, Category.VARIABLE);
        InstructionAttributes.register((InstructionProvider)Instructions.DELAY, Category.CONTROL);
        InstructionAttributes.register((InstructionProvider)Instructions.EQ, Category.COMPARISON);
        InstructionAttributes.register((InstructionProvider)Instructions.LT, Category.COMPARISON);
        InstructionAttributes.register((InstructionProvider)Instructions.LTEQ, Category.COMPARISON);
        InstructionAttributes.register((InstructionProvider)Instructions.GT, Category.COMPARISON);
        InstructionAttributes.register((InstructionProvider)Instructions.GTEQ, Category.COMPARISON);
        InstructionAttributes.register((InstructionProvider)Instructions.INC, Category.ARITHMETIC);
        InstructionAttributes.register((InstructionProvider)Instructions.DEC, Category.ARITHMETIC);
        InstructionAttributes.register((InstructionProvider)Instructions.NEG, Category.ARITHMETIC);
        InstructionAttributes.register((InstructionProvider)Instructions.ADD, Category.ARITHMETIC);
        InstructionAttributes.register((InstructionProvider)Instructions.SUB, Category.ARITHMETIC);
        InstructionAttributes.register((InstructionProvider)Instructions.MUL, Category.ARITHMETIC);
        InstructionAttributes.register((InstructionProvider)Instructions.DIV, Category.ARITHMETIC);
        InstructionAttributes.register((InstructionProvider)Instructions.NOT, Category.ARITHMETIC);
        InstructionAttributes.register((InstructionProvider)Instructions.AND, Category.ARITHMETIC);
        InstructionAttributes.register((InstructionProvider)Instructions.OR, Category.ARITHMETIC);
        InstructionAttributes.register((InstructionProvider)Instructions.NAND, Category.ARITHMETIC);
        InstructionAttributes.register((InstructionProvider)Instructions.NOR, Category.ARITHMETIC);
        InstructionAttributes.register((InstructionProvider)Instructions.XOR, Category.ARITHMETIC);
        InstructionAttributes.register((InstructionProvider)Instructions.XNOR, Category.ARITHMETIC);
        InstructionAttributes.register((InstructionProvider)Instructions.SHR, Category.ARITHMETIC);
        InstructionAttributes.register((InstructionProvider)Instructions.SHL, Category.ARITHMETIC);
        InstructionAttributes.register(Instructions.JUMP, Category.CONTROL);
        InstructionAttributes.register((InstructionProvider)Instructions.BIT, Category.CONTROL);
        InstructionAttributes.register((InstructionProvider)Instructions.BIF, Category.CONTROL);
        InstructionAttributes.register((InstructionProvider)Instructions.SAY, Category.MISC);
        InstructionAttributes.register(Instructions.REMOVE, Category.MANUFACTURE);
        InstructionAttributes.register(Instructions.ROBOT, Category.CONTROL);
        InstructionAttributes.register(Instructions.EXEC, Category.CONTROL);
        InstructionAttributes.register(Instructions.COMBINE, Category.MANUFACTURE);
        InstructionAttributes.register(Instructions.MOVE, Category.MANUFACTURE);
        InstructionAttributes.register(Instructions.IMPLANT, Category.MANUFACTURE);
        InstructionAttributes.register(Instructions.INJECT, Category.MANUFACTURE);
        InstructionAttributes.register(Instructions.WAIT_REDSTONE, Category.REDSTONE);
        InstructionAttributes.register(Instructions.EMIT_REDSTONE, Category.REDSTONE);
        InstructionAttributes.register(Instructions.READ_REDSTONE, Category.REDSTONE);
        InstructionAttributes.register(Instructions.RISING_EDGE, Category.COMPARISON);
        InstructionAttributes.register(Instructions.NEEPBUS_WRITE, Category.NEEPBUS);
        InstructionAttributes.register(Instructions.NEEPBUS_READ, Category.NEEPBUS);
        InstructionAttributes.register((InstructionProvider)Instructions.REQUEST, Category.ROUTING);
        InstructionAttributes.register((InstructionProvider)Instructions.ROUTE, Category.ROUTING);
        InstructionAttributes.register((InstructionProvider)Instructions.COUNT, Category.ROUTING);
        InstructionAttributes.register((InstructionProvider)Instructions.STOCK, Category.ROUTING);
    }

    public static class InstructionTooltip {
        private Category category = Category.MISC;
        private class_2561 description = class_2561.method_43473();
        public static final InstructionTooltip EMPTY = new InstructionTooltip();

        public InstructionTooltip tooltip(class_2561 text) {
            this.description = text;
            return this;
        }

        public InstructionTooltip category(Category category) {
            this.category = category;
            return this;
        }

        public Category category() {
            return this.category;
        }

        public class_2561 description() {
            return this.description;
        }
    }

    public static enum Category {
        ARITHMETIC((class_2561)class_2561.method_43471((String)"category.neepmeat.instruction.arithmetic")),
        MANUFACTURE((class_2561)class_2561.method_43471((String)"category.neepmeat.instruction.manufacture")),
        COMPARISON((class_2561)class_2561.method_43471((String)"category.neepmeat.instruction.comparison")),
        CONTROL((class_2561)class_2561.method_43471((String)"category.neepmeat.instruction.control")),
        VARIABLE((class_2561)class_2561.method_43471((String)"category.neepmeat.instruction.variable")),
        REDSTONE((class_2561)class_2561.method_43471((String)"category.neepmeat.instruction.redstone")),
        NEEPBUS((class_2561)class_2561.method_43471((String)"category.neepmeat.instruction.neepbus")),
        ROUTING((class_2561)class_2561.method_43471((String)"category.neepmeat.instruction.routing")),
        MISC((class_2561)class_2561.method_43471((String)"category.neepmeat.instruction.misc"));

        public final class_2561 name;

        private Category(class_2561 name) {
            this.name = name;
        }
    }
}

